/*
 * Decompiled with CFR 0.152.
 */
package me.rufia.fightorflight.client.renderer;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import me.rufia.fightorflight.client.model.PokemonAreaEffectMagicModel;
import me.rufia.fightorflight.entity.PokemonAttackEffect;
import me.rufia.fightorflight.entity.areaeffect.PokemonAreaEffectMagic;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class PokemonAreaEffectMagicRenderer
extends class_897<PokemonAreaEffectMagic>
implements class_3883<PokemonAreaEffectMagic, PokemonAreaEffectMagicModel<PokemonAreaEffectMagic>> {
    private static final class_2960 LIGHTNING_TEXTURE_LOCATION = class_2960.method_60655((String)"fightorflight", (String)"textures/entity/lightning.png");
    private static final class_2960 ERUPTION_TEXTURE_LOCATION = class_2960.method_60655((String)"fightorflight", (String)"textures/entity/eruption.png");
    private static final class_2960 MAGIC_TEXTURE_LOCATION = class_2960.method_60655((String)"fightorflight", (String)"textures/entity/magic.png");
    private static final class_2960 ERUPTION_FIRE_TEXTURE_LOCATION = class_2960.method_60655((String)"fightorflight", (String)"textures/entity/eruption_fire.png");
    private static final List<String> specialTypes = Arrays.asList("Fire", "Ground", "Electric");
    private final PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> model;

    public PokemonAreaEffectMagicRenderer(class_5617.class_5618 context) {
        super(context);
        this.model = new PokemonAreaEffectMagicModel(context.method_32167(PokemonAreaEffectMagicModel.LAYER_LOCATION));
    }

    public void render(PokemonAreaEffectMagic entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        boolean isWaiting = entity.isWaiting();
        poseStack.method_22903();
        float d = entity.getRadius() * 2.0f;
        poseStack.method_22905(d, d, d);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        poseStack.method_22904(0.0, -0.05, 0.0);
        class_4588 vertexConsumer = buffer.getBuffer(this.model.method_23500(this.getTextureLocation(entity)));
        Color color = PokemonAreaEffectMagicRenderer.getColor(entity);
        int colorCode = class_5253.class_5254.method_59554((float)0.4f, (float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
        this.model.renderBottom(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
        if (!isWaiting) {
            int waitTime = entity.getWaitTime();
            float tick = (float)entity.field_6012 + partialTicks - (float)waitTime;
            if (entity.getElementalType().equals("Electric")) {
                poseStack.method_46416(0.0f, -2.0f, 0.0f);
                float yScale = class_3532.method_37166((float)0.2f, (float)1.0f, (float)(tick / 4.0f));
                poseStack.method_22905(1.0f, yScale, 1.0f);
                this.model.renderBeam(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
            } else {
                float yScale = -class_3532.method_37166((float)0.2f, (float)1.0f, (float)(tick / 4.0f));
                poseStack.method_22904(0.0, 0.2, 0.0);
                poseStack.method_22905(1.0f, yScale, 1.0f);
                this.model.renderBeam(poseStack, vertexConsumer, packedLight, class_4608.field_21444, colorCode);
                class_4588 vertexConsumer1 = buffer.getBuffer(class_1921.method_42600((class_2960)ERUPTION_FIRE_TEXTURE_LOCATION));
                this.model.renderBeam(poseStack, vertexConsumer1, packedLight, class_4608.field_21444, colorCode);
            }
        }
        poseStack.method_22909();
    }

    public class_2960 getTextureLocation(PokemonAreaEffectMagic entity) {
        String typeName;
        return switch (typeName = entity.getElementalType()) {
            case "Electric" -> LIGHTNING_TEXTURE_LOCATION;
            case "Ground", "Fire" -> ERUPTION_TEXTURE_LOCATION;
            default -> MAGIC_TEXTURE_LOCATION;
        };
    }

    public static boolean hasSpecialTexture(PokemonAreaEffectMagic entity) {
        String typeName = entity.getElementalType();
        return specialTypes.contains(typeName);
    }

    public static Color getColor(PokemonAreaEffectMagic entity) {
        return PokemonAreaEffectMagicRenderer.hasSpecialTexture(entity) ? Color.WHITE : PokemonAttackEffect.getColorFromType(entity.getElementalType());
    }

    public PokemonAreaEffectMagicModel<PokemonAreaEffectMagic> getModel() {
        return this.model;
    }
}

