/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.utils;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.item.SizeEssenceItem;
import dev.cudzer.cobblemonsizevariation.network.SizeChangedPacket;
import java.util.Objects;
import kotlin.jvm.functions.Function0;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;

public class SizeItemInteractions {
    private static final class_2960 SIZE_CHANGED_SOUND = class_2960.method_60655((String)"cobblemonsizevariation", (String)"size_changed");

    public static boolean handleEntityInteract(class_1657 player, class_1937 level, class_1268 hand, PokemonEntity target) {
        class_1799 stack = player.method_5998(hand);
        class_1792 class_17922 = stack.method_7909();
        if (!(class_17922 instanceof SizeEssenceItem)) {
            return false;
        }
        SizeEssenceItem sizeItem = (SizeEssenceItem)class_17922;
        if (target.getPokemon().getOwnerUUID() == null) {
            return false;
        }
        if (!target.getPokemon().getOwnerUUID().equals(player.method_5667())) {
            return false;
        }
        if (level.field_9236) {
            return true;
        }
        if (target.getPokemon().getScaleModifier() >= CobblemonSizeVariation.SIZER.getMaxSizeModifier() && sizeItem.getSizeModificationType() == SizeEssenceItem.SizeModificationType.GROW) {
            player.method_7353((class_2561)class_2561.method_43470((String)(SizeItemInteractions.getPokemonName(target) + " is at maximum size!")), true);
            return false;
        }
        if (target.getPokemon().getScaleModifier() <= CobblemonSizeVariation.SIZER.getMinSizeModifier() && sizeItem.getSizeModificationType() == SizeEssenceItem.SizeModificationType.SHRINK) {
            player.method_7353((class_2561)class_2561.method_43470((String)(SizeItemInteractions.getPokemonName(target) + " is at minimum size!")), true);
            return false;
        }
        if (sizeItem.getSizeModification().equals((Object)SizeEssenceItem.SizeModification.SET)) {
            SizeItemInteractions.setPokemonSize((class_3222)player, target, sizeItem.getSizeChange());
            player.method_7353((class_2561)class_2561.method_43470((String)(SizeItemInteractions.getPokemonName(target) + " is now size " + String.format("%.2f", Float.valueOf(sizeItem.getSizeChange())))), true);
        } else {
            float currentSize = SizeItemInteractions.getPokemonSize(target);
            float newSize = Math.max(0.1f, Math.min(10.0f, currentSize + sizeItem.getSizeChange()));
            SizeItemInteractions.setPokemonSize((class_3222)player, target, newSize);
            player.method_7353((class_2561)class_2561.method_43470((String)(SizeItemInteractions.getPokemonName(target) + " is now size " + String.format("%.2f", Float.valueOf(newSize)))), true);
        }
        if (!player.method_7337()) {
            stack.method_7934(1);
        }
        class_3414 sound = class_3414.method_47909((class_2960)SIZE_CHANGED_SOUND, (float)64.0f);
        target.method_37908().method_45445((class_1297)target, target.method_24515(), sound, class_3419.field_15254, 2.0f, 1.0f);
        return true;
    }

    private static float getPokemonSize(PokemonEntity pokemon) {
        return pokemon.getPokemon().getScaleModifier();
    }

    private static void setPokemonSize(class_3222 player, PokemonEntity pokemonEntity, float newSize) {
        if (!pokemonEntity.method_37908().field_9236) {
            pokemonEntity.getPokemon().setScaleModifier(newSize);
            CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(Objects.requireNonNull(player), (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> ((PokemonEntity)pokemonEntity).getPokemon()), Double.valueOf(newSize)));
        }
    }

    private static String getPokemonName(PokemonEntity pokemon) {
        return pokemon.getPokemon().getSpecies().getName();
    }
}

