/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation.command;

import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.cudzer.cobblemonsizevariation.CobblemonSizeVariation;
import dev.cudzer.cobblemonsizevariation.command.PartySlot;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.network.SizeChangedPacket;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import kotlin.jvm.functions.Function0;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ChangeSizeCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"pokesizer").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(src -> src.method_9259(ModConfig.getPermission("cobblemonsizevariation.command.pokesizer")))).executes(ChangeSizeCommand::runResizeAll)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"member", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9265(ChangeSizeCommand.getPartyMemberNames((CommandContext<class_2168>)ctx), (SuggestionsBuilder)sb)).executes(ChangeSizeCommand::runRandomResizer)).then(class_2170.method_9244((String)"size", (ArgumentType)DoubleArgumentType.doubleArg((double)CobblemonSizeVariation.SIZER.getMinSizeModifier(), (double)CobblemonSizeVariation.SIZER.getMaxSizeModifier())).executes(ChangeSizeCommand::runResizer))).then(class_2170.method_9247((String)"check").executes(ChangeSizeCommand::checkSize))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"self").requires(src -> src.method_9259(ModConfig.getPermission("cobblemonsizevariation.command.pokesizer.self")))).executes(ChangeSizeCommand::runResizeSelfAll)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"member", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9265(ChangeSizeCommand.getSelfPartyMemberNames((CommandContext<class_2168>)ctx), (SuggestionsBuilder)sb)).executes(ChangeSizeCommand::runRandomSelfResizer)).then(class_2170.method_9244((String)"size", (ArgumentType)DoubleArgumentType.doubleArg((double)CobblemonSizeVariation.SIZER.getMinSizeModifier(), (double)CobblemonSizeVariation.SIZER.getMaxSizeModifier())).executes(ChangeSizeCommand::runSelfResizer))).then(class_2170.method_9247((String)"check").executes(ChangeSizeCommand::checkSizeSelf)))));
    }

    private static int runResizeAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)targetPlayer);
        if (party.size() != 0) {
            for (Pokemon targetPokemon : party.toGappyList()) {
                if (targetPokemon == null) continue;
                float sizeModifier = CobblemonSizeVariation.SIZER.getSize();
                targetPokemon.setScaleModifier(sizeModifier);
                CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(targetPlayer, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> targetPokemon), Double.valueOf(sizeModifier)));
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("The size of %s's team has been randomized", targetPlayer.method_5477().getString())), true);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)String.format("%s doesn't have any Pokemon!", targetPlayer.method_5477().getString())));
        return -1;
    }

    private static int runResizeSelfAll(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 targetPlayer = ((class_2168)context.getSource()).method_44023();
            if (targetPlayer == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You must be a player to run this command"));
                return -1;
            }
            PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)targetPlayer);
            if (party.size() != 0) {
                for (Pokemon targetPokemon : party.toGappyList()) {
                    if (targetPokemon == null) continue;
                    float sizeModifier = CobblemonSizeVariation.SIZER.getSize();
                    targetPokemon.setScaleModifier(sizeModifier);
                    CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(targetPlayer, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> targetPokemon), Double.valueOf(sizeModifier)));
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"The size of your team has been randomized"), true);
                return 0;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have any Pokemon!"));
            return -1;
        }
        return -1;
    }

    private static int runResizer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        double sizeModifier = DoubleArgumentType.getDouble(context, (String)"size");
        return ChangeSizeCommand.resize(context, targetPlayer, partyMember, (float)sizeModifier, false);
    }

    private static int runRandomResizer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        return ChangeSizeCommand.resize(context, targetPlayer, partyMember, CobblemonSizeVariation.SIZER.getSize(), false);
    }

    private static int runRandomSelfResizer(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 targetPlayer = ((class_2168)context.getSource()).method_44023();
            if (targetPlayer == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            return ChangeSizeCommand.resize(context, targetPlayer, partyMember, CobblemonSizeVariation.SIZER.getSize(), true);
        }
        return -1;
    }

    private static int runSelfResizer(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 targetPlayer = ((class_2168)context.getSource()).method_44023();
            if (targetPlayer == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            double sizeModifier = DoubleArgumentType.getDouble(context, (String)"size");
            return ChangeSizeCommand.resize(context, targetPlayer, partyMember, (float)sizeModifier, true);
        }
        return -1;
    }

    private static int checkSize(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        String partyMember = StringArgumentType.getString(context, (String)"member");
        return ChangeSizeCommand.getSize(context, targetPlayer, partyMember, false);
    }

    private static int checkSizeSelf(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_3222 targetPlayer = ((class_2168)context.getSource()).method_44023();
            if (targetPlayer == null) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You must be a player to run this command"));
                return -1;
            }
            String partyMember = StringArgumentType.getString(context, (String)"member");
            return ChangeSizeCommand.getSize(context, targetPlayer, partyMember, true);
        }
        return -1;
    }

    private static int resize(CommandContext<class_2168> context, class_3222 player, String pokemon, float size, boolean isSelf) {
        String failure;
        String success;
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        Pokemon targetPokemon = null;
        if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
            int slot = PartySlot.valueOf(pokemon).getSlot();
            targetPokemon = party.get(slot);
            success = isSelf ? String.format("The size of your pokemon in %s was changed!", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("The size of %s's pokemon in %s was changed!", player.method_5477().getString(), PartySlot.valueOf(pokemon).getDisplayText());
            failure = isSelf ? String.format("You have a have a pokemon in %s", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("%s doesn't have a pokemon in %s", player.method_5477().getString(), PartySlot.valueOf(pokemon).getDisplayText());
        } else {
            for (Pokemon pok : party.toGappyList()) {
                if (pok == null || !pok.getSpecies().getName().equalsIgnoreCase(pokemon)) continue;
                targetPokemon = pok;
            }
            if (targetPokemon != null) {
                success = isSelf ? String.format("The size of your %s was changed!", targetPokemon.getSpecies().getName()) : String.format("The size of %s's %s was changed!", player.method_5477().getString(), targetPokemon.getSpecies().getName());
                failure = "";
            } else {
                success = "";
                String string = failure = isSelf ? String.format("You have a have a %s", pokemon) : String.format("%s doesn't have a %s", player.method_5477().getString(), pokemon);
            }
        }
        if (targetPokemon != null) {
            if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
                targetPokemon.setScaleModifier(size);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)success), true);
                Pokemon finalTargetPokemon = targetPokemon;
                CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(player, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> finalTargetPokemon), Double.valueOf(size)));
                return 0;
            }
            targetPokemon.setScaleModifier(size);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)success), true);
            Pokemon finalTargetPokemon1 = targetPokemon;
            CobblemonSizeVariation.platform.getNetworkManager().sendPacketToPlayer(player, (NetworkPacket)new SizeChangedPacket((Function0<? extends Pokemon>)((Function0)() -> finalTargetPokemon1), Double.valueOf(size)));
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)failure));
        return -1;
    }

    private static int getSize(CommandContext<class_2168> context, class_3222 player, String pokemon, boolean isSelf) {
        String failure;
        String success;
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        Pokemon targetPokemon = null;
        if (ChangeSizeCommand.getPartySlots().contains(pokemon)) {
            int slot = PartySlot.valueOf(pokemon).getSlot();
            targetPokemon = party.get(slot);
            if (targetPokemon != null) {
                float pokemonSize = targetPokemon.getScaleModifier();
                success = isSelf ? String.format("The size of your pokemon in %s is %.2f", PartySlot.valueOf(pokemon).getDisplayText(), Float.valueOf(pokemonSize)) : String.format("The size of %s's pokemon in %s is %.2f!", player.method_5477().getString(), PartySlot.valueOf(pokemon).getDisplayText(), Float.valueOf(pokemonSize));
                failure = isSelf ? String.format("You have a have a pokemon in %s", PartySlot.valueOf(pokemon).getDisplayText()) : String.format("%s doesn't have a pokemon in %s", player.method_5477().getString(), PartySlot.valueOf(pokemon).getDisplayText());
            } else {
                success = "";
                failure = isSelf ? String.format("You have a have a pokemon in %s", pokemon) : String.format("%s doesn't have a pokemon in %s", player.method_5477().getString(), pokemon);
            }
        } else {
            for (Pokemon pok : party.toGappyList()) {
                if (pok == null || !pok.getSpecies().getName().equalsIgnoreCase(pokemon)) continue;
                targetPokemon = pok;
            }
            if (targetPokemon != null) {
                float pokemonSize = targetPokemon.getScaleModifier();
                success = isSelf ? String.format("The size of your %s is %.2f", targetPokemon.getSpecies().getName(), Float.valueOf(pokemonSize)) : String.format("The size of %s's %s is %.2f", player.method_5477().getString(), targetPokemon.getSpecies().getName(), Float.valueOf(pokemonSize));
                failure = "";
            } else {
                success = "";
                String string = failure = isSelf ? String.format("You have a have a %s", pokemon) : String.format("%s doesn't have a %s", player.method_5477().getString(), pokemon);
            }
        }
        if (targetPokemon != null) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)success), true);
            return 0;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)failure));
        return -1;
    }

    private static Set<String> getPartyMemberNames(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 targetPlayer = class_2186.method_9315(context, (String)"player");
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)targetPlayer);
        HashSet<String> partyMembers = new HashSet<String>();
        party.toGappyList().stream().filter(Objects::nonNull).map(p -> p.getSpecies().getName()).forEach(partyMembers::add);
        partyMembers.addAll(ChangeSizeCommand.getPartySlots());
        return partyMembers;
    }

    private static Set<String> getSelfPartyMemberNames(CommandContext<class_2168> context) {
        class_3222 targetPlayer = ((class_2168)context.getSource()).method_44023();
        if (targetPlayer != null) {
            PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)targetPlayer);
            HashSet<String> partyMembers = new HashSet<String>();
            party.toGappyList().stream().filter(Objects::nonNull).map(p -> p.getSpecies().getName()).forEach(partyMembers::add);
            partyMembers.addAll(ChangeSizeCommand.getPartySlots());
            return partyMembers;
        }
        return new HashSet<String>();
    }

    private static Set<String> getPartySlots() {
        HashSet<String> slots = new HashSet<String>();
        for (PartySlot partySlot : PartySlot.values()) {
            slots.add(partySlot.toString());
        }
        return slots;
    }
}

