/*
 * Decompiled with CFR 0.152.
 */
package dev.cudzer.cobblemonsizevariation;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.cudzer.cobblemonsizevariation.ModDependencyChecker;
import dev.cudzer.cobblemonsizevariation.Platform;
import dev.cudzer.cobblemonsizevariation.command.ChangeSizeCommand;
import dev.cudzer.cobblemonsizevariation.config.ModConfig;
import dev.cudzer.cobblemonsizevariation.data.CustomSizeDataManager;
import dev.cudzer.cobblemonsizevariation.event.ModEvents;
import dev.cudzer.cobblemonsizevariation.item.ModCreativeModeTab;
import dev.cudzer.cobblemonsizevariation.item.ModItems;
import dev.cudzer.cobblemonsizevariation.sizing.SizeDataManager;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.BasicSizer;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.GenIXSizer;
import dev.cudzer.cobblemonsizevariation.sizing.algorithms.ISizer;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CobblemonSizeVariation {
    public static final String MOD_ID = "cobblemonsizevariation";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobblemonsizevariation");
    public static SizeDataManager sizeDataManager;
    public static ISizer SIZER;
    public static Platform platform;
    public static ModDependencyChecker dependencyChecker;

    public static class_2960 cobblemonSizeResource(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void init(Platform modPlatform) {
        platform = modPlatform;
        dependencyChecker = new ModDependencyChecker(platform);
        dependencyChecker.checkDependencies();
        ModConfig.init(platform.getConfigDirectory());
        sizeDataManager = new SizeDataManager();
        sizeDataManager.init();
        SIZER = CobblemonSizeVariation.getSizer();
        ModItems.register();
        ModCreativeModeTab.register();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new CustomSizeDataManager(), (class_2960)CobblemonSizeVariation.cobblemonSizeResource("custom_sizes"));
        ModEvents.registerEvents();
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        ChangeSizeCommand.registerCommand(dispatcher);
    }

    private static ISizer getSizer() {
        String sizerName = ModConfig.sizingAlgorithm;
        if (ModConfig.sizingAlgorithm.equals("gen9")) {
            return new GenIXSizer(sizeDataManager.getDefinition(sizerName));
        }
        return new BasicSizer(sizeDataManager.getDefinition(sizerName));
    }
}

