/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners.utils;

import com.cobblespawners.CobbleSpawners;
import com.cobblespawners.utils.SpawnRadius;
import com.cobblespawners.utils.SpawnerData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0014\u0010\nJ7\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010 \u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\r\u00a2\u0006\u0004\b \u0010\u001eR/\u0010%\u001a\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020$0#0!8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020$8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/cobblespawners/utils/ParticleUtils;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "player", "Lcom/cobblespawners/utils/SpawnerData;", "spawnerData", "", "visualizeSpawnerPositions", "(Lnet/minecraft/class_3222;Lcom/cobblespawners/utils/SpawnerData;)V", "Lnet/minecraft/class_2394;", "particleType", "Lnet/minecraft/class_2338;", "centerPos", "", "radiusWidth", "radiusHeight", "renderCubeOutline", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2394;Lnet/minecraft/class_2338;II)V", "toggleVisualization", "x", "y", "z", "sendParticleIfInRange", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_2394;III)V", "Lnet/minecraft/class_3218;", "world", "spawnPos", "spawnMonParticles", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)V", "spawnerPos", "spawnSpawnerParticles", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "", "activeVisualizations", "Ljava/util/Map;", "getActiveVisualizations", "()Ljava/util/Map;", "visualizationInterval", "J", "cobblespawners"})
@SourceDebugExtension(value={"SMAP\nParticleUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleUtils.kt\ncom/cobblespawners/utils/ParticleUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,193:1\n774#2:194\n865#2,2:195\n1863#2,2:197\n*S KotlinDebug\n*F\n+ 1 ParticleUtils.kt\ncom/cobblespawners/utils/ParticleUtils\n*L\n38#1:194\n38#1:195,2\n47#1:197,2\n*E\n"})
public final class ParticleUtils {
    @NotNull
    public static final ParticleUtils INSTANCE = new ParticleUtils();
    @NotNull
    private static final Map<UUID, Pair<class_2338, Long>> activeVisualizations = new LinkedHashMap();
    public static final long visualizationInterval = 10L;

    private ParticleUtils() {
    }

    @NotNull
    public final Map<UUID, Pair<class_2338, Long>> getActiveVisualizations() {
        return activeVisualizations;
    }

    /*
     * WARNING - void declaration
     */
    public final void visualizeSpawnerPositions(@NotNull class_3222 player, @NotNull SpawnerData spawnerData) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)spawnerData, (String)"spawnerData");
        class_1937 class_19372 = player.method_37908();
        class_3218 class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
        if (class_32182 == null) {
            return;
        }
        class_3218 serverWorld = class_32182;
        Map<String, List<class_2338>> map = CobbleSpawners.INSTANCE.getSpawnerValidPositions().get(spawnerData.getSpawnerPos());
        if (map == null) {
            return;
        }
        Map<String, List<class_2338>> categorizedPositions = map;
        class_2400 flameParticle = class_2398.field_11240;
        class_2400 blueFlameParticle = class_2398.field_22246;
        class_2338 centerPos = spawnerData.getSpawnerPos();
        List allValidPositions = CollectionsKt.flatten((Iterable)categorizedPositions.values());
        Iterable $this$filter$iv = allValidPositions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_2338 spawnPos = (class_2338)element$iv$iv;
            boolean bl = false;
            int playerChunkX = player.method_24515().method_10263() >> 4;
            int playerChunkZ = player.method_24515().method_10260() >> 4;
            int spawnChunkX = spawnPos.method_10263() >> 4;
            int spawnChunkZ = spawnPos.method_10260() >> 4;
            if (!(Math.abs(playerChunkX - spawnChunkX) <= 2 && Math.abs(playerChunkZ - spawnChunkZ) <= 2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nearbyPositions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = nearbyPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_2338 spawnPos = (class_2338)element$iv;
            boolean bl = false;
            player.field_13987.method_14364((class_2596)new class_2675((class_2394)flameParticle, true, (double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264() + 1.0, (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f, 0.0f, 0.01f, 1));
        }
        Intrinsics.checkNotNull((Object)blueFlameParticle);
        SpawnRadius spawnRadius = spawnerData.getSpawnRadius();
        SpawnRadius spawnRadius2 = spawnerData.getSpawnRadius();
        this.renderCubeOutline(player, (class_2394)blueFlameParticle, centerPos, spawnRadius != null ? spawnRadius.getWidth() : 4, spawnRadius2 != null ? spawnRadius2.getHeight() : 4);
    }

    private final void renderCubeOutline(class_3222 player, class_2394 particleType, class_2338 centerPos, int radiusWidth, int radiusHeight) {
        Iterator iterator;
        Object[] objectArray = new Integer[]{-radiusWidth, radiusWidth};
        Iterator iterator2 = CollectionsKt.listOf((Object[])objectArray).iterator();
        while (iterator2.hasNext()) {
            int x = ((Number)iterator2.next()).intValue();
            Object[] objectArray2 = new Integer[]{-radiusHeight, radiusHeight};
            iterator = CollectionsKt.listOf((Object[])objectArray2).iterator();
            block1: while (iterator.hasNext()) {
                int y2 = ((Number)iterator.next()).intValue();
                int z = -radiusWidth;
                if (z > radiusWidth) continue;
                while (true) {
                    this.sendParticleIfInRange(player, particleType, centerPos.method_10263() + x, centerPos.method_10264() + y2, centerPos.method_10260() + z);
                    if (z == radiusWidth) continue block1;
                    ++z;
                }
            }
        }
        Object[] x = new Integer[]{-radiusHeight, radiusHeight};
        iterator2 = CollectionsKt.listOf((Object[])x).iterator();
        while (iterator2.hasNext()) {
            int y = ((Number)iterator2.next()).intValue();
            Object[] y2 = new Integer[]{-radiusWidth, radiusWidth};
            iterator = CollectionsKt.listOf((Object[])y2).iterator();
            block4: while (iterator.hasNext()) {
                int z = ((Number)iterator.next()).intValue();
                int x2 = -radiusWidth;
                if (x2 > radiusWidth) continue;
                while (true) {
                    this.sendParticleIfInRange(player, particleType, centerPos.method_10263() + x2, centerPos.method_10264() + y, centerPos.method_10260() + z);
                    if (x2 == radiusWidth) continue block4;
                    ++x2;
                }
            }
        }
        Object[] y = new Integer[]{-radiusWidth, radiusWidth};
        iterator2 = CollectionsKt.listOf((Object[])y).iterator();
        while (iterator2.hasNext()) {
            int x3 = ((Number)iterator2.next()).intValue();
            Object[] z = new Integer[]{-radiusWidth, radiusWidth};
            iterator = CollectionsKt.listOf((Object[])z).iterator();
            block7: while (iterator.hasNext()) {
                int z2 = ((Number)iterator.next()).intValue();
                int y3 = -radiusHeight;
                if (y3 > radiusHeight) continue;
                while (true) {
                    this.sendParticleIfInRange(player, particleType, centerPos.method_10263() + x3, centerPos.method_10264() + y3, centerPos.method_10260() + z2);
                    if (y3 == radiusHeight) continue block7;
                    ++y3;
                }
            }
        }
    }

    public final void toggleVisualization(@NotNull class_3222 player, @NotNull SpawnerData spawnerData) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)spawnerData, (String)"spawnerData");
        class_2338 spawnerPos = spawnerData.getSpawnerPos();
        UUID playerUUID = player.method_5667();
        Pair<class_2338, Long> pair = activeVisualizations.get(playerUUID);
        if (Intrinsics.areEqual((Object)(pair != null ? (class_2338)pair.getFirst() : null), (Object)spawnerPos)) {
            activeVisualizations.remove(playerUUID);
            player.method_7353((class_2561)class_2561.method_43470((String)("Stopped visualizing spawn points for spawner '" + spawnerData.getSpawnerName() + "'")), false);
            return;
        }
        Map<String, List<class_2338>> map = CobbleSpawners.INSTANCE.getSpawnerValidPositions().get(spawnerPos);
        if (map == null || map.isEmpty()) {
            class_3218 serverWorld;
            class_1937 class_19372 = player.method_37908();
            class_3218 class_32182 = serverWorld = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
            if (serverWorld != null) {
                Map<String, List<class_2338>> computedPositions = CobbleSpawners.INSTANCE.computeValidSpawnPositions(serverWorld, spawnerData);
                if (!computedPositions.isEmpty()) {
                    ((Map)CobbleSpawners.INSTANCE.getSpawnerValidPositions()).put(spawnerPos, computedPositions);
                }
                if (computedPositions.isEmpty()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("No valid spawn positions found for spawner '" + spawnerData.getSpawnerName() + "'")), false);
                    return;
                }
            }
        }
        activeVisualizations.put(playerUUID, (Pair<class_2338, Long>)TuplesKt.to((Object)spawnerPos, (Object)player.method_37908().method_8510()));
        player.method_7353((class_2561)class_2561.method_43470((String)("Started visualizing spawn points and cube outline for spawner '" + spawnerData.getSpawnerName() + "'")), false);
    }

    private final void sendParticleIfInRange(class_3222 player, class_2394 particleType, int x, int y, int z) {
        int playerChunkX = player.method_24515().method_10263() >> 4;
        int playerChunkZ = player.method_24515().method_10260() >> 4;
        int particleChunkX = x >> 4;
        int particleChunkZ = z >> 4;
        if (Math.abs(playerChunkX - particleChunkX) <= 2 && Math.abs(playerChunkZ - particleChunkZ) <= 2) {
            player.field_13987.method_14364((class_2596)new class_2675(particleType, true, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, 0.0f, 0.0f, 0.0f, 0.01f, 1));
        }
    }

    public final void spawnMonParticles(@NotNull class_3218 world, @NotNull class_2338 spawnPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)spawnPos, (String)"spawnPos");
        int particleCount = 10;
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double yOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double zOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double velocityX = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 - 0.01;
            double velocityY = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 + 0.02;
            double velocityZ = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 - 0.01;
            world.method_14199((class_2394)class_2398.field_11204, (double)spawnPos.method_10263() + 0.5 + xOffset, (double)spawnPos.method_10264() + 1.0 + yOffset, (double)spawnPos.method_10260() + 0.5 + zOffset, 1, velocityX, velocityY, velocityZ, 0.01);
        }
    }

    public final void spawnSpawnerParticles(@NotNull class_3218 world, @NotNull class_2338 spawnerPos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)spawnerPos, (String)"spawnerPos");
        int particleCount = 20;
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double yOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double zOffset = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.6 - 0.3;
            double velocityX = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 - 0.01;
            double velocityY = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 + 0.02;
            double velocityZ = CobbleSpawners.INSTANCE.getRandom().method_43058() * 0.02 - 0.01;
            world.method_14199((class_2394)class_2398.field_11251, (double)spawnerPos.method_10263() + 0.5 + xOffset, (double)spawnerPos.method_10264() + 1.0 + yOffset, (double)spawnerPos.method_10260() + 0.5 + zOffset, 1, velocityX, velocityY, velocityZ, 0.01);
        }
    }

    private static final void _init_$lambda$0(class_3244 handler, MinecraftServer minecraftServer) {
        activeVisualizations.remove(handler.field_14140.method_5667());
    }

    static {
        ServerPlayConnectionEvents.DISCONNECT.register(ParticleUtils::_init_$lambda$0);
    }
}

