/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners.utils;

import com.cobblespawners.CobbleSpawners;
import com.cobblespawners.utils.CobbleSpawnersConfig;
import com.cobblespawners.utils.SpawnerData;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/cobblespawners/utils/CommandRegistrarUtil;", "", "<init>", "()V", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_2338;", "spawnerPos", "", "toggleSpawnerVisibility", "(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2338;)Z", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "cobblespawners"})
public final class CommandRegistrarUtil {
    @NotNull
    public static final CommandRegistrarUtil INSTANCE = new CommandRegistrarUtil();
    private static final Logger logger = LoggerFactory.getLogger((String)"CobbleSpawners-CmdUtil");

    private CommandRegistrarUtil() {
    }

    public final boolean toggleSpawnerVisibility(@NotNull MinecraftServer server, @NotNull class_2338 spawnerPos) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)spawnerPos, (String)"spawnerPos");
        SpawnerData updated = CobbleSpawnersConfig.INSTANCE.updateSpawner(spawnerPos, (Function1<? super SpawnerData, Unit>)((Function1)CommandRegistrarUtil::toggleSpawnerVisibility$lambda$0));
        if (updated == null) {
            logger.error("No spawner found at " + spawnerPos + ".");
            return false;
        }
        class_5321<class_1937> dimensionKey = CobbleSpawners.INSTANCE.parseDimension(updated.getDimension());
        class_3218 class_32182 = server.method_3847(dimensionKey);
        if (class_32182 == null) {
            return false;
        }
        class_3218 world = class_32182;
        try {
            boolean bl2 = updated.getVisible() ? world.method_8501(spawnerPos, class_2246.field_10260.method_9564()) : world.method_8501(spawnerPos, class_2246.field_10124.method_9564());
            bl = true;
        }
        catch (Exception e) {
            logger.error("Error toggling spawner at " + spawnerPos + ": " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private static final Unit toggleSpawnerVisibility$lambda$0(SpawnerData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.setVisible(!data.getVisible());
        return Unit.INSTANCE;
    }
}

