/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners.utils;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentEvent;
import com.cobblemon.mod.common.api.pokemon.stats.EvSource;
import com.cobblemon.mod.common.api.pokemon.stats.SidemodEvSource;
import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.actor.PokemonBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblespawners.api.SpawnerNBTManager;
import com.cobblespawners.utils.CobbleSpawnersConfig;
import com.cobblespawners.utils.PokemonSpawnEntry;
import com.everlastingutils.scheduling.SchedulerManager;
import com.everlastingutils.utils.LogDebugKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002IJB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u0017\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001a\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u000eJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u000eJ\u0017\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u0017\u0010 \u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\"\u0010\u000eJ\u001f\u0010#\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b#\u0010\u0019J\u001f\u0010$\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b$\u0010\u0019J)\u0010)\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u00142\b\u0010(\u001a\u0004\u0018\u00010'H\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010+\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b+\u0010\u000eJ\u0019\u0010,\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0019\u0010.\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u0002002\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b1\u00102J%\u00105\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020\u0010\u0018\u0001032\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b5\u00106J/\u0010:\u001a\u001a\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u000208\u0012\n\u0012\b\u0012\u0004\u0012\u00020809072\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b:\u0010;R\u001c\u0010>\u001a\n =*\u0004\u0018\u00010<0<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R#\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020A0@8\u0006\u00a2\u0006\f\n\u0004\bB\u0010C\u001a\u0004\bD\u0010ER\u0014\u0010G\u001a\u00020F8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010H\u00a8\u0006K"}, d2={"Lcom/cobblespawners/utils/BattleTracker;", "", "<init>", "()V", "", "registerEvents", "Lnet/minecraft/server/MinecraftServer;", "server", "startCleanupScheduler", "(Lnet/minecraft/server/MinecraftServer;)V", "cleanupBattles", "Ljava/util/UUID;", "battleId", "handleBattleStartPre", "(Ljava/util/UUID;)V", "", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actors", "handleBattleStartPost", "(Ljava/util/UUID;Ljava/util/List;)V", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "handlePokemonSent", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "handlePlayerActivePokemon", "(Ljava/util/UUID;Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "handleOpponentActivePokemon", "handleBattleVictory", "handleBattleFlee", "handlePokemonCaptured", "Lnet/minecraft/class_3222;", "player", "handlePlayerLogout", "(Lnet/minecraft/class_3222;)V", "applyValuesAfterBattle", "saveOriginalEVs", "revertEVsAfterChange", "playerPokemon", "opponentPokemon", "Lnet/minecraft/class_2338;", "spawnerPos", "applyCustomEVs", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblemon/mod/common/pokemon/Pokemon;Lnet/minecraft/class_2338;)V", "cleanupBattle", "findBattleIdByPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Ljava/util/UUID;", "findBattleIdByPlayer", "(Lnet/minecraft/class_3222;)Ljava/util/UUID;", "", "playerIsNotInBattle", "(Lnet/minecraft/class_3222;)Z", "Lkotlin/Pair;", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "getActiveBattleAndActor", "(Lnet/minecraft/class_3222;)Lkotlin/Pair;", "Lkotlin/Triple;", "", "", "getPokemonVariantDetails", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)Lkotlin/Triple;", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/cobblespawners/utils/BattleTracker$BattleInfo;", "ongoingBattles", "Ljava/util/concurrent/ConcurrentHashMap;", "getOngoingBattles", "()Ljava/util/concurrent/ConcurrentHashMap;", "", "MAX_BATTLE_DURATION", "I", "BattleEndCause", "BattleInfo", "cobblespawners"})
@SourceDebugExtension(value={"SMAP\nBattleTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BattleTracker.kt\ncom/cobblespawners/utils/BattleTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,394:1\n216#2:395\n217#2:403\n216#2,2:422\n216#2,2:428\n1755#3,2:396\n1755#3,2:398\n1757#3:401\n1757#3:402\n1863#3,2:404\n1557#3:406\n1628#3,3:407\n1863#3,2:410\n1557#3:412\n1628#3,3:413\n1279#3,2:416\n1293#3,4:418\n1557#3:424\n1628#3,3:425\n1755#3,2:430\n1755#3,3:432\n1757#3:435\n1755#3,3:436\n774#3:439\n865#3,2:440\n1#4:400\n*S KotlinDebug\n*F\n+ 1 BattleTracker.kt\ncom/cobblespawners/utils/BattleTracker\n*L\n98#1:395\n98#1:403\n307#1:422,2\n340#1:428,2\n99#1:396,2\n101#1:398,2\n101#1:401\n99#1:402\n118#1:404,2\n130#1:406\n130#1:407,3\n134#1:410,2\n193#1:412\n193#1:413,3\n300#1:416,2\n300#1:418,4\n324#1:424\n324#1:425,3\n358#1:430,2\n359#1:432,3\n358#1:435\n366#1:436,3\n390#1:439\n390#1:440,2\n*E\n"})
public final class BattleTracker {
    private final Logger logger = LoggerFactory.getLogger((String)"cobblespawners");
    @NotNull
    private final ConcurrentHashMap<UUID, BattleInfo> ongoingBattles = new ConcurrentHashMap();
    private final int MAX_BATTLE_DURATION;

    public BattleTracker() {
        this.MAX_BATTLE_DURATION = 600000;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, BattleInfo> getOngoingBattles() {
        return this.ongoingBattles;
    }

    public final void registerEvents() {
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_STARTED_PRE), null, arg_0 -> BattleTracker.registerEvents$lambda$0(this, arg_0), (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_STARTED_POST), null, arg_0 -> BattleTracker.registerEvents$lambda$1(this, arg_0), (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.POKEMON_SENT_POST), null, arg_0 -> BattleTracker.registerEvents$lambda$2(this, arg_0), (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_VICTORY), null, arg_0 -> BattleTracker.registerEvents$lambda$3(this, arg_0), (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.BATTLE_FLED), null, arg_0 -> BattleTracker.registerEvents$lambda$4(this, arg_0), (int)1, null);
        Observable.subscribe$default((Observable)((Observable)CobblemonEvents.POKEMON_CAPTURED), null, arg_0 -> BattleTracker.registerEvents$lambda$5(this, arg_0), (int)1, null);
        ServerPlayConnectionEvents.DISCONNECT.register((arg_0, arg_1) -> BattleTracker.registerEvents$lambda$6(this, arg_0, arg_1));
    }

    public final void startCleanupScheduler(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String schedulerId = "cobblespawners-battle-cleanup";
        SchedulerManager.scheduleAtFixedRate((String)schedulerId, (MinecraftServer)server, (long)0L, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS, () -> BattleTracker.startCleanupScheduler$lambda$7(this, server));
        LogDebugKt.logDebug((String)("Started battle cleanup scheduler with ID: " + schedulerId), (String)"cobblespawners");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void cleanupBattles(MinecraftServer server) {
        Map.Entry element$iv;
        long currentTime = System.currentTimeMillis();
        List battlesToCleanup = new ArrayList();
        Object $this$forEach$iv = this.ongoingBattles;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean battleEnded;
            BattleInfo battleInfo;
            UUID battleId;
            block16: {
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                battleId = (UUID)entry.getKey();
                battleInfo = (BattleInfo)entry.getValue();
                Iterable $this$any$iv = battleInfo.getActors();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        boolean bl2;
                        block15: {
                            BattleActor actor = (BattleActor)element$iv2;
                            boolean bl3 = false;
                            if (actor instanceof PlayerBattleActor) {
                                Iterable $this$any$iv2 = ((PlayerBattleActor)actor).getPlayerUUIDs();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv3 : $this$any$iv2) {
                                        boolean bl4;
                                        UUID uuid = (UUID)element$iv3;
                                        boolean bl5 = false;
                                        if (server.method_3760().method_14602(uuid) != null) {
                                            class_3222 player;
                                            boolean bl6 = false;
                                            bl4 = this.playerIsNotInBattle(player);
                                        } else {
                                            bl4 = true;
                                        }
                                        if (!bl4) continue;
                                        bl2 = true;
                                        break block15;
                                    }
                                    bl2 = false;
                                }
                            } else {
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        v0 = true;
                        break block16;
                    }
                    v0 = battleEnded = false;
                }
            }
            if (!battleEnded && currentTime - battleInfo.getStartTime() <= (long)this.MAX_BATTLE_DURATION) continue;
            BattleInfo battleInfo2 = battleInfo;
            synchronized (battleInfo2) {
                boolean bl = false;
                battleInfo.setEndCause(BattleEndCause.UNKNOWN);
                Unit unit = Unit.INSTANCE;
            }
            LogDebugKt.logDebug((String)("Battle " + battleId + " exceeded maximum duration or ended. Preparing for cleanup."), (String)"cobblespawners");
            this.applyValuesAfterBattle(battleId);
            battlesToCleanup.add(battleId);
        }
        $this$forEach$iv = battlesToCleanup;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            UUID it = (UUID)((Object)element$iv);
            boolean bl = false;
            this.cleanupBattle(it);
        }
    }

    private final void handleBattleStartPre(UUID battleId) {
        LogDebugKt.logDebug((String)("Battle pre-start for Battle ID: " + battleId), (String)"cobblespawners");
        ((Map)this.ongoingBattles).put(battleId, new BattleInfo(battleId, CollectionsKt.emptyList(), null, null, false, null, null, false, null, null, 0L, 2044, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void handleBattleStartPost(UUID battleId, List<? extends BattleActor> actors) {
        BattleActor battleActor;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = actors;
        UUID uUID = battleId;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            battleActor = (BattleActor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getClass().getSimpleName());
        }
        LogDebugKt.logDebug((String)("Battle fully started for Battle ID: " + uUID + " with actors: " + (List)destination$iv$iv), (String)"cobblespawners");
        BattleInfo battleInfo = this.ongoingBattles.get(battleId);
        if (battleInfo == null) {
            return;
        }
        BattleInfo battleInfo2 = battleInfo;
        battleInfo2.setActors(actors);
        Iterable $this$forEach$iv = actors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BattleActor actor = (BattleActor)element$iv;
            boolean bl = false;
            battleActor = actor;
            if (battleActor instanceof PlayerBattleActor) {
                BattlePokemon battlePokemon = (BattlePokemon)CollectionsKt.firstOrNull((List)actor.getPokemonList());
                this.handlePlayerActivePokemon(battleId, (Pokemon)(battlePokemon != null ? battlePokemon.getEffectedPokemon() : null));
                continue;
            }
            if (!(battleActor instanceof PokemonBattleActor)) continue;
            BattlePokemon battlePokemon = (BattlePokemon)CollectionsKt.firstOrNull((List)actor.getPokemonList());
            this.handleOpponentActivePokemon(battleId, (Pokemon)(battlePokemon != null ? battlePokemon.getEffectedPokemon() : null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePokemonSent(Pokemon pokemon) {
        UUID battleId = this.findBattleIdByPokemon(pokemon);
        if (battleId != null) {
            PokemonEntity pokemonEntity = pokemon.getEntity();
            if ((pokemonEntity != null ? pokemonEntity.method_35057() : null) instanceof class_3222) {
                BattleInfo battleInfo;
                LogDebugKt.logDebug((String)("Player swapped in Pok\u00e9mon: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
                BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
                if (battleInfo2 == null) {
                    return;
                }
                BattleInfo battleInfo3 = battleInfo = battleInfo2;
                synchronized (battleInfo3) {
                    Unit unit;
                    boolean bl = false;
                    Pokemon pokemon2 = battleInfo.getCurrentActivePlayerPokemon();
                    if (pokemon2 != null) {
                        Pokemon oldPokemon = pokemon2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)oldPokemon.getUuid(), (Object)pokemon.getUuid())) {
                            LogDebugKt.logDebug((String)("Detected swap: Old Pok\u00e9mon " + oldPokemon.getSpecies().getName() + " (UUID: " + oldPokemon.getUuid() + ") is being swapped out for " + pokemon.getSpecies().getName() + " (UUID: " + pokemon.getUuid() + ")"), (String)"cobblespawners");
                            this.saveOriginalEVs(battleId, oldPokemon);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                this.handlePlayerActivePokemon(battleId, pokemon);
            } else {
                LogDebugKt.logDebug((String)("Opponent swapped in Pok\u00e9mon: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
                this.handleOpponentActivePokemon(battleId, pokemon);
            }
        } else {
            LogDebugKt.logDebug((String)("Pok\u00e9mon sent out outside of tracked battle: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePlayerActivePokemon(UUID battleId, Pokemon pokemon) {
        BattleInfo battleInfo;
        if (pokemon == null) {
            LogDebugKt.logDebug((String)"Player active Pok\u00e9mon is null, skipping EV save.", (String)"cobblespawners");
            return;
        }
        BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
        if (battleInfo2 == null) {
            return;
        }
        BattleInfo battleInfo3 = battleInfo = battleInfo2;
        synchronized (battleInfo3) {
            boolean bl = false;
            battleInfo.setCurrentActivePlayerPokemon(pokemon);
            ((Map)battleInfo.getParticipatingPlayerMons()).put(pokemon.getUuid(), pokemon);
            this.saveOriginalEVs(battleId, pokemon);
            LogDebugKt.logDebug((String)("Tracking Player's Pok\u00e9mon: " + pokemon.getSpecies().getName() + ", UUID: " + pokemon.getUuid()), (String)"cobblespawners");
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void handleOpponentActivePokemon(UUID battleId, Pokemon pokemon) {
        if (pokemon == null) {
            LogDebugKt.logDebug((String)"Opponent active Pok\u00e9mon is null, skipping battle logic.", (String)"cobblespawners");
            return;
        }
        v0 = this.ongoingBattles.get(battleId);
        if (v0 == null) {
            return;
        }
        var4_4 = battleInfo = v0;
        synchronized (var4_4) {
            block18: {
                block19: {
                    block22: {
                        block20: {
                            block21: {
                                block17: {
                                    $i$a$-synchronized-BattleTracker$handleOpponentActivePokemon$1 = false;
                                    if (battleInfo.isOpponentFromSpawner()) break block18;
                                    var6_7 = pokemon.getEntity();
                                    if (var6_7 == null) break block19;
                                    entity = var6_7;
                                    $i$a$-let-BattleTracker$handleOpponentActivePokemon$1$1 = false;
                                    v1 = SpawnerNBTManager.getPokemonInfo(entity);
                                    if (v1 == null) break block20;
                                    spawnerInfo = v1;
                                    $i$a$-let-BattleTracker$handleOpponentActivePokemon$1$1$1 = false;
                                    var11_13 = this.getPokemonVariantDetails(pokemon);
                                    speciesName = (String)var11_13.component1();
                                    formName = (String)var11_13.component2();
                                    aspectsWithoutGender = (Set)var11_13.component3();
                                    spawnerData = CobbleSpawnersConfig.INSTANCE.getSpawners().get(spawnerInfo.getSpawnerPos());
                                    if (spawnerData == null) break block21;
                                    var16_18 = spawnerData.getSelectedPokemon();
                                    for (T var18_20 : var16_18) {
                                        it = (PokemonSpawnEntry)var18_20;
                                        $i$a$-find-BattleTracker$handleOpponentActivePokemon$1$1$1$matchingEntry$1 = false;
                                        if (!StringsKt.equals((String)it.getPokemonName(), (String)speciesName, (boolean)true)) ** GOTO lbl-1000
                                        v2 = it.getFormName();
                                        if (!(v2 != null ? StringsKt.equals((String)v2, (String)formName, (boolean)true) : Intrinsics.areEqual((Object)formName, (Object)"Normal"))) ** GOTO lbl-1000
                                        $this$map$iv = it.getAspects();
                                        $i$f$map = false;
                                        var23_26 = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            var28_31 = (String)item$iv$iv;
                                            var29_32 = destination$iv$iv;
                                            $i$a$-map-BattleTracker$handleOpponentActivePokemon$1$1$1$matchingEntry$1$1 = false;
                                            v3 = a.toLowerCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                                            var29_32.add(v3);
                                        }
                                        $this$map$iv = aspectsWithoutGender;
                                        var29_32 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                                        $i$f$map = false;
                                        $this$mapTo$iv$iv = $this$map$iv;
                                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            a = (String)item$iv$iv;
                                            var31_34 = destination$iv$iv;
                                            $i$a$-map-BattleTracker$handleOpponentActivePokemon$1$1$1$matchingEntry$1$2 = false;
                                            v4 = a.toLowerCase(Locale.ROOT);
                                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toLowerCase(...)");
                                            var31_34.add(v4);
                                        }
                                        if (Intrinsics.areEqual((Object)var29_32, (Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)))) {
                                            v5 = true;
                                        } else lbl-1000:
                                        // 3 sources

                                        {
                                            v5 = false;
                                        }
                                        if (!v5) continue;
                                        v6 = var18_20;
                                        break block17;
                                    }
                                    v6 = null;
                                }
                                matchingEntry = v6;
                                if (matchingEntry != null && matchingEntry.getEvSettings().getAllowCustomEvsOnDefeat()) {
                                    LogDebugKt.logDebug((String)("Found matching Pok\u00e9monSpawnEntry for " + pokemon.getSpecies().getName() + " with custom EVs enabled"), (String)"cobblespawners");
                                    ((Map)battleInfo.getLastActiveOpponentMon()).put(pokemon.getUuid(), pokemon);
                                    battleInfo.setOpponentFromSpawner(true);
                                    battleInfo.setSpawnerPos(spawnerInfo.getSpawnerPos());
                                    v7 = battleInfo.getCurrentActivePlayerPokemon();
                                    if (v7 != null) {
                                        playerPokemon = v7;
                                        $i$a$-let-BattleTracker$handleOpponentActivePokemon$1$1$1$1 = false;
                                        LogDebugKt.logDebug((String)("Saving baseline EVs for current active player's Pok\u00e9mon before opponent swap: " + playerPokemon.getSpecies().getName()), (String)"cobblespawners");
                                        this.saveOriginalEVs(battleId, playerPokemon);
                                        v8 = Unit.INSTANCE;
                                    } else {
                                        v8 = null;
                                    }
                                } else {
                                    LogDebugKt.logDebug((String)("No matching Pok\u00e9monSpawnEntry with custom EVs for " + pokemon.getSpecies().getName() + " (form: " + formName + ", aspects: " + aspectsWithoutGender + ")"), (String)"cobblespawners");
                                    v8 = Unit.INSTANCE;
                                }
                                break block22;
                            }
                            LogDebugKt.logDebug((String)("Spawner data not found for position " + spawnerInfo.getSpawnerPos()), (String)"cobblespawners");
                            v8 = Unit.INSTANCE;
                            break block22;
                        }
                        v8 = null;
                    }
                    if (v8 != null) break block18;
                }
                LogDebugKt.logDebug((String)"Opponent's Pok\u00e9mon is not from a spawner. Skipping EV tracking.", (String)"cobblespawners");
            }
            var5_6 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleBattleVictory(UUID battleId) {
        BattleInfo battleInfo;
        if (!this.ongoingBattles.containsKey(battleId)) {
            return;
        }
        LogDebugKt.logDebug((String)("Battle victory for Battle ID: " + battleId), (String)"cobblespawners");
        BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
        if (battleInfo2 == null) {
            return;
        }
        BattleInfo battleInfo3 = battleInfo = battleInfo2;
        synchronized (battleInfo3) {
            boolean bl = false;
            battleInfo.setEndCause(BattleEndCause.NORMAL_VICTORY);
            Unit unit = Unit.INSTANCE;
        }
        this.applyValuesAfterBattle(battleId);
        this.cleanupBattle(battleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleBattleFlee(UUID battleId) {
        BattleInfo battleInfo;
        if (!this.ongoingBattles.containsKey(battleId)) {
            return;
        }
        LogDebugKt.logDebug((String)("Battle fled for Battle ID: " + battleId), (String)"cobblespawners");
        BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
        if (battleInfo2 == null) {
            return;
        }
        BattleInfo battleInfo3 = battleInfo = battleInfo2;
        synchronized (battleInfo3) {
            boolean bl = false;
            battleInfo.setEndCause(BattleEndCause.FLED);
            Unit unit = Unit.INSTANCE;
        }
        this.cleanupBattle(battleId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePokemonCaptured(Pokemon pokemon) {
        UUID battleId = this.findBattleIdByPokemon(pokemon);
        if (battleId != null) {
            BattleInfo battleInfo;
            LogDebugKt.logDebug((String)("Pok\u00e9mon captured during battle: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
            BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
            if (battleInfo2 == null) {
                return;
            }
            BattleInfo battleInfo3 = battleInfo = battleInfo2;
            synchronized (battleInfo3) {
                boolean bl = false;
                battleInfo.setEndCause(BattleEndCause.CAPTURED);
                Unit unit = Unit.INSTANCE;
            }
            this.applyValuesAfterBattle(battleId);
            this.cleanupBattle(battleId);
        } else {
            LogDebugKt.logDebug((String)("Pok\u00e9mon captured outside of battle: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handlePlayerLogout(class_3222 player) {
        UUID battleId = this.findBattleIdByPlayer(player);
        if (battleId != null) {
            BattleInfo battleInfo;
            LogDebugKt.logDebug((String)("Player " + player.method_5477().getString() + " logged out during battle " + battleId + "."), (String)"cobblespawners");
            BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
            if (battleInfo2 == null) {
                return;
            }
            BattleInfo battleInfo3 = battleInfo = battleInfo2;
            synchronized (battleInfo3) {
                boolean bl = false;
                battleInfo.setEndCause(BattleEndCause.UNKNOWN);
                Unit unit = Unit.INSTANCE;
            }
            this.cleanupBattle(battleId);
        } else {
            LogDebugKt.logDebug((String)("Player " + player.method_5477().getString() + " logged out but was not in a tracked battle."), (String)"cobblespawners");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void applyValuesAfterBattle(UUID battleId) {
        BattleInfo battleInfo;
        BattleInfo battleInfo2 = this.ongoingBattles.get(battleId);
        if (battleInfo2 == null) {
            return;
        }
        BattleInfo battleInfo3 = battleInfo = battleInfo2;
        synchronized (battleInfo3) {
            boolean bl = false;
            if (!battleInfo.isOpponentFromSpawner()) {
                LogDebugKt.logDebug((String)("Battle ID: " + battleId + " did not involve spawner Pok\u00e9mon. Skipping EV modifications."), (String)"cobblespawners");
                return;
            }
            if (battleInfo.getValuesApplied()) {
                LogDebugKt.logDebug((String)("Values already applied for Battle ID: " + battleId), (String)"cobblespawners");
                return;
            }
            if (battleInfo.getEndCause() != BattleEndCause.NORMAL_VICTORY) {
                LogDebugKt.logDebug((String)("Battle ended with cause " + battleInfo.getEndCause() + ". Skipping EV application for Battle ID: " + battleId), (String)"cobblespawners");
                return;
            }
            Collection<Pokemon> collection = battleInfo.getLastActiveOpponentMon().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Pokemon pokemon = (Pokemon)CollectionsKt.firstOrNull((Iterable)collection);
            if (pokemon == null) {
                return;
            }
            Pokemon opponentPokemon = pokemon;
            Pokemon pokemon2 = battleInfo.getCurrentActivePlayerPokemon();
            if (pokemon2 != null) {
                Pokemon playerPokemon = pokemon2;
                boolean bl2 = false;
                LogDebugKt.logDebug((String)("Reverting and applying EVs for active player's Pok\u00e9mon: " + playerPokemon.getSpecies().getName()), (String)"cobblespawners");
                this.revertEVsAfterChange(battleId, playerPokemon);
                this.applyCustomEVs(playerPokemon, opponentPokemon, battleInfo.getSpawnerPos());
            }
            battleInfo.setValuesApplied(true);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void saveOriginalEVs(UUID battleId, Pokemon pokemon) {
        BattleInfo battleInfo = this.ongoingBattles.get(battleId);
        if (battleInfo == null) {
            return;
        }
        BattleInfo battleInfo2 = battleInfo;
        if (!battleInfo2.isOpponentFromSpawner()) {
            LogDebugKt.logDebug((String)("Skipping EV save for non-spawner battle Pok\u00e9mon: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
            return;
        }
        Iterable $this$associateWith$iv = Stats.Companion.getPERMANENT();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Stat stat = (Stat)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = pokemon.getEvs().get((Stat)it);
            Integer n2 = n != null ? n : 0;
            map.put(t, n2);
        }
        Map currentEVs = result$iv;
        ((Map)battleInfo2.getOriginalEVMap()).put(pokemon.getUuid(), currentEVs);
        LogDebugKt.logDebug((String)("Saved EVs for " + pokemon.getSpecies().getName() + ": " + CollectionsKt.joinToString$default((Iterable)currentEVs.entrySet(), null, null, null, (int)0, null, BattleTracker::saveOriginalEVs$lambda$33, (int)31, null)), (String)"cobblespawners");
    }

    private final void revertEVsAfterChange(UUID battleId, Pokemon pokemon) {
        block1: {
            LogDebugKt.logDebug((String)("Reverting EVs for Pok\u00e9mon: " + pokemon.getSpecies().getName()), (String)"cobblespawners");
            Object object = this.ongoingBattles.get(battleId);
            if (object == null || (object = ((BattleInfo)object).getOriginalEVMap()) == null || (object = (Map)((ConcurrentHashMap)object).get(pokemon.getUuid())) == null) break block1;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Stat stat = (Stat)entry.getKey();
                int ev = ((Number)entry.getValue()).intValue();
                pokemon.getEvs().set(stat, ev);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final void applyCustomEVs(Pokemon playerPokemon, Pokemon opponentPokemon, class_2338 spawnerPos) {
        block10: {
            if (spawnerPos == null) {
                LogDebugKt.logDebug((String)"No spawner position available for EV application", (String)"cobblespawners");
                return;
            }
            v0 = CobbleSpawnersConfig.INSTANCE.getSpawners().get(spawnerPos);
            if (v0 == null) {
                return;
            }
            spawnerData = v0;
            var5_5 = this.getPokemonVariantDetails(opponentPokemon);
            speciesName = (String)var5_5.component1();
            formName = (String)var5_5.component2();
            aspectsWithoutGender = (Set)var5_5.component3();
            LogDebugKt.logDebug((String)("Applying custom EVs for defeating " + opponentPokemon.getSpecies().getName() + " (form: " + formName + ", aspects: " + aspectsWithoutGender + ")"), (String)"cobblespawners");
            var11_9 = (Pair[])spawnerData.getSelectedPokemon();
            for (T var13_11 : var11_9) {
                it = (PokemonSpawnEntry)var13_11;
                $i$a$-find-BattleTracker$applyCustomEVs$matchingEntry$1 = false;
                if (!StringsKt.equals((String)it.getPokemonName(), (String)speciesName, (boolean)true)) ** GOTO lbl-1000
                v1 = it.getFormName();
                if (!(v1 != null ? StringsKt.equals((String)v1, (String)formName, (boolean)true) : Intrinsics.areEqual((Object)formName, (Object)"Normal"))) ** GOTO lbl-1000
                $this$map$iv = it.getAspects();
                $i$f$map = false;
                var18_18 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var23_25 = (String)item$iv$iv;
                    var24_26 = destination$iv$iv;
                    $i$a$-map-BattleTracker$applyCustomEVs$matchingEntry$1$1 = false;
                    v2 = a.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toLowerCase(...)");
                    var24_26.add(v2);
                }
                $this$map$iv = aspectsWithoutGender;
                var24_26 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    a = (String)item$iv$iv;
                    var26_28 = destination$iv$iv;
                    $i$a$-map-BattleTracker$applyCustomEVs$matchingEntry$1$2 = false;
                    v3 = a.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toLowerCase(...)");
                    var26_28.add(v3);
                }
                if (Intrinsics.areEqual((Object)var24_26, (Object)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)))) {
                    v4 = true;
                } else lbl-1000:
                // 3 sources

                {
                    v4 = false;
                }
                if (!v4) continue;
                v5 = var13_11;
                break block10;
            }
            v5 = null;
        }
        matchingEntry = v5;
        if (matchingEntry != null && matchingEntry.getEvSettings().getAllowCustomEvsOnDefeat()) {
            var11_9 = new Pair[]{TuplesKt.to((Object)Stats.HP, (Object)matchingEntry.getEvSettings().getEvHp()), TuplesKt.to((Object)Stats.ATTACK, (Object)matchingEntry.getEvSettings().getEvAttack()), TuplesKt.to((Object)Stats.DEFENCE, (Object)matchingEntry.getEvSettings().getEvDefense()), TuplesKt.to((Object)Stats.SPECIAL_ATTACK, (Object)matchingEntry.getEvSettings().getEvSpecialAttack()), TuplesKt.to((Object)Stats.SPECIAL_DEFENCE, (Object)matchingEntry.getEvSettings().getEvSpecialDefense()), TuplesKt.to((Object)Stats.SPEED, (Object)matchingEntry.getEvSettings().getEvSpeed())};
            customEvs = MapsKt.mapOf((Pair[])var11_9);
            evSource = new SidemodEvSource("cobblespawners", playerPokemon);
            $this$forEach$iv = customEvs;
            $i$f$forEach = false;
            var14_13 = $this$forEach$iv.entrySet().iterator();
            while (var14_13.hasNext()) {
                var16_16 = element$iv = var14_13.next();
                $i$a$-forEach-BattleTracker$applyCustomEVs$1 = false;
                stat = (Stats)var16_16.getKey();
                ev = ((Number)var16_16.getValue()).intValue();
                if (ev <= 0) continue;
                playerPokemon.getEvs().add((Stat)stat, ev, (EvSource)evSource);
            }
            LogDebugKt.logDebug((String)("Applied custom EVs to " + playerPokemon.getSpecies().getName() + ": " + customEvs), (String)"cobblespawners");
        } else {
            LogDebugKt.logDebug((String)("No matching Pok\u00e9monSpawnEntry with custom EVs for " + opponentPokemon.getSpecies().getName() + " at " + spawnerPos), (String)"cobblespawners");
        }
    }

    private final void cleanupBattle(UUID battleId) {
        this.ongoingBattles.remove(battleId);
    }

    private final UUID findBattleIdByPokemon(Pokemon pokemon) {
        Object v3;
        block9: {
            Collection<BattleInfo> collection = this.ongoingBattles.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                boolean bl;
                block8: {
                    BattleInfo battleInfo = (BattleInfo)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = battleInfo.getActors();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            block7: {
                                BattleActor actor = (BattleActor)element$iv;
                                boolean bl4 = false;
                                Iterable $this$any$iv2 = actor.getPokemonList();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        BattlePokemon it = (BattlePokemon)element$iv2;
                                        boolean bl5 = false;
                                        if (!Intrinsics.areEqual((Object)it.getEffectedPokemon().getUuid(), (Object)pokemon.getUuid())) continue;
                                        bl3 = true;
                                        break block7;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v3 = t;
                break block9;
            }
            v3 = null;
        }
        BattleInfo battleInfo = v3;
        return battleInfo != null ? battleInfo.getBattleId() : null;
    }

    private final UUID findBattleIdByPlayer(class_3222 player) {
        Object v2;
        block5: {
            Collection<BattleInfo> collection = this.ongoingBattles.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    BattleInfo battleInfo = (BattleInfo)t;
                    boolean bl2 = false;
                    Iterable $this$any$iv = battleInfo.getActors();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            BattleActor actor = (BattleActor)element$iv;
                            boolean bl3 = false;
                            if (!(actor instanceof PlayerBattleActor && ((PlayerBattleActor)actor).getPlayerUUIDs().contains(player.method_5667()))) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        BattleInfo battleInfo = v2;
        return battleInfo != null ? battleInfo.getBattleId() : null;
    }

    private final boolean playerIsNotInBattle(class_3222 player) {
        return this.getActiveBattleAndActor(player) == null;
    }

    private final Pair<PokemonBattle, BattleActor> getActiveBattleAndActor(class_3222 player) {
        PokemonBattle battle;
        PokemonBattle pokemonBattle = battle = BattleRegistry.getBattleByParticipatingPlayer((class_3222)player);
        BattleActor actor = pokemonBattle != null ? pokemonBattle.getActor(player) : null;
        return battle != null && actor != null ? new Pair((Object)battle, (Object)actor) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Triple<String, String, Set<String>> getPokemonVariantDetails(Pokemon pokemon) {
        void $this$filterTo$iv$iv;
        String speciesName = pokemon.getSpecies().getName();
        String formName = Intrinsics.areEqual((Object)pokemon.getForm().getName(), (Object)"Standard") ? "Normal" : pokemon.getForm().getName();
        Set pokemonAspects = CollectionsKt.toSet((Iterable)pokemon.getAspects());
        Object[] objectArray = new String[]{"male", "female"};
        Set genderAspects = SetsKt.setOf((Object[])objectArray);
        Iterable $this$filter$iv = pokemonAspects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!genderAspects.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set aspectsWithoutGender = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return new Triple((Object)speciesName, (Object)formName, (Object)aspectsWithoutGender);
    }

    private static final Unit registerEvents$lambda$0(BattleTracker this$0, BattleStartedEvent.Pre event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getBattle().getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this$0.handleBattleStartPre(uUID);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$1(BattleTracker this$0, BattleStartedEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getBattle().getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this$0.handleBattleStartPost(uUID, CollectionsKt.toList((Iterable)event.getBattle().getActors()));
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$2(BattleTracker this$0, PokemonSentEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.handlePokemonSent(event.getPokemon());
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$3(BattleTracker this$0, BattleVictoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getBattle().getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this$0.handleBattleVictory(uUID);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$4(BattleTracker this$0, BattleFledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uUID = event.getBattle().getBattleId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-battleId>(...)");
        this$0.handleBattleFlee(uUID);
        return Unit.INSTANCE;
    }

    private static final Unit registerEvents$lambda$5(BattleTracker this$0, PokemonCapturedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this$0.handlePokemonCaptured(event.getPokemon());
        return Unit.INSTANCE;
    }

    private static final void registerEvents$lambda$6(BattleTracker this$0, class_3244 handler, MinecraftServer minecraftServer) {
        class_3222 class_32222 = handler.field_14140;
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"player");
        this$0.handlePlayerLogout(class_32222);
    }

    private static final Unit startCleanupScheduler$lambda$7(BattleTracker this$0, MinecraftServer $server) {
        this$0.cleanupBattles($server);
        return Unit.INSTANCE;
    }

    private static final CharSequence saveOriginalEVs$lambda$33(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + ": " + it.getValue();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;", "", "<init>", "(Ljava/lang/String;I)V", "NORMAL_VICTORY", "FLED", "CAPTURED", "UNKNOWN", "cobblespawners"})
    public static final class BattleEndCause
    extends Enum<BattleEndCause> {
        public static final /* enum */ BattleEndCause NORMAL_VICTORY = new BattleEndCause();
        public static final /* enum */ BattleEndCause FLED = new BattleEndCause();
        public static final /* enum */ BattleEndCause CAPTURED = new BattleEndCause();
        public static final /* enum */ BattleEndCause UNKNOWN = new BattleEndCause();
        private static final /* synthetic */ BattleEndCause[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BattleEndCause[] values() {
            return (BattleEndCause[])$VALUES.clone();
        }

        public static BattleEndCause valueOf(String value) {
            return Enum.valueOf(BattleEndCause.class, value);
        }

        @NotNull
        public static EnumEntries<BattleEndCause> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = battleEndCauseArray = new BattleEndCause[]{BattleEndCause.NORMAL_VICTORY, BattleEndCause.FLED, BattleEndCause.CAPTURED, BattleEndCause.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u001d\n\u0002\u0010\u000e\n\u0002\b \b\u0086\b\u0018\u00002\u00020\u0001B\u00ab\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u0007\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u001c\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003\u00a2\u0006\u0004\b!\u0010 J\u0010\u0010\"\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0004\b$\u0010%J(\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u0007H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010 J\u0010\u0010'\u001a\u00020\u000bH\u00c6\u0003\u00a2\u0006\u0004\b'\u0010#J\u0012\u0010(\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0004\b(\u0010)J\u0010\u0010*\u001a\u00020\u0015H\u00c6\u0003\u00a2\u0006\u0004\b*\u0010+J\u0010\u0010,\u001a\u00020\u0017H\u00c6\u0003\u00a2\u0006\u0004\b,\u0010-J\u00b8\u0001\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00072\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0002\u0010\f\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2 \b\u0002\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u00072\b\b\u0002\u0010\u0013\u001a\u00020\u000b2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u00c6\u0001\u00a2\u0006\u0004\b.\u0010/J\u001a\u00101\u001a\u00020\u000b2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b1\u00102J\u0010\u00103\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b3\u00104J\u0010\u00106\u001a\u000205H\u00d6\u0001\u00a2\u0006\u0004\b6\u00107R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u00108\u001a\u0004\b9\u0010\u001cR(\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010:\u001a\u0004\b;\u0010\u001e\"\u0004\b<\u0010=R#\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010>\u001a\u0004\b?\u0010 R#\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u0010>\u001a\u0004\b@\u0010 R\"\u0010\f\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\f\u0010A\u001a\u0004\b\f\u0010#\"\u0004\bB\u0010CR$\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010D\u001a\u0004\bE\u0010%\"\u0004\bF\u0010GR/\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u00078\u0006\u00a2\u0006\f\n\u0004\b\u0012\u0010>\u001a\u0004\bH\u0010 R\"\u0010\u0013\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010A\u001a\u0004\bI\u0010#\"\u0004\bJ\u0010CR$\u0010\u0014\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010K\u001a\u0004\bL\u0010)\"\u0004\bM\u0010NR\"\u0010\u0016\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010O\u001a\u0004\bP\u0010+\"\u0004\bQ\u0010RR\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010S\u001a\u0004\bT\u0010-\u00a8\u0006U"}, d2={"Lcom/cobblespawners/utils/BattleTracker$BattleInfo;", "", "Ljava/util/UUID;", "battleId", "", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actors", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "participatingPlayerMons", "lastActiveOpponentMon", "", "isOpponentFromSpawner", "Lnet/minecraft/class_2338;", "spawnerPos", "", "Lcom/cobblemon/mod/common/api/pokemon/stats/Stat;", "", "originalEVMap", "valuesApplied", "currentActivePlayerPokemon", "Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;", "endCause", "", "startTime", "<init>", "(Ljava/util/UUID;Ljava/util/List;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ConcurrentHashMap;ZLnet/minecraft/class_2338;Ljava/util/concurrent/ConcurrentHashMap;ZLcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;J)V", "component1", "()Ljava/util/UUID;", "component2", "()Ljava/util/List;", "component3", "()Ljava/util/concurrent/ConcurrentHashMap;", "component4", "component5", "()Z", "component6", "()Lnet/minecraft/class_2338;", "component7", "component8", "component9", "()Lcom/cobblemon/mod/common/pokemon/Pokemon;", "component10", "()Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;", "component11", "()J", "copy", "(Ljava/util/UUID;Ljava/util/List;Ljava/util/concurrent/ConcurrentHashMap;Ljava/util/concurrent/ConcurrentHashMap;ZLnet/minecraft/class_2338;Ljava/util/concurrent/ConcurrentHashMap;ZLcom/cobblemon/mod/common/pokemon/Pokemon;Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;J)Lcom/cobblespawners/utils/BattleTracker$BattleInfo;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getBattleId", "Ljava/util/List;", "getActors", "setActors", "(Ljava/util/List;)V", "Ljava/util/concurrent/ConcurrentHashMap;", "getParticipatingPlayerMons", "getLastActiveOpponentMon", "Z", "setOpponentFromSpawner", "(Z)V", "Lnet/minecraft/class_2338;", "getSpawnerPos", "setSpawnerPos", "(Lnet/minecraft/class_2338;)V", "getOriginalEVMap", "getValuesApplied", "setValuesApplied", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "getCurrentActivePlayerPokemon", "setCurrentActivePlayerPokemon", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;", "getEndCause", "setEndCause", "(Lcom/cobblespawners/utils/BattleTracker$BattleEndCause;)V", "J", "getStartTime", "cobblespawners"})
    public static final class BattleInfo {
        @NotNull
        private final UUID battleId;
        @NotNull
        private List<? extends BattleActor> actors;
        @NotNull
        private final ConcurrentHashMap<UUID, Pokemon> participatingPlayerMons;
        @NotNull
        private final ConcurrentHashMap<UUID, Pokemon> lastActiveOpponentMon;
        private boolean isOpponentFromSpawner;
        @Nullable
        private class_2338 spawnerPos;
        @NotNull
        private final ConcurrentHashMap<UUID, Map<Stat, Integer>> originalEVMap;
        private boolean valuesApplied;
        @Nullable
        private Pokemon currentActivePlayerPokemon;
        @NotNull
        private BattleEndCause endCause;
        private final long startTime;

        public BattleInfo(@NotNull UUID battleId, @NotNull List<? extends BattleActor> actors, @NotNull ConcurrentHashMap<UUID, Pokemon> participatingPlayerMons, @NotNull ConcurrentHashMap<UUID, Pokemon> lastActiveOpponentMon, boolean isOpponentFromSpawner, @Nullable class_2338 spawnerPos, @NotNull ConcurrentHashMap<UUID, Map<Stat, Integer>> originalEVMap, boolean valuesApplied, @Nullable Pokemon currentActivePlayerPokemon, @NotNull BattleEndCause endCause, long startTime) {
            Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
            Intrinsics.checkNotNullParameter(actors, (String)"actors");
            Intrinsics.checkNotNullParameter(participatingPlayerMons, (String)"participatingPlayerMons");
            Intrinsics.checkNotNullParameter(lastActiveOpponentMon, (String)"lastActiveOpponentMon");
            Intrinsics.checkNotNullParameter(originalEVMap, (String)"originalEVMap");
            Intrinsics.checkNotNullParameter((Object)((Object)endCause), (String)"endCause");
            this.battleId = battleId;
            this.actors = actors;
            this.participatingPlayerMons = participatingPlayerMons;
            this.lastActiveOpponentMon = lastActiveOpponentMon;
            this.isOpponentFromSpawner = isOpponentFromSpawner;
            this.spawnerPos = spawnerPos;
            this.originalEVMap = originalEVMap;
            this.valuesApplied = valuesApplied;
            this.currentActivePlayerPokemon = currentActivePlayerPokemon;
            this.endCause = endCause;
            this.startTime = startTime;
        }

        public /* synthetic */ BattleInfo(UUID uUID, List list, ConcurrentHashMap concurrentHashMap, ConcurrentHashMap concurrentHashMap2, boolean bl, class_2338 class_23382, ConcurrentHashMap concurrentHashMap3, boolean bl2, Pokemon pokemon, BattleEndCause battleEndCause, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                concurrentHashMap = new ConcurrentHashMap<UUID, Pokemon>();
            }
            if ((n & 8) != 0) {
                concurrentHashMap2 = new ConcurrentHashMap<UUID, Pokemon>();
            }
            if ((n & 0x10) != 0) {
                bl = false;
            }
            if ((n & 0x20) != 0) {
                class_23382 = null;
            }
            if ((n & 0x40) != 0) {
                concurrentHashMap3 = new ConcurrentHashMap<UUID, Map<Stat, Integer>>();
            }
            if ((n & 0x80) != 0) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                pokemon = null;
            }
            if ((n & 0x200) != 0) {
                battleEndCause = BattleEndCause.UNKNOWN;
            }
            if ((n & 0x400) != 0) {
                l = System.currentTimeMillis();
            }
            this(uUID, list, concurrentHashMap, concurrentHashMap2, bl, class_23382, concurrentHashMap3, bl2, pokemon, battleEndCause, l);
        }

        @NotNull
        public final UUID getBattleId() {
            return this.battleId;
        }

        @NotNull
        public final List<BattleActor> getActors() {
            return this.actors;
        }

        public final void setActors(@NotNull List<? extends BattleActor> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.actors = list;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Pokemon> getParticipatingPlayerMons() {
            return this.participatingPlayerMons;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Pokemon> getLastActiveOpponentMon() {
            return this.lastActiveOpponentMon;
        }

        public final boolean isOpponentFromSpawner() {
            return this.isOpponentFromSpawner;
        }

        public final void setOpponentFromSpawner(boolean bl) {
            this.isOpponentFromSpawner = bl;
        }

        @Nullable
        public final class_2338 getSpawnerPos() {
            return this.spawnerPos;
        }

        public final void setSpawnerPos(@Nullable class_2338 class_23382) {
            this.spawnerPos = class_23382;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Map<Stat, Integer>> getOriginalEVMap() {
            return this.originalEVMap;
        }

        public final boolean getValuesApplied() {
            return this.valuesApplied;
        }

        public final void setValuesApplied(boolean bl) {
            this.valuesApplied = bl;
        }

        @Nullable
        public final Pokemon getCurrentActivePlayerPokemon() {
            return this.currentActivePlayerPokemon;
        }

        public final void setCurrentActivePlayerPokemon(@Nullable Pokemon pokemon) {
            this.currentActivePlayerPokemon = pokemon;
        }

        @NotNull
        public final BattleEndCause getEndCause() {
            return this.endCause;
        }

        public final void setEndCause(@NotNull BattleEndCause battleEndCause) {
            Intrinsics.checkNotNullParameter((Object)((Object)battleEndCause), (String)"<set-?>");
            this.endCause = battleEndCause;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public final UUID component1() {
            return this.battleId;
        }

        @NotNull
        public final List<BattleActor> component2() {
            return this.actors;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Pokemon> component3() {
            return this.participatingPlayerMons;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Pokemon> component4() {
            return this.lastActiveOpponentMon;
        }

        public final boolean component5() {
            return this.isOpponentFromSpawner;
        }

        @Nullable
        public final class_2338 component6() {
            return this.spawnerPos;
        }

        @NotNull
        public final ConcurrentHashMap<UUID, Map<Stat, Integer>> component7() {
            return this.originalEVMap;
        }

        public final boolean component8() {
            return this.valuesApplied;
        }

        @Nullable
        public final Pokemon component9() {
            return this.currentActivePlayerPokemon;
        }

        @NotNull
        public final BattleEndCause component10() {
            return this.endCause;
        }

        public final long component11() {
            return this.startTime;
        }

        @NotNull
        public final BattleInfo copy(@NotNull UUID battleId, @NotNull List<? extends BattleActor> actors, @NotNull ConcurrentHashMap<UUID, Pokemon> participatingPlayerMons, @NotNull ConcurrentHashMap<UUID, Pokemon> lastActiveOpponentMon, boolean isOpponentFromSpawner, @Nullable class_2338 spawnerPos, @NotNull ConcurrentHashMap<UUID, Map<Stat, Integer>> originalEVMap, boolean valuesApplied, @Nullable Pokemon currentActivePlayerPokemon, @NotNull BattleEndCause endCause, long startTime) {
            Intrinsics.checkNotNullParameter((Object)battleId, (String)"battleId");
            Intrinsics.checkNotNullParameter(actors, (String)"actors");
            Intrinsics.checkNotNullParameter(participatingPlayerMons, (String)"participatingPlayerMons");
            Intrinsics.checkNotNullParameter(lastActiveOpponentMon, (String)"lastActiveOpponentMon");
            Intrinsics.checkNotNullParameter(originalEVMap, (String)"originalEVMap");
            Intrinsics.checkNotNullParameter((Object)((Object)endCause), (String)"endCause");
            return new BattleInfo(battleId, actors, participatingPlayerMons, lastActiveOpponentMon, isOpponentFromSpawner, spawnerPos, originalEVMap, valuesApplied, currentActivePlayerPokemon, endCause, startTime);
        }

        public static /* synthetic */ BattleInfo copy$default(BattleInfo battleInfo, UUID uUID, List list, ConcurrentHashMap concurrentHashMap, ConcurrentHashMap concurrentHashMap2, boolean bl, class_2338 class_23382, ConcurrentHashMap concurrentHashMap3, boolean bl2, Pokemon pokemon, BattleEndCause battleEndCause, long l, int n, Object object) {
            if ((n & 1) != 0) {
                uUID = battleInfo.battleId;
            }
            if ((n & 2) != 0) {
                list = battleInfo.actors;
            }
            if ((n & 4) != 0) {
                concurrentHashMap = battleInfo.participatingPlayerMons;
            }
            if ((n & 8) != 0) {
                concurrentHashMap2 = battleInfo.lastActiveOpponentMon;
            }
            if ((n & 0x10) != 0) {
                bl = battleInfo.isOpponentFromSpawner;
            }
            if ((n & 0x20) != 0) {
                class_23382 = battleInfo.spawnerPos;
            }
            if ((n & 0x40) != 0) {
                concurrentHashMap3 = battleInfo.originalEVMap;
            }
            if ((n & 0x80) != 0) {
                bl2 = battleInfo.valuesApplied;
            }
            if ((n & 0x100) != 0) {
                pokemon = battleInfo.currentActivePlayerPokemon;
            }
            if ((n & 0x200) != 0) {
                battleEndCause = battleInfo.endCause;
            }
            if ((n & 0x400) != 0) {
                l = battleInfo.startTime;
            }
            return battleInfo.copy(uUID, list, concurrentHashMap, concurrentHashMap2, bl, class_23382, concurrentHashMap3, bl2, pokemon, battleEndCause, l);
        }

        @NotNull
        public String toString() {
            return "BattleInfo(battleId=" + this.battleId + ", actors=" + this.actors + ", participatingPlayerMons=" + this.participatingPlayerMons + ", lastActiveOpponentMon=" + this.lastActiveOpponentMon + ", isOpponentFromSpawner=" + this.isOpponentFromSpawner + ", spawnerPos=" + this.spawnerPos + ", originalEVMap=" + this.originalEVMap + ", valuesApplied=" + this.valuesApplied + ", currentActivePlayerPokemon=" + this.currentActivePlayerPokemon + ", endCause=" + this.endCause + ", startTime=" + this.startTime + ")";
        }

        public int hashCode() {
            int result = this.battleId.hashCode();
            result = result * 31 + ((Object)this.actors).hashCode();
            result = result * 31 + this.participatingPlayerMons.hashCode();
            result = result * 31 + this.lastActiveOpponentMon.hashCode();
            result = result * 31 + Boolean.hashCode(this.isOpponentFromSpawner);
            result = result * 31 + (this.spawnerPos == null ? 0 : this.spawnerPos.hashCode());
            result = result * 31 + this.originalEVMap.hashCode();
            result = result * 31 + Boolean.hashCode(this.valuesApplied);
            result = result * 31 + (this.currentActivePlayerPokemon == null ? 0 : this.currentActivePlayerPokemon.hashCode());
            result = result * 31 + this.endCause.hashCode();
            result = result * 31 + Long.hashCode(this.startTime);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BattleInfo)) {
                return false;
            }
            BattleInfo battleInfo = (BattleInfo)other;
            if (!Intrinsics.areEqual((Object)this.battleId, (Object)battleInfo.battleId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.actors, battleInfo.actors)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.participatingPlayerMons, battleInfo.participatingPlayerMons)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.lastActiveOpponentMon, battleInfo.lastActiveOpponentMon)) {
                return false;
            }
            if (this.isOpponentFromSpawner != battleInfo.isOpponentFromSpawner) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.spawnerPos, (Object)battleInfo.spawnerPos)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.originalEVMap, battleInfo.originalEVMap)) {
                return false;
            }
            if (this.valuesApplied != battleInfo.valuesApplied) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.currentActivePlayerPokemon, (Object)battleInfo.currentActivePlayerPokemon)) {
                return false;
            }
            if (this.endCause != battleInfo.endCause) {
                return false;
            }
            return this.startTime == battleInfo.startTime;
        }
    }
}

