/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners.mixin;

import com.cobblespawners.api.SpawnerDataProvider;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public class SpawnerEntityDataMixin
implements SpawnerDataProvider {
    @Unique
    private static final String NBT_KEY = "CobbleSpawnerData";
    @Unique
    private static final String SPAWNER_POS_KEY = "SpawnerPos";
    @Unique
    private static final String SPAWNER_DIMENSION_KEY = "SpawnerDimension";
    @Unique
    private static final String SPECIES_NAME_KEY = "SpeciesName";
    @Unique
    private static final String SPAWN_TIME_KEY = "SpawnTime";
    @Unique
    private static final String SPAWNER_UUID_KEY = "SpawnerUUID";
    @Unique
    private class_2338 spawnerPos = null;
    @Unique
    private String spawnerDimension = "";
    @Unique
    private String speciesName = "";
    @Unique
    private long spawnTime = 0L;
    @Unique
    private UUID spawnerUUID = null;
    @Unique
    private boolean isFromSpawner = false;

    @Inject(method={"writeNbt"}, at={@At(value="HEAD")})
    private void writeSpawnerData(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (this.isFromSpawner && this.spawnerPos != null && this.spawnerUUID != null) {
            class_2487 spawnerData = new class_2487();
            spawnerData.method_10569("X", this.spawnerPos.method_10263());
            spawnerData.method_10569("Y", this.spawnerPos.method_10264());
            spawnerData.method_10569("Z", this.spawnerPos.method_10260());
            spawnerData.method_10582(SPAWNER_DIMENSION_KEY, this.spawnerDimension);
            spawnerData.method_10582(SPECIES_NAME_KEY, this.speciesName);
            spawnerData.method_10544(SPAWN_TIME_KEY, this.spawnTime);
            spawnerData.method_25927(SPAWNER_UUID_KEY, this.spawnerUUID);
            nbt.method_10566(NBT_KEY, (class_2520)spawnerData);
        }
    }

    @Inject(method={"readNbt"}, at={@At(value="HEAD")})
    private void readSpawnerData(class_2487 nbt, CallbackInfo ci) {
        if (nbt != null && nbt.method_10545(NBT_KEY)) {
            class_2487 spawnerData = nbt.method_10562(NBT_KEY);
            int x = spawnerData.method_10550("X");
            int y = spawnerData.method_10550("Y");
            int z = spawnerData.method_10550("Z");
            this.spawnerPos = new class_2338(x, y, z);
            this.spawnerDimension = spawnerData.method_10558(SPAWNER_DIMENSION_KEY);
            this.speciesName = spawnerData.method_10558(SPECIES_NAME_KEY);
            this.spawnTime = spawnerData.method_10537(SPAWN_TIME_KEY);
            this.spawnerUUID = spawnerData.method_25926(SPAWNER_UUID_KEY);
            this.isFromSpawner = true;
        } else {
            this.resetData();
        }
    }

    @Unique
    private void resetData() {
        this.spawnerPos = null;
        this.spawnerDimension = "";
        this.speciesName = "";
        this.spawnTime = 0L;
        this.spawnerUUID = null;
        this.isFromSpawner = false;
    }

    @Override
    public void cobblespawners$setSpawnerData(class_2338 pos, String dimension, String species, UUID uuid) {
        this.spawnerPos = pos;
        this.spawnerDimension = dimension;
        this.speciesName = species;
        this.spawnerUUID = uuid;
        this.spawnTime = System.currentTimeMillis();
        this.isFromSpawner = pos != null;
    }

    @Override
    public class_2338 cobblespawners$getSpawnerPos() {
        return this.spawnerPos;
    }

    @Override
    public String cobblespawners$getSpawnerDimension() {
        return this.spawnerDimension;
    }

    @Override
    public String cobblespawners$getSpeciesName() {
        return this.speciesName;
    }

    @Override
    public UUID cobblespawners$getSpawnerUUID() {
        return this.spawnerUUID;
    }

    @Override
    public boolean cobblespawners$isFromSpawner() {
        return this.isFromSpawner;
    }

    @Override
    public long cobblespawners$getSpawnTime() {
        return this.spawnTime;
    }
}

