/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners.api;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblespawners.api.SpawnerDataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_3218;

public class SpawnerNBTManager {
    private static final Map<UUID, Set<UUID>> SPAWNER_ENTITY_TRACKER = new ConcurrentHashMap<UUID, Set<UUID>>();

    public static UUID createSpawnerUUID(class_2338 pos) {
        return UUID.nameUUIDFromBytes(("cobblespawner:" + pos.method_23854()).getBytes());
    }

    public static void addPokemon(PokemonEntity entity, class_2338 spawnerPos, String speciesName) {
        if (entity instanceof SpawnerDataProvider) {
            SpawnerDataProvider provider = (SpawnerDataProvider)entity;
            UUID spawnerUUID = SpawnerNBTManager.createSpawnerUUID(spawnerPos);
            provider.cobblespawners$setSpawnerData(spawnerPos, entity.method_37908().method_27983().method_29177().toString(), speciesName, spawnerUUID);
            SPAWNER_ENTITY_TRACKER.computeIfAbsent(spawnerUUID, k -> ConcurrentHashMap.newKeySet()).add(entity.method_5667());
        }
    }

    public static PokemonInfo getPokemonInfo(PokemonEntity entity) {
        SpawnerDataProvider provider;
        if (entity instanceof SpawnerDataProvider && (provider = (SpawnerDataProvider)entity).cobblespawners$isFromSpawner()) {
            return new PokemonInfo(provider.cobblespawners$getSpawnerPos(), provider.cobblespawners$getSpeciesName());
        }
        return null;
    }

    public static List<UUID> getUUIDsForSpawner(class_3218 world, class_2338 spawnerPos) {
        UUID spawnerUUID = SpawnerNBTManager.createSpawnerUUID(spawnerPos);
        Set tracked = SPAWNER_ENTITY_TRACKER.getOrDefault(spawnerUUID, Collections.emptySet());
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        Iterator iterator = tracked.iterator();
        while (iterator.hasNext()) {
            UUID uuid = (UUID)iterator.next();
            if (world.method_14190(uuid) != null) {
                uuids.add(uuid);
                continue;
            }
            iterator.remove();
        }
        return uuids;
    }

    public static int getPokemonCountForSpawner(class_3218 world, class_2338 spawnerPos) {
        UUID spawnerUUID = SpawnerNBTManager.createSpawnerUUID(spawnerPos);
        Set tracked = SPAWNER_ENTITY_TRACKER.getOrDefault(spawnerUUID, Collections.emptySet());
        int count = 0;
        Iterator iterator = tracked.iterator();
        while (iterator.hasNext()) {
            UUID uuid = (UUID)iterator.next();
            if (world.method_14190(uuid) != null) {
                ++count;
                continue;
            }
            iterator.remove();
        }
        return count;
    }

    public static void clearPokemonForSpawner(class_3218 world, class_2338 spawnerPos) {
        UUID spawnerUUID = SpawnerNBTManager.createSpawnerUUID(spawnerPos);
        Set<UUID> tracked = SPAWNER_ENTITY_TRACKER.get(spawnerUUID);
        if (tracked != null) {
            for (UUID uuid : new ArrayList<UUID>(tracked)) {
                class_1297 class_12972 = world.method_14190(uuid);
                if (!(class_12972 instanceof PokemonEntity)) continue;
                PokemonEntity entity = (PokemonEntity)class_12972;
                entity.method_31472();
                tracked.remove(uuid);
            }
        }
    }

    public static class PokemonInfo {
        private final class_2338 spawnerPos;
        private final String speciesName;
        private final long lastKnownTime;

        public PokemonInfo(class_2338 spawnerPos, String speciesName) {
            this.spawnerPos = spawnerPos;
            this.speciesName = speciesName;
            this.lastKnownTime = System.currentTimeMillis();
        }

        public class_2338 getSpawnerPos() {
            return this.spawnerPos;
        }

        public String getSpeciesName() {
            return this.speciesName;
        }

        public long getLastKnownTime() {
            return this.lastKnownTime;
        }
    }
}

