/*
 * Decompiled with CFR 0.152.
 */
package com.cobblespawners;

import com.cobblespawners.CobbleSpawners;
import com.cobblespawners.api.SpawnerNBTManager;
import com.cobblespawners.utils.CobbleSpawnersConfig;
import com.cobblespawners.utils.SpawnRadius;
import com.cobblespawners.utils.SpawnerData;
import com.cobblespawners.utils.WanderingSettings;
import com.cobblespawners.utils.gui.SpawnerPokemonSelectionGui;
import com.everlastingutils.command.CommandManager;
import com.everlastingutils.utils.LogDebugKt;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J'\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J/\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0003J\u001f\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001c\u0010!\u001a\n  *\u0004\u0018\u00010\u001f0\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/cobblespawners/SpawnerBlockEvents;", "", "<init>", "()V", "", "registerEvents", "Lnet/minecraft/class_3222;", "player", "", "permission", "", "requiredLevel", "", "hasPermission", "(Lnet/minecraft/class_3222;Ljava/lang/String;I)Z", "registerUseBlockCallback", "getNextSpawnerName", "()Ljava/lang/String;", "Lnet/minecraft/class_1937;", "world", "Lnet/minecraft/class_2338;", "pos", "Lnet/minecraft/class_1799;", "itemInHand", "placeCustomSpawner", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_1937;Lnet/minecraft/class_2338;Lnet/minecraft/class_1799;)V", "registerBlockBreakCallback", "Lnet/minecraft/class_3218;", "changedBlockPos", "invalidatePositionsIfWithinRadius", "(Lnet/minecraft/class_3218;Lnet/minecraft/class_2338;)V", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "cobblespawners"})
@SourceDebugExtension(value={"SMAP\nSpawnerBlockEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnerBlockEvents.kt\ncom/cobblespawners/SpawnerBlockEvents\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,269:1\n1557#2:270\n1628#2,3:271\n774#2:274\n865#2,2:275\n1611#2,9:277\n1863#2:286\n1864#2:288\n1620#2:289\n1#3:287\n1#3:290\n*S KotlinDebug\n*F\n+ 1 SpawnerBlockEvents.kt\ncom/cobblespawners/SpawnerBlockEvents\n*L\n88#1:270\n88#1:271,3\n89#1:274\n89#1:275,2\n90#1:277,9\n90#1:286\n90#1:288\n90#1:289\n90#1:287\n*E\n"})
public final class SpawnerBlockEvents {
    @NotNull
    public static final SpawnerBlockEvents INSTANCE = new SpawnerBlockEvents();
    private static final Logger logger = LoggerFactory.getLogger((String)"cobblespawners");

    private SpawnerBlockEvents() {
    }

    public final void registerEvents() {
        this.registerUseBlockCallback();
        this.registerBlockBreakCallback();
    }

    private final boolean hasPermission(class_3222 player, String permission, int requiredLevel) {
        class_2168 source = player.method_5671();
        Intrinsics.checkNotNull((Object)source);
        return CommandManager.Companion.hasPermissionOrOp(source, permission, requiredLevel, requiredLevel);
    }

    private final void registerUseBlockCallback() {
        UseBlockCallback.EVENT.register(SpawnerBlockEvents::registerUseBlockCallback$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    private final String getNextSpawnerName() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        String it;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = CobbleSpawnersConfig.INSTANCE.getSpawners().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (SpawnerData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((SpawnerData)((Object)it)).getSpawnerName());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)"spawner_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if (StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)it2, (CharSequence)"spawner_")) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set existingNumbers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        int number = 1;
        while (existingNumbers.contains(number)) {
            ++number;
        }
        return "spawner_" + number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void placeCustomSpawner(class_3222 player, class_1937 world, class_2338 pos, class_1799 itemInHand) {
        SpawnerData spawnerData;
        if (!this.hasPermission(player, "CobbleSpawners.Place", 2)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You don't have permission to place a custom spawner."), false);
            return;
        }
        if (CobbleSpawnersConfig.INSTANCE.getSpawners().containsKey(pos)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"A spawner already exists at this location!"), false);
            return;
        }
        class_2680 blockState = world.method_8320(pos);
        if (Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10382) || Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10164)) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        world.method_8501(pos, class_2246.field_10260.method_9564());
        String dimensionString = world.method_27983().method_29177().method_12836() + ":" + world.method_27983().method_29177().method_12832();
        Gson gson = new Gson();
        String spawnerName = this.getNextSpawnerName();
        class_9279 nbtComponent = (class_9279)itemInHand.method_57824(class_9334.field_49628);
        if (nbtComponent != null) {
            SpawnerData loadedData;
            SpawnerData spawnerData2;
            class_2487 nbt = nbtComponent.method_57463();
            Object configJson = null;
            if (nbt.method_10545("CobbleSpawnerConfigCompressed")) {
                byte[] compressedData = nbt.method_10547("CobbleSpawnerConfigCompressed");
                try {
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(compressedData);
                    Closeable closeable = new GZIPInputStream(inputStream);
                    Object object = Charsets.UTF_8;
                    Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
                    int n = 8192;
                    closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    object = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        object2 = TextStreamsKt.readText((Reader)it);
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                    }
                    configJson = object2;
                }
                catch (Exception e) {
                    logger.error("Failed to decompress spawner config from item!", (Throwable)e);
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Could not read compressed spawner data."), false);
                }
            } else if (nbt.method_10545("CobbleSpawnerConfig")) {
                configJson = nbt.method_10558("CobbleSpawnerConfig");
            }
            if (configJson != null) {
                SpawnerData spawnerData3;
                try {
                    spawnerData3 = (SpawnerData)gson.fromJson((String)configJson, SpawnerData.class);
                }
                catch (Exception e) {
                    logger.error("Failed to parse spawner JSON from item!", (Throwable)e);
                    player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cError: Could not parse spawner JSON data."), false);
                    spawnerData3 = null;
                }
                spawnerData2 = spawnerData3;
            } else {
                spawnerData2 = null;
            }
            if ((spawnerData = (loadedData = spawnerData2)) == null || (spawnerData = SpawnerData.copy$default(spawnerData, null, null, pos, spawnerName, null, dimensionString, 0L, null, 0, 0, false, false, null, false, 0, false, 0, 131027, null)) == null) {
                spawnerData = new SpawnerData(null, null, pos, spawnerName, new ArrayList(), dimensionString, 200L, new SpawnRadius(4, 4), 4, 1, true, false, new WanderingSettings(false, null, 0, 7, null), false, 0, false, 0, 124931, null);
            }
        } else {
            spawnerData = new SpawnerData(null, null, pos, spawnerName, new ArrayList(), dimensionString, 200L, new SpawnRadius(4, 4), 4, 1, true, false, new WanderingSettings(false, null, 0, 7, null), false, 0, false, 0, 124931, null);
        }
        SpawnerData spawnerData4 = spawnerData;
        CobbleSpawnersConfig.INSTANCE.getSpawners().put(pos, spawnerData4);
        CobbleSpawnersConfig.INSTANCE.getConfig().getSpawners().add(spawnerData4);
        CobbleSpawnersConfig.INSTANCE.saveSpawnerData();
        CobbleSpawnersConfig.INSTANCE.saveConfigBlocking();
        if (spawnerData4.getForceChunkLoading() && world instanceof class_3218) {
            class_1923 chunkPos = new class_1923(pos);
            ((class_3218)world).method_14178().method_17297(CobbleSpawners.INSTANCE.getSPAWNER_TICKET_TYPE(), chunkPos, spawnerData4.getChunkLoadRadius(), (Object)pos);
            LogDebugKt.logDebug((String)("Added chunk ticket for spawner '" + spawnerData4.getSpawnerName() + "' at " + pos), (String)"cobblespawners");
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("Custom spawner '" + spawnerData4.getSpawnerName() + "' placed at " + pos + "!")), false);
        if (!player.method_31549().field_7477) {
            itemInHand.method_7934(1);
        }
    }

    private final void registerBlockBreakCallback() {
        PlayerBlockBreakEvents.BEFORE.register(SpawnerBlockEvents::registerBlockBreakCallback$lambda$7);
    }

    private final void invalidatePositionsIfWithinRadius(class_3218 world, class_2338 changedBlockPos) {
        for (Map.Entry<class_2338, SpawnerData> entry : CobbleSpawnersConfig.INSTANCE.getSpawners().entrySet()) {
            double maxDistanceSquared;
            double distanceSquared;
            class_2338 pos = entry.getKey();
            SpawnerData data = entry.getValue();
            SpawnRadius spawnRadius = data.getSpawnRadius();
            if (spawnRadius == null || !((distanceSquared = pos.method_10262((class_2382)changedBlockPos)) <= (maxDistanceSquared = (double)(spawnRadius.getWidth() * spawnRadius.getWidth())))) continue;
            CobbleSpawners.INSTANCE.getSpawnerValidPositions().remove(pos);
            LogDebugKt.logDebug((String)("Invalidated cached positions for spawner at " + pos + " due to block change @ " + changedBlockPos), (String)"cobblespawners");
        }
    }

    private static final class_1269 registerUseBlockCallback$lambda$0(class_1657 player, class_1937 world, class_1268 hand, class_3965 hitResult) {
        if (player instanceof class_3222 && hand == class_1268.field_5808 && hitResult != null) {
            class_2338 blockPosToPlace;
            class_2680 blockAtPlacement;
            class_2338 blockPos = hitResult.method_17777();
            class_2680 blockState = world.method_8320(blockPos);
            class_1799 itemInHand = ((class_3222)player).method_5998(hand);
            class_9280 modelData = (class_9280)itemInHand.method_57824(class_9334.field_49637);
            if (Intrinsics.areEqual((Object)itemInHand.method_7909(), (Object)class_1802.field_8849) && modelData != null && modelData.comp_2382() == 16666 && ((blockAtPlacement = world.method_8320(blockPosToPlace = hitResult.method_17777().method_10093(hitResult.method_17780()))).method_26215() || blockAtPlacement.method_26204().method_9564().method_45474())) {
                LogDebugKt.logDebug((String)("Attempting to place custom spawner at " + blockPosToPlace), (String)"cobblespawners");
                class_3222 class_32222 = (class_3222)player;
                Intrinsics.checkNotNull((Object)world);
                Intrinsics.checkNotNull((Object)blockPosToPlace);
                Intrinsics.checkNotNull((Object)itemInHand);
                INSTANCE.placeCustomSpawner(class_32222, world, blockPosToPlace, itemInHand);
                return class_1269.field_5812;
            }
            if (Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10260) && CobbleSpawnersConfig.INSTANCE.getSpawners().containsKey(blockPos)) {
                if (INSTANCE.hasPermission((class_3222)player, "CobbleSpawners.Edit", 2)) {
                    class_3222 class_32223 = (class_3222)player;
                    Intrinsics.checkNotNull((Object)blockPos);
                    SpawnerPokemonSelectionGui.openSpawnerGui$default(SpawnerPokemonSelectionGui.INSTANCE, class_32223, blockPos, 0, 4, null);
                    return class_1269.field_5812;
                }
                ((class_3222)player).method_7353((class_2561)class_2561.method_43470((String)"You don't have permission to manage this spawner."), false);
            }
        }
        return class_1269.field_5811;
    }

    private static final boolean registerBlockBreakCallback$lambda$7$lambda$5(class_2338 $blockPos, SpawnerData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getSpawnerPos(), (Object)$blockPos);
    }

    private static final boolean registerBlockBreakCallback$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean registerBlockBreakCallback$lambda$7(class_1937 world, class_1657 player, class_2338 blockPos, class_2680 blockState, class_2586 class_25862) {
        class_3222 class_32222 = player instanceof class_3222 ? (class_3222)player : null;
        if (class_32222 == null) {
            return true;
        }
        class_3222 serverPlayer = class_32222;
        SpawnerData spawnerData = CobbleSpawnersConfig.INSTANCE.getSpawners().get(blockPos);
        if (!(world instanceof class_3218)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)blockState.method_26204(), (Object)class_2246.field_10260) && CobbleSpawnersConfig.INSTANCE.getSpawners().containsKey(blockPos)) {
            if (!INSTANCE.hasPermission(serverPlayer, "CobbleSpawners.break", 2)) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You don't have permission to remove this spawner."), false);
                return false;
            }
            if (spawnerData != null && spawnerData.getForceChunkLoading()) {
                class_1923 chunkPos = new class_1923(blockPos);
                ((class_3218)world).method_14178().method_17300(CobbleSpawners.INSTANCE.getSPAWNER_TICKET_TYPE(), chunkPos, spawnerData.getChunkLoadRadius(), (Object)blockPos);
                LogDebugKt.logDebug((String)("Removed chunk ticket for spawner '" + spawnerData.getSpawnerName() + "' at " + blockPos), (String)"cobblespawners");
            }
            CobbleSpawnersConfig.INSTANCE.getSpawners().remove(blockPos);
            CobbleSpawnersConfig.INSTANCE.getConfig().getSpawners().removeIf(arg_0 -> SpawnerBlockEvents.registerBlockBreakCallback$lambda$7$lambda$6(arg_0 -> SpawnerBlockEvents.registerBlockBreakCallback$lambda$7$lambda$5(blockPos, arg_0), arg_0));
            CobbleSpawnersConfig.INSTANCE.saveSpawnerData();
            CobbleSpawnersConfig.INSTANCE.saveConfigBlocking();
            SpawnerNBTManager.clearPokemonForSpawner((class_3218)world, blockPos);
            CobbleSpawners.INSTANCE.getSpawnerValidPositions().remove(blockPos);
            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Custom spawner removed at " + blockPos + ".")), false);
            LogDebugKt.logDebug((String)("Custom spawner removed at " + blockPos + "."), (String)"cobblespawners");
        } else {
            class_3218 class_32182 = (class_3218)world;
            Intrinsics.checkNotNull((Object)blockPos);
            INSTANCE.invalidatePositionsIfWithinRadius(class_32182, blockPos);
        }
        return true;
    }
}

