/*
 * Decompiled with CFR 0.152.
 */
package com.lunazstudios.cobblefurnies.block;

import com.lunazstudios.cobblefurnies.block.properties.CFBlockStateProperties;
import com.lunazstudios.cobblefurnies.block.properties.CurtainHorizontalPart;
import com.lunazstudios.cobblefurnies.block.properties.CurtainVerticalPart;
import com.lunazstudios.cobblefurnies.util.block.ShapeUtil;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class CurtainBlock
extends class_2383 {
    public static final class_2754<CurtainVerticalPart> VERTICAL = CFBlockStateProperties.CURTAIN_VERTICAL;
    public static final class_2754<CurtainHorizontalPart> HORIZONTAL = CFBlockStateProperties.CURTAIN_HORIZONTAL;
    public static final class_2746 OPEN = CFBlockStateProperties.OPEN;
    public static final class_2754<class_2750> HINGE = class_2741.field_12520;
    protected static final class_265 SHAPE_TOP_NORTH = class_259.method_1084((class_265)class_2248.method_9541((double)0.0, (double)14.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), (class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)14.0, (double)15.5));
    protected static final class_265 SHAPE_TOP_EAST = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, class_2350.field_11034);
    protected static final class_265 SHAPE_TOP_SOUTH = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, class_2350.field_11035);
    protected static final class_265 SHAPE_TOP_WEST = ShapeUtil.rotateShape(SHAPE_TOP_NORTH, class_2350.field_11039);
    protected static final class_265[] SHAPES_TOP = new class_265[]{SHAPE_TOP_SOUTH, SHAPE_TOP_WEST, SHAPE_TOP_NORTH, SHAPE_TOP_EAST};
    protected static final class_265 SHAPE_BOTTOM_NORTH = class_2248.method_9541((double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)16.0, (double)15.5);
    protected static final class_265 SHAPE_BOTTOM_EAST = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, class_2350.field_11034);
    protected static final class_265 SHAPE_BOTTOM_SOUTH = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, class_2350.field_11035);
    protected static final class_265 SHAPE_BOTTOM_WEST = ShapeUtil.rotateShape(SHAPE_BOTTOM_NORTH, class_2350.field_11039);
    protected static final class_265[] SHAPES_BOTTOM = new class_265[]{SHAPE_BOTTOM_SOUTH, SHAPE_BOTTOM_WEST, SHAPE_BOTTOM_NORTH, SHAPE_BOTTOM_EAST};

    public CurtainBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657(VERTICAL, (Comparable)((Object)CurtainVerticalPart.BOTTOM))).method_11657(HORIZONTAL, (Comparable)((Object)CurtainHorizontalPart.MIDDLE))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)class_2750.field_12588));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        int facingIndex = facing.method_10161();
        if (state.method_11654(VERTICAL) == CurtainVerticalPart.TOP) {
            return SHAPES_TOP[facingIndex];
        }
        return SHAPES_BOTTOM[facingIndex];
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        CurtainVerticalPart vertical;
        class_2338 otherPos;
        class_2680 otherState;
        if (!level.field_9236 && (otherState = level.method_8320(otherPos = (vertical = (CurtainVerticalPart)((Object)state.method_11654(VERTICAL))) == CurtainVerticalPart.TOP ? pos.method_10074() : pos.method_10084())).method_26204() == this && otherState.method_11654(VERTICAL) != vertical && otherState.method_11654((class_2769)field_11177) == state.method_11654((class_2769)field_11177)) {
            level.method_22352(otherPos, !player.method_7337());
        }
        return super.method_9576(level, pos, state, player);
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return (Boolean)state.method_11654((class_2769)OPEN) != false ? class_259.method_1073() : this.method_9530(state, world, pos, context);
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return null;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, VERTICAL, HORIZONTAL, OPEN, HINGE});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 topPos = ctx.method_8037();
        class_2338 bottomPos = topPos.method_10074();
        class_1937 level = ctx.method_8045();
        if (!level.method_8320(bottomPos).method_26166(ctx)) {
            return null;
        }
        class_2350 facing = ctx.method_8042().method_10153();
        class_243 clickVec = ctx.method_17698().method_1020(class_243.method_24954((class_2382)topPos));
        class_2350 right = facing.method_10170();
        double side = right.method_10166().method_10172(clickVec.field_1352, 0.0, clickVec.field_1350);
        class_2750 hinge = side > 0.5 ? class_2750.field_12586 : class_2750.field_12588;
        class_2680 topState = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing)).method_11657(VERTICAL, (Comparable)((Object)CurtainVerticalPart.TOP))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)hinge);
        CurtainHorizontalPart horizontal = this.getCurtainHorizontalType(topState, (class_1936)level, topPos);
        class_2680 bottomState = (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)facing)).method_11657(VERTICAL, (Comparable)((Object)CurtainVerticalPart.BOTTOM))).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HINGE, (Comparable)hinge)).method_11657(HORIZONTAL, (Comparable)((Object)horizontal));
        level.method_8652(bottomPos, bottomState, 3);
        return (class_2680)topState.method_11657(HORIZONTAL, (Comparable)((Object)horizontal));
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        CurtainVerticalPart vertical = (CurtainVerticalPart)((Object)state.method_11654(VERTICAL));
        level.method_8652(pos, (class_2680)state.method_11657(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(state, (class_1936)level, pos))), 3);
        class_2338 leftPos = pos.method_10093(facing.method_10160());
        class_2338 rightPos = pos.method_10093(facing.method_10170());
        for (class_2338 sidePos : List.of(leftPos, rightPos)) {
            class_2680 sideState = level.method_8320(sidePos);
            if (sideState.method_26204() != this || sideState.method_11654(VERTICAL) != vertical || sideState.method_11654((class_2769)field_11177) != facing) continue;
            level.method_8652(sidePos, (class_2680)sideState.method_11657(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(sideState, (class_1936)level, sidePos))), 3);
        }
    }

    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 neighbor, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        if (dir.method_10166().method_10179()) {
            return (class_2680)state.method_11657(HORIZONTAL, (Comparable)((Object)this.getCurtainHorizontalType(state, level, pos)));
        }
        return state;
    }

    private CurtainHorizontalPart getCurtainHorizontalType(class_2680 state, class_1936 level, class_2338 pos) {
        class_2350 facing = (class_2350)state.method_11654((class_2769)field_11177);
        class_2350 left = facing.method_10160();
        class_2350 right = facing.method_10170();
        boolean hasLeft = this.isSameCurtain(level.method_8320(pos.method_10093(left)), state);
        boolean hasRight = this.isSameCurtain(level.method_8320(pos.method_10093(right)), state);
        if (hasLeft && hasRight) {
            return CurtainHorizontalPart.MIDDLE;
        }
        if (hasLeft) {
            return CurtainHorizontalPart.RIGHT;
        }
        if (hasRight) {
            return CurtainHorizontalPart.LEFT;
        }
        return CurtainHorizontalPart.SINGLE;
    }

    private boolean isSameCurtain(class_2680 neighbor, class_2680 base) {
        return neighbor.method_26204() == base.method_26204() && neighbor.method_11654((class_2769)field_11177) == base.method_11654((class_2769)field_11177) && neighbor.method_11654(VERTICAL) == base.method_11654(VERTICAL);
    }

    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 blockHitResult) {
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        if (state.method_11654(VERTICAL) == CurtainVerticalPart.BOTTOM) {
            this.toggleCurtain(level, pos.method_10084(), (class_2350)state.method_11654((class_2769)field_11177));
        } else {
            this.toggleCurtain(level, pos, (class_2350)state.method_11654((class_2769)field_11177));
        }
        return class_1269.field_21466;
    }

    protected List<class_1799> method_9560(class_2680 blockState, class_8567.class_8568 builder) {
        if (blockState.method_11654(VERTICAL) == CurtainVerticalPart.TOP) {
            return Collections.emptyList();
        }
        return super.method_9560(blockState, builder);
    }

    private void toggleCurtain(class_1937 level, class_2338 origin, class_2350 facing) {
        boolean targetOpen;
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(origin);
        class_2680 originState = level.method_8320(origin);
        boolean bl = targetOpen = (Boolean)originState.method_11654((class_2769)OPEN) == false;
        while (!queue.isEmpty()) {
            class_2350 verticalDir;
            class_2338 verticalPos;
            class_2680 verticalState;
            class_2680 state;
            class_2338 pos = (class_2338)queue.poll();
            if (!visited.add(pos) || !((state = level.method_8320(pos)).method_26204() instanceof CurtainBlock) || state.method_11654((class_2769)field_11177) != facing) continue;
            if ((Boolean)state.method_11654((class_2769)OPEN) != targetOpen) {
                level.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(targetOpen)), 3);
            }
            if ((verticalState = level.method_8320(verticalPos = pos.method_10093(verticalDir = state.method_11654(VERTICAL) == CurtainVerticalPart.TOP ? class_2350.field_11033 : class_2350.field_11036))).method_26204() == this && verticalState.method_11654((class_2769)field_11177) == facing) {
                queue.add(verticalPos);
            }
            for (class_2350 side : List.of(facing.method_10170(), facing.method_10160())) {
                class_2338 sidePos = pos.method_10093(side);
                class_2680 sideState = level.method_8320(sidePos);
                if (sideState.method_26204() != this || sideState.method_11654((class_2769)field_11177) != facing || sideState.method_11654(VERTICAL) != state.method_11654(VERTICAL)) continue;
                queue.add(sidePos);
            }
        }
    }
}

