/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.reloaders;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.mixins.tags.TagEntryMixin;
import com.necro.raid.dens.common.reloaders.AbstractReloadImpl;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3497;
import net.minecraft.class_7475;
import org.jetbrains.annotations.NotNull;

public class RaidTagReloadImpl
extends AbstractReloadImpl {
    private final Map<class_2960, class_7475> files = new HashMap<class_2960, class_7475>();

    public RaidTagReloadImpl() {
        super("tags/raid/boss", AbstractReloadImpl.DataType.JSON);
    }

    @Override
    public void load(@NotNull class_3300 manager) {
        manager.method_14488(this.path, path -> path.toString().endsWith(this.suffix())).forEach((id, resource) -> {
            List resources = manager.method_14489(id);
            for (class_3298 res : resources) {
                try {
                    InputStream input = res.method_14482();
                    try {
                        class_2960 key = class_2960.method_60655((String)id.method_12836(), (String)id.method_12832().replace(this.idRemove, "").replace(this.suffix(), ""));
                        this.loadJson(input, key);
                    }
                    finally {
                        if (input == null) continue;
                        input.close();
                    }
                }
                catch (Exception e) {
                    this.onError((class_2960)id, e);
                }
            }
        });
        this.postLoad();
    }

    @Override
    protected void preLoad() {
    }

    @Override
    protected void onLoad(class_2960 key, JsonObject object) {
        Optional<class_7475> tagOpt = class_7475.field_39269.decode((DynamicOps)JsonOps.INSTANCE, (Object)object).result().map(Pair::getFirst);
        tagOpt.ifPresent(tag -> {
            class_7475 existing = this.files.get(key);
            if (existing == null || tag.comp_812()) {
                this.files.put(key, (class_7475)tag);
            } else {
                this.files.put(key, this.mergeTags(existing, (class_7475)tag));
            }
        });
    }

    @Override
    protected void onError(class_2960 id, Exception e) {
        CobblemonRaidDens.LOGGER.error("Failed to load boss tag {}", (Object)id, (Object)e);
    }

    @Override
    protected void postLoad() {
        RaidRegistry.setTags(this.resolve(this.files));
    }

    private class_7475 mergeTags(class_7475 base, class_7475 additional) {
        ArrayList combined = new ArrayList(base.comp_811());
        combined.addAll(additional.comp_811());
        return new class_7475(combined, false);
    }

    private Map<class_2960, Set<class_2960>> resolve(Map<class_2960, class_7475> files) {
        HashMap<class_2960, Set<class_2960>> resolved = new HashMap<class_2960, Set<class_2960>>();
        for (Map.Entry<class_2960, class_7475> entry : files.entrySet()) {
            this.resolveTag(entry.getKey(), files, resolved, new HashSet<class_2960>());
        }
        return resolved;
    }

    private Set<class_2960> resolveTag(class_2960 id, Map<class_2960, class_7475> all, Map<class_2960, Set<class_2960>> cache, Set<class_2960> visited) {
        if (cache.containsKey(id)) {
            return cache.get(id);
        }
        if (!visited.add(id)) {
            throw new IllegalStateException("Circular tag reference in " + String.valueOf(id));
        }
        class_7475 file = all.get(id);
        if (file == null) {
            return Set.of();
        }
        HashSet<class_2960> elements = new HashSet<class_2960>();
        for (class_3497 tag : file.comp_811()) {
            if (((TagEntryMixin)tag).isTag()) {
                elements.addAll(this.resolveTag(((TagEntryMixin)tag).getId(), all, cache, visited));
                continue;
            }
            elements.add(((TagEntryMixin)tag).getId());
        }
        cache.put(id, elements);
        return elements;
    }
}

