/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.cobbledollars.RaidDensCobbleDollarsCompat;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RewardPokemonEvent;
import com.necro.raid.dens.common.items.ModItems;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidHelper;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_9331;

public class RewardHandler {
    private final RaidBoss raidBoss;
    private final class_3222 player;
    private final boolean isCatchable;
    private final Pokemon cachedReward;

    public RewardHandler(RaidBoss raidBoss, class_3222 player, boolean isCatchable, Pokemon cachedReward) {
        this.raidBoss = raidBoss;
        this.player = player;
        this.isCatchable = isCatchable;
        this.cachedReward = cachedReward;
    }

    public RewardHandler(RaidBoss raidBoss, class_3222 player, boolean isCatchable) {
        this(raidBoss, player, isCatchable, null);
    }

    public void sendRewardMessage() {
        if (this.raidBoss.getDisplaySpecies() == null) {
            this.raidBoss.createDisplayAspects();
        }
        String speciesName = ((class_2588)this.raidBoss.getDisplaySpecies().getTranslatedName().method_10851()).method_11022();
        RaidDenNetworkMessages.REWARD_PACKET.accept((Object)this.player, (Object)this.isCatchable, (Object)speciesName);
        RaidHelper.REWARD_QUEUE.put(this.player.method_5667(), this);
    }

    public boolean givePokemonToPlayer() {
        class_1792 class_17922 = this.player.method_6047().method_7909();
        if (!(class_17922 instanceof PokeBallItem)) {
            this.player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.reward.reward_not_pokeball"));
            return false;
        }
        PokeBallItem pokeBallItem = (PokeBallItem)class_17922;
        Pokemon pokemon = this.cachedReward == null ? this.raidBoss.getRewardPokemon(this.player) : this.cachedReward;
        pokemon.setCaughtBall(pokeBallItem.getPokeBall());
        if (!RaidEvents.REWARD_POKEMON.postWithResult(new RewardPokemonEvent(this.player, pokemon))) {
            return false;
        }
        if (!this.giveItemToPlayer()) {
            return false;
        }
        PlayerExtensionsKt.party((class_3222)this.player).add(pokemon);
        this.player.method_6047().method_57008(1, (class_1309)this.player);
        RaidDenCriteriaTriggers.triggerRaidShiny(this.player, pokemon);
        return true;
    }

    public boolean giveItemToPlayer() {
        class_1799 raidPouch = this.buildRaidPouch();
        List<class_1799> rewards = this.raidBoss.getRandomRewards(this.player.method_51469());
        rewards.addFirst(raidPouch);
        for (class_1799 item : rewards) {
            class_1542 itemEntity;
            if (this.player.method_31548().method_7394(item) || (itemEntity = this.player.method_7328(item, false)) == null) continue;
            itemEntity.method_6975();
            itemEntity.method_48349(this.player.method_5667());
        }
        return true;
    }

    public void giveCurrency() {
        if (!ModCompat.COBBLEDOLLARS.isLoaded()) {
            return;
        }
        if (this.raidBoss.getCurrency() <= 0) {
            return;
        }
        RaidDensCobbleDollarsCompat.addCurrency(this.player, this.raidBoss.getCurrency());
    }

    private class_1799 buildRaidPouch() {
        class_1799 item = ((class_1792)ModItems.RAID_POUCH.comp_349()).method_7854();
        item.method_57379((class_9331)ModComponents.TIER_COMPONENT.comp_349(), (Object)this.raidBoss.getTier());
        item.method_57379((class_9331)ModComponents.FEATURE_COMPONENT.comp_349(), (Object)this.raidBoss.getFeature());
        item.method_57379((class_9331)ModComponents.TYPE_COMPONENT.comp_349(), (Object)this.raidBoss.getType());
        return item;
    }
}

