/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.raids.RewardHandler;
import com.necro.raid.dens.common.util.IRaidBattle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RaidHelper
extends class_18 {
    public static RaidHelper INSTANCE;
    public static final Map<class_1657, JoinRequestInstance> JOIN_QUEUE;
    public static final Map<UUID, RaidInstance> ACTIVE_RAIDS;
    public static final Map<UUID, RequestHandler> REQUEST_QUEUE;
    public static final Map<UUID, RewardHandler> REWARD_QUEUE;
    public final Set<UUID> RAID_HOSTS = new HashSet<UUID>();
    public final Set<UUID> RAID_PARTICIPANTS = new HashSet<UUID>();
    public final Map<UUID, Set<UUID>> CLEARED_RAIDS = new HashMap<UUID, Set<UUID>>();

    public static boolean isInQueue(class_1657 player) {
        return JOIN_QUEUE.containsKey(player);
    }

    public static void addToQueue(class_1657 player, @Nullable class_1799 key) {
        JOIN_QUEUE.put(player, new JoinRequestInstance(player, key));
    }

    public static void initRequest(class_3222 host, RaidCrystalBlockEntity blockEntity) {
        if (REQUEST_QUEUE.containsKey(host.method_5667())) {
            return;
        }
        REQUEST_QUEUE.put(host.method_5667(), new RequestHandler(blockEntity));
    }

    public static void addRequest(class_3222 host, class_1657 player) {
        UUID uuid = host.method_5667();
        if (!REQUEST_QUEUE.containsKey(uuid)) {
            return;
        }
        REQUEST_QUEUE.get(uuid).addPlayer(player);
    }

    public static RequestHandler getRequest(class_3222 host) {
        if (!REQUEST_QUEUE.containsKey(host.method_5667())) {
            return null;
        }
        return REQUEST_QUEUE.get(host.method_5667());
    }

    public static void removeRequests(UUID host) {
        REQUEST_QUEUE.remove(host);
    }

    public static void addHost(class_1657 player) {
        RaidHelper.INSTANCE.RAID_HOSTS.add(player.method_5667());
        INSTANCE.method_80();
    }

    public static void addParticipant(class_1657 player) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.add(player.method_5667());
        INSTANCE.method_80();
    }

    public static boolean hasClearedRaid(UUID uuid, class_1657 player) {
        Set cleared = RaidHelper.INSTANCE.CLEARED_RAIDS.getOrDefault(uuid, new HashSet());
        return cleared.contains(player.method_5667());
    }

    public static void clearRaid(UUID uuid, Collection<UUID> players) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(uuid)) {
            RaidHelper.INSTANCE.CLEARED_RAIDS.put(uuid, new HashSet());
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.get(uuid).addAll(players);
        INSTANCE.method_80();
    }

    public static void resetClearedRaids(UUID uuid) {
        if (INSTANCE == null) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.remove(uuid);
        INSTANCE.method_80();
    }

    public static void resetPlayerClearedRaid(UUID uuid, UUID player) {
        if (!RaidHelper.INSTANCE.CLEARED_RAIDS.containsKey(uuid)) {
            return;
        }
        RaidHelper.INSTANCE.CLEARED_RAIDS.get(uuid).remove(player);
        INSTANCE.method_80();
    }

    public static void resetPlayerAllClearedRaids(UUID player) {
        RaidHelper.INSTANCE.CLEARED_RAIDS.values().forEach(playerSet -> playerSet.remove(player));
        INSTANCE.method_80();
    }

    public static boolean isAlreadyHosting(class_1657 player) {
        return RaidHelper.isAlreadyHosting(player.method_5667());
    }

    public static boolean isAlreadyHosting(UUID player) {
        return RaidHelper.INSTANCE.RAID_HOSTS.contains(player);
    }

    public static boolean isAlreadyParticipating(class_1657 player) {
        return RaidHelper.isAlreadyParticipating(player.method_5667());
    }

    public static boolean isAlreadyParticipating(UUID player) {
        return RaidHelper.INSTANCE.RAID_PARTICIPANTS.contains(player);
    }

    public static void removeHost(UUID player) {
        RaidHelper.INSTANCE.RAID_HOSTS.remove(player);
        INSTANCE.method_80();
    }

    public static void removeParticipant(UUID player) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.remove(player);
        INSTANCE.method_80();
    }

    public static void finishRaid(Set<UUID> players) {
        RaidHelper.INSTANCE.RAID_PARTICIPANTS.removeAll(players);
        INSTANCE.method_80();
    }

    public static void onPlayerDisconnect(class_1657 player) {
        RaidHelper.refundItem(player);
        RaidHelper.fleeRaidBattle(player);
    }

    private static void refundItem(class_1657 player) {
        if (!JOIN_QUEUE.containsKey(player)) {
            return;
        }
        JOIN_QUEUE.get(player).refundItem();
        JOIN_QUEUE.remove(player);
    }

    private static void fleeRaidBattle(class_1657 player) {
        Pair pair = PlayerExtensionsKt.getBattleState((class_3222)((class_3222)player));
        if (pair == null || pair.getFirst() == null) {
            return;
        }
        PokemonBattle battle = (PokemonBattle)pair.getFirst();
        RaidInstance raid = ((IRaidBattle)battle).getRaidBattle();
        if (raid == null) {
            return;
        }
        raid.removePlayer((class_3222)player, battle);
    }

    public static void onServerClose() {
        JOIN_QUEUE.forEach((player, instance) -> instance.refundItem());
        JOIN_QUEUE.clear();
    }

    public static void serverTick() {
        JOIN_QUEUE.values().removeIf(instance -> !instance.tick());
    }

    public static void commonTick() {
        ArrayList<RaidInstance> raids = new ArrayList<RaidInstance>(ACTIVE_RAIDS.values());
        raids.forEach(RaidInstance::tick);
    }

    public static class_2561 getSystemMessage(String translatable) {
        return RaidHelper.getSystemMessage(class_2561.method_43471((String)translatable));
    }

    public static class_2561 getSystemMessage(class_5250 component) {
        return component.method_27692(class_124.field_1080).method_27692(class_124.field_1056);
    }

    public static RaidHelper create() {
        return new RaidHelper();
    }

    public static RaidHelper load(class_2487 compoundTag, class_7225.class_7874 provider) {
        RaidHelper data = RaidHelper.create();
        if (compoundTag.method_10545("raid_hosts")) {
            compoundTag.method_10554("raid_hosts", 8).forEach(host -> data.RAID_HOSTS.add(UUID.fromString(host.method_10714())));
        }
        if (compoundTag.method_10545("raid_participants")) {
            compoundTag.method_10554("raid_participants", 8).forEach(p -> data.RAID_PARTICIPANTS.add(UUID.fromString(p.method_10714())));
        }
        class_2499 clearedRaids = compoundTag.method_10554("cleared_raids", 10);
        for (class_2520 t : clearedRaids) {
            class_2487 entry = (class_2487)t;
            String uuid = entry.method_10558("uuid");
            if (uuid.isEmpty()) continue;
            HashSet<UUID> players = new HashSet<UUID>();
            class_2499 uuidList = entry.method_10554("players", 11);
            for (class_2520 uuidTag : uuidList) {
                players.add(class_2512.method_25930((class_2520)uuidTag));
            }
            data.CLEARED_RAIDS.put(UUID.fromString(uuid), players);
        }
        return data;
    }

    public static void initHelper(MinecraftServer server) {
        INSTANCE = (RaidHelper)server.method_30002().method_17983().method_17924(RaidHelper.type(), "cobblemonraiddens");
        INSTANCE.method_80();
    }

    @NotNull
    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2499 raidHostsTag = new class_2499();
        this.RAID_HOSTS.forEach(uuid -> raidHostsTag.add((Object)class_2519.method_23256((String)uuid.toString())));
        compoundTag.method_10566("raid_hosts", (class_2520)raidHostsTag);
        class_2499 raidParticipantsTag = new class_2499();
        this.RAID_PARTICIPANTS.forEach(uuid -> raidParticipantsTag.add((Object)class_2519.method_23256((String)uuid.toString())));
        compoundTag.method_10566("raid_participants", (class_2520)raidParticipantsTag);
        class_2499 clearedRaidsTag = new class_2499();
        for (Map.Entry<UUID, Set<UUID>> entry : this.CLEARED_RAIDS.entrySet()) {
            class_2487 e = new class_2487();
            e.method_10582("uuid", entry.getKey().toString());
            class_2499 uuidList = new class_2499();
            for (UUID uuid2 : entry.getValue()) {
                uuidList.add((Object)class_2512.method_25929((UUID)uuid2));
            }
            e.method_10566("players", (class_2520)uuidList);
            clearedRaidsTag.add((Object)e);
        }
        compoundTag.method_10566("cleared_raids", (class_2520)clearedRaidsTag);
        return compoundTag;
    }

    public static class_18.class_8645<RaidHelper> type() {
        return new class_18.class_8645(RaidHelper::create, RaidHelper::load, null);
    }

    static {
        JOIN_QUEUE = new HashMap<class_1657, JoinRequestInstance>();
        ACTIVE_RAIDS = new HashMap<UUID, RaidInstance>();
        REQUEST_QUEUE = new HashMap<UUID, RequestHandler>();
        REWARD_QUEUE = new HashMap<UUID, RewardHandler>();
    }

    public static class JoinRequestInstance {
        private final class_1657 player;
        private final class_1799 itemStack;
        private int tick;

        public JoinRequestInstance(class_1657 player, @Nullable class_1799 itemStack) {
            this.player = player;
            if (itemStack == null) {
                this.itemStack = null;
            } else {
                this.itemStack = itemStack.method_7972();
                this.itemStack.method_7939(1);
            }
            this.tick = 0;
        }

        public void refundItem() {
            if (this.itemStack != null) {
                this.player.method_7270(this.itemStack);
            }
        }

        public boolean tick() {
            if (++this.tick > 1200) {
                this.player.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"));
                return false;
            }
            return true;
        }
    }
}

