/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.pokemon.Gender;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.config.TierConfig;
import com.necro.raid.dens.common.data.UniqueKeyAdapter;
import com.necro.raid.dens.common.raids.RaidAI;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidFeature;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;

public class RaidBossAdditions {
    private static Set<class_2960> BLACKLIST;
    private static boolean CACHED;
    private final List<String> include;
    private final List<String> exclude;
    private final RaidBoss additions;
    private final boolean replace;
    private final String suffix;

    public RaidBossAdditions(List<String> include, List<String> exclude, RaidBoss additions, boolean replace, String suffix) {
        this.include = include;
        this.exclude = exclude;
        this.additions = additions;
        this.replace = replace;
        if (!replace && !((String)suffix).startsWith("_")) {
            suffix = "_" + (String)suffix;
        }
        this.suffix = suffix;
    }

    public void apply(List<class_2960> registry) {
        if (!this.replace() && this.suffix().equals("_")) {
            return;
        }
        List<Object> targets = new ArrayList();
        if (this.include().isEmpty()) {
            targets = registry;
        } else {
            for (String target : this.include()) {
                class_2960 class_29602 = class_2960.method_60654((String)(target.startsWith("#") ? target.substring(1) : target));
                if (target.startsWith("#")) {
                    targets.addAll(RaidRegistry.getTagEntries(class_29602));
                    continue;
                }
                if (RaidRegistry.getRaidBoss(class_29602) == null) continue;
                targets.add(class_29602);
            }
        }
        HashSet<class_2960> excluded = new HashSet<class_2960>();
        for (String string : this.exclude()) {
            class_2960 id = class_2960.method_60654((String)(string.startsWith("#") ? string.substring(1) : string));
            if (string.startsWith("#")) {
                excluded.addAll(RaidRegistry.getTagEntries(id));
                continue;
            }
            if (RaidRegistry.getRaidBoss(id) == null) continue;
            excluded.add(id);
        }
        if (!CACHED) {
            BLACKLIST = RaidRegistry.getTagEntries(class_2960.method_60655((String)"cobblemonraiddens", (String)"additions_blacklist"));
            CACHED = true;
        }
        for (class_2960 class_29603 : targets) {
            RaidBoss temp;
            if (excluded.contains(class_29603) || (temp = RaidRegistry.getRaidBoss(class_29603)) == null) continue;
            class_2960 id = temp.getId();
            if (!this.replace() && BLACKLIST.contains(id)) continue;
            RaidBoss boss = this.replace() ? temp : temp.copy();
            PokemonProperties properties = this.additions().getProperties();
            if (properties != null) {
                if (properties.getSpecies() != null) {
                    boss.getProperties().setSpecies(properties.getSpecies());
                }
                if (properties.getGender() != null) {
                    boss.getProperties().setGender(properties.getGender());
                }
                if (properties.getAbility() != null) {
                    boss.getProperties().setAbility(properties.getAbility());
                }
                if (properties.getNature() != null) {
                    boss.getProperties().setNature(properties.getNature());
                }
                if (properties.getLevel() != null) {
                    boss.getProperties().setLevel(properties.getLevel());
                }
                if (properties.getMoves() != null) {
                    boss.getProperties().setMoves(properties.getMoves());
                }
                if (properties.getTeraType() != null) {
                    boss.getProperties().setTeraType(properties.getTeraType());
                }
            }
            RaidBossAdditions.getTier(this.additions()).ifPresent(boss::setTier);
            RaidBossAdditions.getFeature(this.additions()).ifPresent(boss::setFeature);
            boss.setForm(RaidBossAdditions.getRaidForm(this.additions()).orElse(null), RaidBossAdditions.getBaseForm(this.additions()).orElse(null));
            RaidBossAdditions.getType(this.additions()).ifPresent(boss::setType);
            RaidBossAdditions.getLootTable(this.additions()).ifPresent(boss::setLootTable);
            RaidBossAdditions.getWeight(this.additions()).ifPresent(weight -> boss.setWeight(boss.getWeight() * weight));
            RaidBossAdditions.getMaxCatches(this.additions()).ifPresent(boss::setMaxCatches);
            RaidBossAdditions.getHealthMulti(this.additions()).ifPresent(boss::setHealthMulti);
            RaidBossAdditions.getShinyRate(this.additions()).ifPresent(boss::setShinyRate);
            RaidBossAdditions.getScript(this.additions()).ifPresent(boss::setScript);
            RaidBossAdditions.getDens(this.additions()).ifPresent(boss::setDens);
            RaidBossAdditions.getKey(this.additions()).ifPresent(boss::setKey);
            RaidBossAdditions.getCurrency(this.additions()).ifPresent(boss::setCurrency);
            RaidBossAdditions.getRaidAI(this.additions()).ifPresent(boss::setRaidAI);
            if (this.replace()) continue;
            boss.setId(class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + this.suffix())));
            RaidRegistry.register(boss);
        }
    }

    private List<String> include() {
        return this.include;
    }

    private List<String> exclude() {
        return this.exclude;
    }

    private RaidBoss additions() {
        return this.additions;
    }

    private boolean replace() {
        return this.replace;
    }

    private String suffix() {
        return this.suffix;
    }

    private static Optional<PokemonProperties> getProperties(RaidBoss boss) {
        return Optional.ofNullable(boss.getProperties());
    }

    private static Optional<RaidTier> getTier(RaidBoss boss) {
        return Optional.ofNullable(boss.getTier());
    }

    private static Optional<RaidFeature> getFeature(RaidBoss boss) {
        return Optional.ofNullable(boss.getFeature());
    }

    private static Optional<List<SpeciesFeature>> getRaidForm(RaidBoss boss) {
        return Optional.ofNullable(boss.getRaidForm());
    }

    private static Optional<List<SpeciesFeature>> getBaseForm(RaidBoss boss) {
        return Optional.ofNullable(boss.getBaseForm());
    }

    private static Optional<RaidType> getType(RaidBoss boss) {
        return Optional.ofNullable(boss.getType());
    }

    private static Optional<String> getLootTable(RaidBoss boss) {
        return Optional.ofNullable(boss.getLootTableId());
    }

    private static Optional<Double> getWeight(RaidBoss boss) {
        return Optional.ofNullable(boss.getWeight());
    }

    private static Optional<Integer> getMaxCatches(RaidBoss boss) {
        return Optional.ofNullable(boss.getMaxCatches());
    }

    private static Optional<Integer> getHealthMulti(RaidBoss boss) {
        return Optional.ofNullable(boss.getHealthMulti());
    }

    private static Optional<Float> getShinyRate(RaidBoss boss) {
        return Optional.ofNullable(boss.getShinyRate());
    }

    private static Optional<Map<String, String>> getScript(RaidBoss boss) {
        return Optional.ofNullable(boss.getScript());
    }

    private static Optional<List<String>> getDens(RaidBoss boss) {
        return Optional.ofNullable(boss.getDens());
    }

    private static Optional<UniqueKeyAdapter> getKey(RaidBoss boss) {
        return Optional.ofNullable(boss.getKey());
    }

    private static Optional<Integer> getCurrency(RaidBoss boss) {
        return Optional.ofNullable(boss.getCurrency());
    }

    private static Optional<RaidAI> getRaidAI(RaidBoss boss) {
        return Optional.ofNullable(boss.getRaidAI());
    }

    private static Optional<String> species(PokemonProperties properties) {
        return Optional.ofNullable(properties.getSpecies());
    }

    private static Optional<String> gender(PokemonProperties properties) {
        Gender gender = properties.getGender();
        if (gender == null) {
            return Optional.empty();
        }
        return Optional.of(gender.method_15434());
    }

    private static Optional<String> ability(PokemonProperties properties) {
        return Optional.ofNullable(properties.getAbility());
    }

    private static Optional<String> nature(PokemonProperties properties) {
        return Optional.ofNullable(properties.getNature());
    }

    private static Optional<Integer> level(PokemonProperties properties) {
        return Optional.ofNullable(properties.getLevel());
    }

    private static Optional<List<String>> moves(PokemonProperties properties) {
        return Optional.ofNullable(properties.getMoves());
    }

    private static Codec<PokemonProperties> propertiesCodec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.optionalFieldOf("species").forGetter(RaidBossAdditions::species), (App)Codec.STRING.optionalFieldOf("gender").forGetter(RaidBossAdditions::gender), (App)Codec.STRING.optionalFieldOf("ability").forGetter(RaidBossAdditions::ability), (App)Codec.STRING.optionalFieldOf("nature").forGetter(RaidBossAdditions::nature), (App)Codec.INT.optionalFieldOf("level").forGetter(RaidBossAdditions::level), (App)Codec.STRING.listOf().optionalFieldOf("moves").forGetter(RaidBossAdditions::moves)).apply((Applicative)inst, (species, gender, ability, nature, level, moves) -> {
            PokemonProperties properties = new PokemonProperties();
            species.ifPresent(arg_0 -> ((PokemonProperties)properties).setSpecies(arg_0));
            try {
                gender.ifPresent(s -> properties.setGender(Gender.valueOf((String)s)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            ability.ifPresent(arg_0 -> ((PokemonProperties)properties).setAbility(arg_0));
            nature.ifPresent(arg_0 -> ((PokemonProperties)properties).setNature(arg_0));
            level.ifPresent(arg_0 -> ((PokemonProperties)properties).setLevel(arg_0));
            moves.ifPresent(arg_0 -> ((PokemonProperties)properties).setMoves(arg_0));
            return properties;
        }));
    }

    private static Codec<RaidBoss> bossCodec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)RaidBossAdditions.propertiesCodec().optionalFieldOf("pokemon").forGetter(RaidBossAdditions::getProperties), (App)RaidTier.codec().optionalFieldOf("raid_tier").forGetter(RaidBossAdditions::getTier), (App)RaidType.codec().optionalFieldOf("raid_type").forGetter(RaidBossAdditions::getType), (App)RaidFeature.codec().optionalFieldOf("raid_feature").forGetter(RaidBossAdditions::getFeature), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("raid_form").forGetter(RaidBossAdditions::getRaidForm), (App)RaidBoss.raidFormCodec().listOf().optionalFieldOf("base_form").forGetter(RaidBossAdditions::getBaseForm), (App)Codec.STRING.optionalFieldOf("loot_table").forGetter(RaidBossAdditions::getLootTable), (App)Codec.DOUBLE.optionalFieldOf("weight").forGetter(RaidBossAdditions::getWeight), (App)Codec.INT.optionalFieldOf("health_multi").forGetter(RaidBossAdditions::getHealthMulti), (App)Codec.FLOAT.optionalFieldOf("shiny_rate").forGetter(RaidBossAdditions::getShinyRate), (App)Codec.INT.optionalFieldOf("currency").forGetter(RaidBossAdditions::getCurrency), (App)Codec.INT.optionalFieldOf("max_catches").forGetter(RaidBossAdditions::getMaxCatches), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("script").forGetter(RaidBossAdditions::getScript), (App)Codec.STRING.listOf().optionalFieldOf("den").forGetter(RaidBossAdditions::getDens), (App)UniqueKeyAdapter.CODEC.optionalFieldOf("key").forGetter(RaidBossAdditions::getKey), (App)RaidAI.codec().optionalFieldOf("raid_ai").forGetter(RaidBossAdditions::getRaidAI)).apply((Applicative)inst, (properties, tier, type, feature, raidForm, baseForm, bonusItems, weight, healthMulti, shinyRate, currency, maxCatches, script, dens, key, raidAI) -> {
            Integer hm = healthMulti.orElse(null);
            Float sr = shinyRate.orElse(null);
            Integer c = currency.orElse(null);
            Integer mc = maxCatches.orElse(null);
            Map<String, String> s = script.orElse(null);
            RaidTier t = tier.orElse(null);
            if (t != null) {
                TierConfig tierConfig = CobblemonRaidDens.TIER_CONFIG.get((Object)t);
                if (hm == null) {
                    hm = tierConfig.healthMultiplier();
                }
                if (sr == null) {
                    sr = Float.valueOf(tierConfig.shinyRate());
                }
                if (c == null) {
                    c = tierConfig.currency();
                }
                if (mc == null) {
                    mc = tierConfig.maxCatches();
                }
                if (s == null) {
                    s = tierConfig.defaultScripts();
                }
            }
            PokemonProperties p = properties.orElse(new PokemonProperties());
            type.ifPresent(t1 -> p.setTeraType(t1.method_15434()));
            if (sr != null) {
                if (sr.floatValue() == 1.0f) {
                    p.setShiny(Boolean.valueOf(true));
                } else if (sr.floatValue() == 0.0f) {
                    p.setShiny(Boolean.valueOf(false));
                }
            }
            RaidFeature f = feature.orElse(null);
            ArrayList<SpeciesFeature> rf = raidForm.orElse(null);
            if ((f == RaidFeature.DYNAMAX || f == RaidFeature.MEGA) && rf == null) {
                rf = new ArrayList<SpeciesFeature>();
            }
            if (f == RaidFeature.DYNAMAX && rf.stream().noneMatch(form -> form.getName().equals("dynamax_form"))) {
                rf.add((SpeciesFeature)new StringSpeciesFeature("dynamax_form", "none"));
            } else if (f == RaidFeature.MEGA && rf.stream().noneMatch(form -> form.getName().equals("mega_evolution"))) {
                rf.add((SpeciesFeature)new StringSpeciesFeature("mega_evolution", "mega"));
            }
            return new RaidBoss(p, t, type.orElse(null), feature.orElse(null), rf, baseForm.orElse(null), bonusItems.orElse(null), weight.orElse(null), mc, hm, sr, s, dens.orElse(null), key.orElse(null), c, raidAI.orElse(null));
        }));
    }

    public static Codec<RaidBossAdditions> codec() {
        return RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.listOf().optionalFieldOf("include", new ArrayList()).forGetter(RaidBossAdditions::include), (App)Codec.STRING.listOf().optionalFieldOf("exclude", new ArrayList()).forGetter(RaidBossAdditions::exclude), (App)RaidBossAdditions.bossCodec().fieldOf("additions").forGetter(RaidBossAdditions::additions), (App)Codec.BOOL.optionalFieldOf("replace", (Object)true).forGetter(RaidBossAdditions::replace), (App)Codec.STRING.optionalFieldOf("suffix", (Object)"").forGetter(RaidBossAdditions::suffix)).apply((Applicative)inst, RaidBossAdditions::new));
    }

    static {
        CACHED = false;
    }
}

