/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.network.packets;

import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.ServerPacket;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.raids.RequestHandler;
import com.necro.raid.dens.common.util.RaidDenRegistry;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public record RequestResponsePacket(boolean accept, String player) implements class_8710,
ServerPacket
{
    public static final class_2960 ID = class_2960.method_60655((String)"cobblemonraiddens", (String)"request_response");
    public static final class_8710.class_9154<RequestResponsePacket> PACKET_TYPE = new class_8710.class_9154(ID);
    public static final class_9139<class_2540, RequestResponsePacket> CODEC = class_9139.method_56438(RequestResponsePacket::write, RequestResponsePacket::read);

    public void write(class_2540 buf) {
        buf.method_52964(this.accept);
        buf.method_10814(this.player);
    }

    public static RequestResponsePacket read(class_2540 buf) {
        return new RequestResponsePacket(buf.readBoolean(), buf.method_19772());
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }

    @Override
    public void handleServer(class_3222 host) {
        RequestHandler handler = RaidHelper.getRequest(host);
        if (handler == null) {
            return;
        }
        class_1657 player = handler.getPlayer(this.player);
        if (player == null) {
            return;
        }
        RaidCrystalBlockEntity blockEntity = handler.getBlockEntity();
        if (this.accept) {
            this.acceptRequest(host, player, blockEntity);
        } else {
            this.denyRequest(host, player);
        }
    }

    private void acceptRequest(class_3222 host, class_1657 player, RaidCrystalBlockEntity blockEntity) {
        if (blockEntity.isFull()) {
            host.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.lobby_is_full"));
            return;
        }
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent((class_3222)player, false, blockEntity.getRaidBoss()));
        if (!success) {
            return;
        }
        if (RaidHelper.JOIN_QUEUE.containsKey(player) && !RaidHelper.isAlreadyParticipating(player)) {
            assert (player.method_5682() != null);
            RaidHelper.JOIN_QUEUE.remove(player);
            RaidHelper.addParticipant(player);
            blockEntity.addPlayer(player);
            class_243 playerPos = RaidDenRegistry.getPlayerPos(blockEntity.getRaidStructure());
            RaidUtils.teleportPlayerToRaid((class_3222)player, blockEntity.getDimension(), playerPos);
            blockEntity.syncAspects((class_3222)player);
        } else {
            RaidHelper.JOIN_QUEUE.remove(player);
            host.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"));
        }
    }

    private void denyRequest(class_3222 host, class_1657 player) {
        if (RaidHelper.JOIN_QUEUE.containsKey(player)) {
            RaidHelper.JOIN_QUEUE.get(player).refundItem();
            RaidHelper.JOIN_QUEUE.remove(player);
            player.method_43496(RaidHelper.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.raid.rejected_request", (Object[])new Object[]{host.method_5477()})));
            host.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.confirm_deny_request"));
        } else {
            host.method_43496(RaidHelper.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"));
        }
    }
}

