/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.showdown;

import com.cobblemon.mod.common.api.abilities.Ability;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.effects.TransformEffect;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidAI;
import com.necro.raid.dens.common.util.IRaidAccessor;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TransformEffect.class})
public abstract class TransformEffectMixin {
    @Unique
    private float raidScale;
    @Unique
    private List<Move> moves;
    @Unique
    private Ability ability;
    @Shadow(remap=false)
    private PokemonProperties mock;

    @Inject(method={"<init>(Lcom/cobblemon/mod/common/pokemon/Pokemon;Z)V"}, at={@At(value="RETURN")}, remap=false)
    private void initInject(Pokemon mimic, boolean canCry, CallbackInfo ci) {
        this.raidScale = class_3532.method_15363((float)(80.0f / mimic.getSpecies().getHeight()), (float)1.0f, (float)5.0f);
        this.moves = mimic.getMoveSet().getMoves();
        this.ability = mimic.getAbility();
    }

    @Inject(method={"apply"}, at={@At(value="HEAD")}, remap=false)
    private void applyInject(PokemonEntity entity, CompletableFuture<PokemonEntity> future, CallbackInfo ci) {
        if (!((IRaidAccessor)entity).isRaidBoss()) {
            return;
        }
        HashSet<String> aspects = new HashSet<String>(this.mock.getAspects());
        aspects.add("raid");
        this.mock.setAspects(aspects);
        for (int i = 0; i < this.moves.size(); ++i) {
            Move move = this.moves.get(i);
            if (RaidAI.BLOCKED_MOVES.contains(move.getName())) {
                MoveTemplate struggle = Moves.getByName((String)"tackle");
                if (struggle != null) {
                    move = struggle.create(99);
                }
            }
            entity.getPokemon().getMoveSet().setMove(i, move);
        }
        entity.getPokemon().getMoveSet().update();
        entity.getPokemon().setAbility$common(this.ability);
        if (this.raidScale > 0.0f) {
            entity.getPokemon().setScaleModifier(this.raidScale);
            RaidDenNetworkMessages.RESIZE.accept((Object)((class_3218)entity.method_37908()), (Object)entity, (Object)Float.valueOf(this.raidScale));
        }
        entity.method_18382();
    }
}

