/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.showdown;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.interpreter.Effect;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.data.ShowdownIdentifiable;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.interpreter.instructions.HealInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IRaidBattle;
import kotlin.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HealInstruction.class})
public abstract class HealInstructionMixin
implements InterpreterInstruction {
    @Final
    @Shadow(remap=false)
    private BattleMessage publicMessage;
    @Final
    @Shadow(remap=false)
    private BattleMessage privateMessage;
    @Final
    @Shadow(remap=false)
    private BattleActor actor;

    @Inject(method={"invoke"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void invokeInject(PokemonBattle battle, CallbackInfo ci) {
        if (!((IRaidBattle)battle).isRaidBattle()) {
            return;
        }
        RaidInstance raidInstance = ((IRaidBattle)battle).getRaidBattle();
        BattlePokemon battlePokemon = this.publicMessage.battlePokemon(0, this.actor.battle);
        if (battlePokemon == null || battlePokemon.getEntity() == null) {
            return;
        }
        if (!((IRaidAccessor)battlePokemon.getEntity()).isRaidBoss()) {
            return;
        }
        String args = this.privateMessage.argumentAt(1);
        assert (args != null);
        float remainingHealth = Float.parseFloat(args.split("/")[0]);
        Effect effect = this.privateMessage.effect("from");
        battle.dispatchWaiting(1.0f, () -> {
            class_3222 player = (class_3222)battle.getPlayers().getFirst();
            raidInstance.syncHealth(player, battle, remainingHealth);
            battlePokemon.getEffectedPokemon().setCurrentHealth((int)raidInstance.getRemainingHealth());
            if (!this.privateMessage.hasOptionalArgument("silent")) {
                class_5250 lang = null;
                if (this.privateMessage.hasOptionalArgument("zeffect")) {
                    lang = LocalizationUtilsKt.battleLang((String)"heal.zeffect", (Object[])new Object[]{battlePokemon.getName()});
                } else if (this.privateMessage.hasOptionalArgument("wisher")) {
                    String name = this.privateMessage.optionalArgument("wisher");
                    assert (name != null);
                    String showdownId = name.toLowerCase().replace(ShowdownIdentifiable.Companion.getREGEX$common().getPattern(), "");
                    BattlePokemon wisher = this.actor.getPokemonList().stream().filter(pokemon -> pokemon.getEffectedPokemon().showdownId().equals(showdownId)).findFirst().orElse(null);
                    lang = LocalizationUtilsKt.battleLang((String)"heal.wish", (Object[])new Object[]{wisher != null ? wisher.getName() : this.actor.nameOwned(name)});
                } else if (this.privateMessage.hasOptionalArgument("from")) {
                    if (effect != null && effect.getId().equals("drain")) {
                        BattlePokemon drained = this.privateMessage.battlePokemonFromOptional(battle, "of");
                        if (drained != null) {
                            lang = LocalizationUtilsKt.battleLang((String)"heal.drain", (Object[])new Object[]{drained.getName()});
                        }
                    } else if (effect != null) {
                        lang = LocalizationUtilsKt.battleLang((String)("heal." + effect.getId()), (Object[])new Object[]{battlePokemon.getName()});
                    }
                } else {
                    lang = LocalizationUtilsKt.battleLang((String)"heal.generic", (Object[])new Object[]{battlePokemon.getName()});
                }
                if (lang != null) {
                    battle.broadcastChatMessage((class_2561)lang);
                }
            }
            return Unit.INSTANCE;
        });
        ci.cancel();
    }
}

