/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.raid;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.util.IHealthSetter;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.RaidRegistry;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends class_1321
implements IRaidAccessor {
    @Unique
    private UUID raidId;
    @Unique
    private class_2960 raidBoss;

    @Shadow(remap=false)
    public abstract void setBattleId(@Nullable UUID var1);

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    protected PokemonEntityMixin(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public UUID getRaidId() {
        return this.raidId;
    }

    @Override
    public void setRaidId(UUID raidId) {
        this.raidId = null;
        this.setBattleId(raidId);
        this.raidId = raidId;
    }

    @Override
    public boolean isRaidBoss() {
        return this.getPokemon().getAspects().contains("raid") || this.getPokemon().getForcedAspects().contains("raid") || this.raidBoss != null;
    }

    @Override
    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    @Override
    public void setRaidBoss(class_2960 raidBoss) {
        this.raidBoss = raidBoss;
    }

    @Inject(method={"canBattle"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canBattleInject(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_37908().method_8608()) {
            cir.setReturnValue((Object)true);
        }
        if (this.getRaidId() == null) {
            return;
        }
        if (this.method_6032() <= 0.0f || this.method_29504() || PlayerExtensionsKt.isPartyBusy((class_1657)player)) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"setBattleId"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void setBattleInject(UUID battleId, CallbackInfo ci) {
        if (this.getRaidId() != null) {
            ci.cancel();
        }
    }

    @Inject(method={"isBattling"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void isBattlingInject(CallbackInfoReturnable<Boolean> cir) {
        if (this.getRaidId() != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="RETURN")})
    private void saveWithoutIdInject(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (this.raidId != null) {
            nbt.method_10582("raid_id", this.raidId.toString());
        }
        if (this.raidBoss != null) {
            nbt.method_10582("raid_boss", this.raidBoss.toString());
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void loadInject(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("raid_id")) {
            this.raidId = UUID.fromString(nbt.method_10558("raid_id"));
        }
        if (nbt.method_10545("raid_boss")) {
            this.raidBoss = class_2960.method_60654((String)nbt.method_10558("raid_boss"));
        }
        if (this.getPokemon() == null) {
            return;
        }
        class_2487 tag = nbt.method_10562("Pokemon");
        if (tag.method_10545("max_health_buffer")) {
            ((IHealthSetter)this.getPokemon()).setMaxHealth(tag.method_10550("max_health_buffer"));
        }
    }
}

