/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.dimensions;

import com.google.common.collect.Maps;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.distanthorizons.RaidDensDistantHorizonsCompat;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.mixins.dimension.MinecraftServerAccessor;
import com.necro.raid.dens.common.mixins.dimension.ServerLevelAccessor;
import com.necro.raid.dens.common.util.ILevelsSetter;
import com.necro.raid.dens.common.util.IRegistryRemover;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.util.TriConsumer;

public class DimensionHelper {
    public static TriConsumer<MinecraftServer, class_5321<class_1937>, Boolean> SYNC_DIMENSIONS;
    private static final Set<PendingDimension> QUEUED_FOR_REMOVAL;
    private static final Set<class_5321<class_1937>> DELAYED_REMOVAL;
    private static final Set<class_5321<class_1937>> REMOVED_LEVELS;

    public static void queueForRemoval(class_5321<class_1937> key, class_3218 level) {
        QUEUED_FOR_REMOVAL.add(new PendingDimension(key, level));
    }

    public static void addToCache(class_3218 level) {
        DELAYED_REMOVAL.add((class_5321<class_1937>)level.method_27983());
        for (class_1297 entity : level.method_27909()) {
            if (entity instanceof class_3222 || entity == null) continue;
            entity.method_31472();
        }
    }

    public static void removeFromCache(class_5321<class_1937> level) {
        DELAYED_REMOVAL.remove(level);
    }

    public static void removePending(MinecraftServer server) {
        if (QUEUED_FOR_REMOVAL.isEmpty()) {
            return;
        }
        Map<class_5321<class_1937>, class_3218> levels = ((MinecraftServerAccessor)server).getLevels();
        LinkedHashMap newLevels = Maps.newLinkedHashMap();
        for (Map.Entry<class_5321<class_1937>, class_3218> entry : levels.entrySet()) {
            if (QUEUED_FOR_REMOVAL.stream().anyMatch(pd -> pd.levelKey == entry.getKey())) continue;
            newLevels.put(entry.getKey(), entry.getValue());
        }
        ((ILevelsSetter)server).setLevels(newLevels);
        QUEUED_FOR_REMOVAL.forEach(pd -> {
            REMOVED_LEVELS.add(pd.levelKey);
            if (!pd.isRunning) {
                pd.saveAndClose(server);
            }
        });
        QUEUED_FOR_REMOVAL.clear();
    }

    public static void removeDelayed(MinecraftServer server, class_3222 player) {
        class_5321<class_1937> key = ModDimensions.createLevelKey(player.method_5845());
        if (!DELAYED_REMOVAL.contains(key)) {
            return;
        }
        class_3218 level = server.method_3847(key);
        if (level == null) {
            return;
        }
        DimensionHelper.queueForRemoval(key, level);
        SYNC_DIMENSIONS.accept((Object)server, key, (Object)false);
        DimensionHelper.removeFromCache(key);
    }

    public static void removeDelayed(MinecraftServer server) {
        for (class_5321<class_1937> key : DELAYED_REMOVAL) {
            class_3218 level = server.method_3847(key);
            if (level == null) {
                return;
            }
            DimensionHelper.queueForRemoval(key, level);
        }
        DimensionHelper.removePending(server);
        DELAYED_REMOVAL.clear();
    }

    public static boolean isLevelRemovedOrPending(class_5321<class_1937> level) {
        return REMOVED_LEVELS.contains(level);
    }

    static {
        QUEUED_FOR_REMOVAL = new HashSet<PendingDimension>();
        DELAYED_REMOVAL = new HashSet<class_5321<class_1937>>();
        REMOVED_LEVELS = new HashSet<class_5321<class_1937>>();
    }

    private static class PendingDimension {
        private final class_5321<class_1937> levelKey;
        private final class_3218 level;
        private boolean isRunning;

        PendingDimension(class_5321<class_1937> levelKey, class_3218 level) {
            this.levelKey = levelKey;
            this.level = level;
            this.isRunning = false;
        }

        private void saveAndClose(MinecraftServer server) {
            this.isRunning = true;
            try {
                ((ServerLevelAccessor)this.level).getEntityManager().close();
                this.level.method_14178().method_17293().close();
                this.level.method_14178().field_17254.close();
                if (ModCompat.DISTANT_HORIZONS.isLoaded()) {
                    CompletableFuture.runAsync(() -> RaidDensDistantHorizonsCompat.INSTANCE.unloadLevel(this.level), class_156.method_18349()).thenRun(() -> server.method_20493(() -> this.unregisterAndDelete(server)));
                } else {
                    server.method_20493(() -> this.unregisterAndDelete(server));
                }
            }
            catch (Throwable e) {
                CobblemonRaidDens.LOGGER.error("Error while closing dimension: ", e);
            }
        }

        private void unregisterAndDelete(MinecraftServer server) {
            class_2370 levelStemRegistry = (class_2370)server.method_30611().method_30530(class_7924.field_41224);
            class_5321 resourceKey = class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)ModDimensions.createLevelKey(this.levelKey.method_29177().method_12832()).method_29177());
            ((IRegistryRemover)levelStemRegistry).getById().removeIf(holder -> holder.method_40225(resourceKey));
            ((IRegistryRemover)levelStemRegistry).removeDimension(this.levelKey.method_29177());
            ((ILevelsSetter)server).deleteLevel(this.levelKey);
            CompletableFuture.delayedExecutor(2L, TimeUnit.SECONDS).execute(() -> REMOVED_LEVELS.remove(this.level.method_27983()));
        }
    }
}

