/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.raids.RaidBoss;
import com.necro.raid.dens.common.raids.RaidCycleMode;
import com.necro.raid.dens.common.raids.RaidTier;
import com.necro.raid.dens.common.raids.RaidType;
import com.necro.raid.dens.common.util.RaidBucket;
import com.necro.raid.dens.common.util.RaidBucketRegistry;
import com.necro.raid.dens.common.util.RaidRegistry;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class RaidDenCommands {
    public static final SuggestionProvider<class_2168> RAID_BOSSES = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (class_2960 id : RaidRegistry.getAll()) {
            if (!id.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<class_2168> RAID_BUCKETS = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        class_2378 registry = ((class_2168)context.getSource()).method_9211().method_30611().method_30530(RaidBucketRegistry.BUCKET_KEY);
        for (class_2960 id : registry.method_10235()) {
            if (!id.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(id.toString());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<class_2168> RAID_TIERS = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (RaidTier tier : RaidTier.values()) {
            if (!tier.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(tier.name());
        }
        return builder.buildFuture();
    };
    public static final SuggestionProvider<class_2168> CYCLE_MODE = (context, builder) -> {
        String remaining = builder.getRemaining().toLowerCase();
        for (RaidCycleMode cycleMode : RaidCycleMode.values()) {
            if (!cycleMode.toString().toLowerCase().startsWith(remaining)) continue;
            builder.suggest(cycleMode.name());
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"crd").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dens").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2262.method_9698()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), (class_2960)null, null, true))).then(class_2170.method_9247((String)"tier").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(RAID_TIERS).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), null, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(class_2170.method_9247((String)"boss").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"boss", (ArgumentType)class_2232.method_9441()).suggests(RAID_BOSSES).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), class_2232.method_9443((CommandContext)context, (String)"boss"), null, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), class_2232.method_9443((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), class_2232.method_9443((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(class_2170.method_9247((String)"bucket").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"bucket", (ArgumentType)class_2232.method_9441()).suggests(RAID_BUCKETS).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), class_2232.method_9443((CommandContext)context, (String)"bucket"), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), ((class_2168)context.getSource()).method_9225(), class_2232.method_9443((CommandContext)context, (String)"bucket"), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset"))))))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).requires(context -> !context.method_43737())).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), (class_2960)null, null, true))).then(class_2170.method_9247((String)"tier").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"tier", (ArgumentType)StringArgumentType.word()).suggests(RAID_TIERS).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), null, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), RaidTier.fromString(StringArgumentType.getString((CommandContext)context, (String)"tier").toUpperCase()), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(class_2170.method_9247((String)"boss").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"boss", (ArgumentType)class_2232.method_9441()).suggests(RAID_BOSSES).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2232.method_9443((CommandContext)context, (String)"boss"), null, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"cycle_mode", (ArgumentType)StringArgumentType.word()).suggests(CYCLE_MODE).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2232.method_9443((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDen((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2232.method_9443((CommandContext)context, (String)"boss"), RaidCycleMode.fromString(StringArgumentType.getString((CommandContext)context, (String)"cycle_mode")), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset")))))))).then(class_2170.method_9247((String)"bucket").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"bucket", (ArgumentType)class_2232.method_9441()).suggests(RAID_BUCKETS).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2232.method_9443((CommandContext)context, (String)"bucket"), true))).then(class_2170.method_9244((String)"can_reset", (ArgumentType)BoolArgumentType.bool()).executes(context -> RaidDenCommands.createRaidDenWithBucket((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"position"), class_2181.method_9289((CommandContext)context, (String)"dimension"), class_2232.method_9443((CommandContext)context, (String)"bucket"), BoolArgumentType.getBool((CommandContext)context, (String)"can_reset"))))))))));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        RaidDenCommands.register(dispatcher);
    }

    private static void setCrystal(class_1937 level, class_2338 blockPos, class_2680 blockState, boolean canReset, RaidCycleMode cycleMode, class_2960 location, @Nullable class_2960 bucket) {
        RaidBoss raidBoss = RaidRegistry.getRaidBoss(location);
        level.method_8652(blockPos, (class_2680)((class_2680)((class_2680)((class_2680)((class_2680)blockState.method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)RaidCrystalBlock.CAN_RESET, (Comparable)Boolean.valueOf(canReset))).method_11657(RaidCrystalBlock.CYCLE_MODE, (Comparable)((Object)cycleMode))).method_11657(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).method_11657(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier())), 2);
        class_2586 class_25862 = level.method_8321(blockPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
            raidCrystal.setRaidBoss(location, level.method_8409(), level.method_8510());
            if (bucket != null) {
                raidCrystal.setRaidBucket(bucket);
            }
        }
        RaidEvents.RAID_DEN_SPAWN.emit((Object[])new RaidDenSpawnEvent[]{new RaidDenSpawnEvent((class_3218)level, blockPos, raidBoss)});
    }

    private static int createRaidDenFromExisting(class_1937 level, RaidCrystalBlockEntity blockEntity, class_2338 blockPos, class_2960 location, RaidCycleMode cycleMode, boolean canReset) {
        RaidBucket rBucket;
        class_2680 blockState = blockEntity.method_11010();
        if (cycleMode == null) {
            cycleMode = (RaidCycleMode)((Object)blockState.method_11654(RaidCrystalBlock.CYCLE_MODE));
        }
        class_2960 bucket = null;
        if (cycleMode == RaidCycleMode.BUCKET && location == null && (rBucket = blockEntity.getRaidBucket()) != null) {
            bucket = rBucket.getId();
            location = rBucket.getRandomRaidBoss(level.method_8409(), level);
        }
        if (location == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.method_8409(), level) : (RaidTier)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TYPE));
            location = RaidRegistry.getRandomRaidBoss(level.method_8409(), level, tier, type, null);
        }
        RaidDenCommands.setCrystal(level, blockPos, blockState, canReset, cycleMode, location, bucket);
        return 1;
    }

    private static int createRaidDenNew(class_1937 level, class_2338 blockPos, class_2960 location, RaidCycleMode cycleMode, boolean canReset) {
        RaidBucket rBucket;
        if (cycleMode == null) {
            cycleMode = RaidCycleMode.fromString(CobblemonRaidDens.CONFIG.cycle_mode);
        }
        class_2960 bucket = null;
        if (cycleMode == RaidCycleMode.BUCKET && location == null && (rBucket = RaidBucketRegistry.getBucket(bucket = RaidBucketRegistry.getRandomBucket(level.method_8409(), (class_6880<class_1959>)level.method_23753(blockPos)))) != null) {
            location = rBucket.getRandomRaidBoss(level.method_8409(), level);
        }
        if (location == null) {
            location = RaidRegistry.getRandomRaidBoss(level.method_8409(), level);
        }
        RaidDenCommands.setCrystal(level, blockPos, ModBlocks.INSTANCE.getRaidCrystalBlock().method_9564(), canReset, cycleMode, location, bucket);
        return 1;
    }

    private static int createRaidDen(CommandContext<class_2168> context, class_2338 blockPos, class_3218 level, class_2960 raidBoss, RaidCycleMode cycleMode, boolean canReset) {
        if (level.method_23753(blockPos).method_40225(ModDimensions.RAIDDIM_BIOME)) {
            return 0;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            return RaidDenCommands.createRaidDenFromExisting((class_1937)level, raidCrystal, blockPos, raidBoss, cycleMode, canReset);
        }
        return RaidDenCommands.createRaidDenNew((class_1937)level, blockPos, raidBoss, cycleMode, canReset);
    }

    private static int createRaidDen(CommandContext<class_2168> context, class_2338 blockPos, class_3218 level, RaidTier raidTier, RaidCycleMode cycleMode, boolean canReset) {
        if (!raidTier.isPresent()) {
            CobblemonRaidDens.LOGGER.info("No raid bosses for that tier could be found. Rolling random tier.");
        }
        class_2680 blockState = level.method_8320(blockPos);
        if (cycleMode == null) {
            cycleMode = blockState.method_28498(RaidCrystalBlock.CYCLE_MODE) ? (RaidCycleMode)((Object)level.method_8320(blockPos).method_11654(RaidCrystalBlock.CYCLE_MODE)) : RaidCycleMode.fromString(CobblemonRaidDens.CONFIG.cycle_mode);
        }
        class_5819 random = ((class_2168)context.getSource()).method_9225().method_8409();
        RaidType type = !blockState.method_28498(RaidCrystalBlock.RAID_TYPE) || cycleMode.canCycleType() ? null : (RaidType)((Object)level.method_8320(blockPos).method_11654(RaidCrystalBlock.RAID_TYPE));
        return RaidDenCommands.createRaidDen(context, blockPos, level, RaidRegistry.getRandomRaidBoss(random, (class_1937)level, raidTier, type, null), cycleMode, canReset);
    }

    private static int createRaidDenWithBucketFromExisting(class_1937 level, class_2680 blockState, class_2338 blockPos, class_2960 bucket, boolean canReset) {
        class_2960 location = RaidBucketRegistry.getBucket(bucket).getRandomRaidBoss(level.method_8409(), level);
        if (location == null) {
            RaidTier tier = RaidTier.getWeightedRandom(level.method_8409(), level);
            location = RaidRegistry.getRandomRaidBoss(level.method_8409(), level, tier, null, null);
        }
        RaidDenCommands.setCrystal(level, blockPos, blockState, canReset, RaidCycleMode.BUCKET, location, bucket);
        return 1;
    }

    private static int createRaidDenWithBucketNew(class_1937 level, class_2338 blockPos, class_2960 bucket, boolean canReset) {
        class_2960 location = RaidBucketRegistry.getBucket(bucket).getRandomRaidBoss(level.method_8409(), level);
        if (location == null) {
            location = RaidRegistry.getRandomRaidBoss(level.method_8409(), level);
        }
        RaidDenCommands.setCrystal(level, blockPos, ModBlocks.INSTANCE.getRaidCrystalBlock().method_9564(), canReset, RaidCycleMode.BUCKET, location, bucket);
        return 1;
    }

    private static int createRaidDenWithBucket(CommandContext<class_2168> context, class_2338 blockPos, class_3218 level, class_2960 bucket, boolean canReset) {
        if (level.method_23753(blockPos).method_40225(ModDimensions.RAIDDIM_BIOME)) {
            return 0;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
            return RaidDenCommands.createRaidDenWithBucketFromExisting((class_1937)level, raidCrystal.method_11010(), blockPos, bucket, canReset);
        }
        return RaidDenCommands.createRaidDenWithBucketNew((class_1937)level, blockPos, bucket, canReset);
    }
}

