/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.dimensions.DimensionHelper;
import com.necro.raid.dens.common.raids.RaidHelper;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;

public class RaidAdminCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"crd").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"resetclears").requires(source -> source.method_9259(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"), class_2181.method_9289((CommandContext)context, (String)"dimension")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RaidAdminCommands::resetClearsForPlayerAndPos)))).requires(class_2168::method_43737)).executes(context -> RaidAdminCommands.resetClearsForAll((CommandContext<class_2168>)context, class_2262.method_48299((CommandContext)context, (String)"pos"))))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(RaidAdminCommands::resetClearsForPlayer)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(RaidAdminCommands::removeDimension)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"refresh").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(2))).executes(context -> RaidAdminCommands.refreshPlayer((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"))))).requires(class_2168::method_43737)).executes(RaidAdminCommands::refreshPlayer)));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 commandSelection) {
        RaidAdminCommands.register(dispatcher);
    }

    private static int refreshPlayer(CommandContext<class_2168> context, class_3222 player) {
        if (RaidUtils.isCustomDimension((class_1937)player.method_51469())) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"error.cobblemonraiddens.player_in_raid"));
            return 0;
        }
        RaidHelper.removeHost(player.method_5667());
        RaidHelper.removeParticipant(player.method_5667());
        if (RaidHelper.JOIN_QUEUE.containsKey(player)) {
            RaidHelper.JOIN_QUEUE.get(player).refundItem();
            RaidHelper.JOIN_QUEUE.remove(player);
        }
        ((class_2168)context.getSource()).method_45068(RaidHelper.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.command.refresh_player", (Object[])new Object[]{player.method_5477()})));
        return 1;
    }

    private static int refreshPlayer(CommandContext<class_2168> context) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        return RaidAdminCommands.refreshPlayer(context, player);
    }

    private static int resetClearsForPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        RaidHelper.resetPlayerAllClearedRaids(player.method_5667());
        ((class_2168)context.getSource()).method_45068(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
        return 1;
    }

    private static int resetClearsForPlayerAndPos(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"player");
        class_2338 blockPos = class_2262.method_48299(context, (String)"pos");
        class_3218 dimension = class_2181.method_9289(context, (String)"dimension");
        class_2586 class_25862 = dimension.method_8321(blockPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
            RaidHelper.resetPlayerClearedRaid(raidCrystal.getUuid(), player.method_5667());
            ((class_2168)context.getSource()).method_45068(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            return 1;
        }
        return 0;
    }

    private static int resetClearsForAll(CommandContext<class_2168> context, class_2338 blockPos) {
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        class_3218 dimension = player.method_51469();
        return RaidAdminCommands.resetClearsForAll(context, blockPos, dimension);
    }

    private static int resetClearsForAll(CommandContext<class_2168> context, class_2338 blockPos, class_3218 dimension) {
        class_2586 class_25862 = dimension.method_8321(blockPos);
        if (class_25862 instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
            RaidHelper.resetClearedRaids(raidCrystal.getUuid());
            ((class_2168)context.getSource()).method_45068(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.reset_clears"));
            raidCrystal.resetClears();
            class_2680 blockState = raidCrystal.method_11010();
            dimension.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
            return 1;
        }
        return 0;
    }

    private static int removeDimension(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3218 level = class_2181.method_9289(context, (String)"dimension");
        if (!RaidUtils.isCustomDimension((class_1937)level)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"error.cobblemonraiddens.invalid_dimension"));
            return 0;
        }
        if (!level.method_18456().isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43471((String)"error.cobblemonraiddens.players_in_dimension"));
            return 0;
        }
        DimensionHelper.queueForRemoval((class_5321<class_1937>)level.method_27983(), level);
        DimensionHelper.SYNC_DIMENSIONS.accept((Object)((class_2168)context.getSource()).method_9211(), (Object)level.method_27983(), (Object)false);
        ((class_2168)context.getSource()).method_45068(RaidHelper.getSystemMessage("message.cobblemonraiddens.command.remove_dimension"));
        return 1;
    }
}

