/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking;

import dev.architectury.impl.NetworkAggregator;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.fabric.NetworkManagerImpl;
import dev.architectury.networking.transformers.PacketCollector;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.networking.transformers.SinglePacketCollector;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_5455;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.ApiStatus;

public final class NetworkManager {
    @Deprecated(forRemoval=true)
    public static void registerS2CPayloadType(class_2960 id) {
        NetworkAggregator.registerS2CType(id, List.of());
    }

    public static <T extends class_8710> void registerS2CPayloadType(class_8710.class_9154<T> type, class_9139<? super class_9129, T> codec) {
        NetworkAggregator.registerS2CType(type, codec, List.of());
    }

    @Deprecated(forRemoval=true)
    public static void registerS2CPayloadType(class_2960 id, List<PacketTransformer> packetTransformers) {
        NetworkAggregator.registerS2CType(id, packetTransformers);
    }

    public static <T extends class_8710> void registerS2CPayloadType(class_8710.class_9154<T> type, class_9139<? super class_9129, T> codec, List<PacketTransformer> packetTransformers) {
        NetworkAggregator.registerS2CType(type, codec, packetTransformers);
    }

    @Deprecated(forRemoval=true)
    public static void registerReceiver(Side side, class_2960 id, NetworkReceiver<class_9129> receiver) {
        NetworkManager.registerReceiver(side, id, Collections.emptyList(), receiver);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public static void registerReceiver(Side side, class_2960 id, List<PacketTransformer> packetTransformers, NetworkReceiver<class_9129> receiver) {
        NetworkAggregator.registerReceiver(side, id, packetTransformers, receiver);
    }

    public static <T extends class_8710> void registerReceiver(Side side, class_8710.class_9154<T> id, class_9139<? super class_9129, T> codec, NetworkReceiver<T> receiver) {
        NetworkManager.registerReceiver(side, id, codec, Collections.emptyList(), receiver);
    }

    @ApiStatus.Experimental
    public static <T extends class_8710> void registerReceiver(Side side, class_8710.class_9154<T> id, class_9139<? super class_9129, T> codec, List<PacketTransformer> packetTransformers, NetworkReceiver<T> receiver) {
        NetworkAggregator.registerReceiver(side, id, codec, packetTransformers, receiver);
    }

    @Deprecated(forRemoval=true)
    public static class_2596<?> toPacket(Side side, class_2960 id, class_9129 buf) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, id, buf);
        return sink.getPacket();
    }

    @Deprecated(forRemoval=true)
    public static List<class_2596<?>> toPackets(Side side, class_2960 id, class_9129 buf) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, id, buf);
        return sink.collect();
    }

    public static <T extends class_8710> class_2596<?> toPacket(Side side, T payload, class_5455 access) {
        SinglePacketCollector sink = new SinglePacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, payload, access);
        return sink.getPacket();
    }

    public static <T extends class_8710> List<class_2596<?>> toPackets(Side side, T payload, class_5455 access) {
        PacketCollector sink = new PacketCollector(null);
        NetworkManager.collectPackets((PacketSink)sink, side, payload, access);
        return sink.collect();
    }

    @Deprecated(forRemoval=true)
    public static void collectPackets(PacketSink sink, Side side, class_2960 id, class_9129 buf) {
        NetworkAggregator.collectPackets(sink, side, id, buf);
    }

    public static <T extends class_8710> void collectPackets(PacketSink sink, Side side, T payload, class_5455 access) {
        NetworkAggregator.collectPackets(sink, side, payload, access);
    }

    @Deprecated(forRemoval=true)
    public static void sendToPlayer(class_3222 player, class_2960 id, class_9129 buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), id, buf);
    }

    @Deprecated(forRemoval=true)
    public static void sendToPlayers(Iterable<class_3222> players, class_2960 id, class_9129 buf) {
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), id, buf);
    }

    @Deprecated(forRemoval=true)
    @Environment(value=EnvType.CLIENT)
    public static void sendToServer(class_2960 id, class_9129 buf) {
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), id, buf);
    }

    public static <T extends class_8710> void sendToPlayer(class_3222 player, T payload) {
        NetworkManager.collectPackets(PacketSink.ofPlayer(player), NetworkManager.serverToClient(), payload, player.method_56673());
    }

    public static <T extends class_8710> void sendToPlayers(Iterable<class_3222> players, T payload) {
        Iterator<class_3222> iterator = players.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        NetworkManager.collectPackets(PacketSink.ofPlayers(players), NetworkManager.serverToClient(), payload, iterator.next().method_56673());
    }

    @Environment(value=EnvType.CLIENT)
    public static <T extends class_8710> void sendToServer(T payload) {
        class_634 connection = GameInstance.getClient().method_1562();
        if (connection == null) {
            return;
        }
        NetworkManager.collectPackets(PacketSink.client(), NetworkManager.clientToServer(), payload, (class_5455)connection.method_29091());
    }

    @Environment(value=EnvType.CLIENT)
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canServerReceive(class_2960 id) {
        return NetworkManagerImpl.canServerReceive(id);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        void var1_1;
        return NetworkManagerImpl.canPlayerReceive(player, (class_2960)var1_1);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canServerReceive(class_8710.class_9154<?> type) {
        return NetworkManager.canServerReceive(type.comp_2242());
    }

    public static boolean canPlayerReceive(class_3222 player, class_8710.class_9154<?> type) {
        return NetworkManager.canPlayerReceive(player, type.comp_2242());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_2596<class_2602> createAddEntityPacket(class_1297 entity, class_3231 serverEntity) {
        void var1_1;
        return NetworkManagerImpl.createAddEntityPacket(entity, (class_3231)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static NetworkAggregator.Adaptor getAdaptor() {
        return NetworkManagerImpl.getAdaptor();
    }

    public static Side s2c() {
        return Side.S2C;
    }

    public static Side c2s() {
        return Side.C2S;
    }

    public static Side serverToClient() {
        return Side.S2C;
    }

    public static Side clientToServer() {
        return Side.C2S;
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @FunctionalInterface
    public static interface NetworkReceiver<T> {
        public void receive(T var1, PacketContext var2);
    }

    public static interface PacketContext {
        public class_1657 getPlayer();

        public void queue(Runnable var1);

        public Env getEnvironment();

        public class_5455 registryAccess();

        default public EnvType getEnv() {
            return this.getEnvironment().toPlatform();
        }
    }
}

