/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemonarmors.armor;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kiwiapollo.cobblemonarmors.gamerule.ModGameRule;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1792;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public class ArmorSetFeature
implements ServerTickEvents.EndTick {
    private static final int DURATION_IN_SECONDS = 11;
    private final Map<class_1304, class_1792> armorSet;
    private final List<Predicate<class_3222>> predicates;
    private final List<class_6880<class_1291>> effects;

    public ArmorSetFeature(Map<class_1304, class_1792> armorSet, List<Predicate<class_3222>> predicates, List<class_6880<class_1291>> effects) {
        this.armorSet = armorSet;
        this.predicates = predicates;
        this.effects = effects;
    }

    public void onEndTick(MinecraftServer server) {
        if (!server.method_3767().method_8355(ModGameRule.ENABLE_ARMOR_SET_FEATURE)) {
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            if (!this.isPlayerWearingArmorSet(player, this.armorSet) || !this.predicates.stream().allMatch(predicate -> predicate.test(player))) continue;
            for (class_6880<class_1291> effect : this.effects) {
                player.method_6092(new class_1293(effect, this.getDurationInTicks(), 0, false, false, true));
            }
        }
    }

    private int getDurationInTicks() {
        return 220;
    }

    private boolean isPlayerWearingArmorSet(class_3222 player, Map<class_1304, class_1792> armorSet) {
        return armorSet.entrySet().stream().allMatch(entry -> {
            class_1304 slot = (class_1304)entry.getKey();
            class_1792 armor = (class_1792)entry.getValue();
            class_1792 equipped = player.method_6118(slot).method_7909();
            return equipped.equals(armor);
        });
    }
}

