/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.ui;

import com.cristoh.cobblegachamachine.ModTags;
import com.cristoh.cobblegachamachine.config.DefaultConfig;
import com.cristoh.cobblegachamachine.gacha.Session;
import com.cristoh.cobblegachamachine.item.ModItems;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import com.cristoh.cobblegachamachine.sound.PlayCoinInsertSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayDialSoundPayload;
import com.cristoh.cobblegachamachine.ui.GachaUIManager;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public class CustomSimpleGUI
extends SimpleGui {
    private Session currentSession;
    private final String NEGATIVE_SPACES = "\uf808";
    private final String GUI_BACKGROUND_EMPTY = "\ue000";
    private final String GUI_BACKGROUND_WITH_COIN = "\ue001";
    private final class_2960 CUSTOM_FONT = class_2960.method_60655((String)"cobble-gacha-machine", (String)"gacha");

    public CustomSimpleGUI(class_3917<?> type, class_3222 player, boolean manipulatePlayerSlots, class_2338 pos) {
        super(type, player, manipulatePlayerSlots);
        this.currentSession = GachaUIManager.getOrCreateSession(player, pos);
        this.currentSession.gui = this;
        this.updatePlayerSessionGui();
    }

    public void updatePlayerSessionGui() {
        if (this.currentSession.coinCount > 0) {
            title = class_2561.method_43470((String)"\u00a7f\uf808\ue001").method_10862(class_2583.field_24360.method_27704(this.CUSTOM_FONT));
            this.setTitle((class_2561)title);
        } else {
            title = class_2561.method_43470((String)"\u00a7f\uf808\ue000").method_10862(class_2583.field_24360.method_27704(this.CUSTOM_FONT));
            this.setTitle((class_2561)title);
        }
        this.setSlot(8, (GuiElementBuilderInterface)this.createCoinStack());
        for (int i = 0; i < 5; ++i) {
            GuiElementBuilder displayStack = this.createDisplayStack(i);
            this.setSlot(11 + i, (GuiElementBuilderInterface)displayStack);
        }
        this.setSlot(9, (GuiElementBuilderInterface)this.createSpinStack());
        if (DefaultConfig.isSkipAnimationButtonEnabled()) {
            this.setSlot(26, (GuiElementBuilderInterface)this.createSkipAnimationStack());
        }
    }

    private GuiElementBuilder createCoinStack() {
        GuiElementBuilder stack;
        if (this.currentSession.coinCount > 0) {
            stack = new GuiElementBuilder(this.currentSession.coinItem, Math.min(this.currentSession.coinCount, 64));
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.coins_counter").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)("" + this.currentSession.coinCount)).method_27692(class_124.field_1068)));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_insert_coin").method_27692(class_124.field_1054));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.to_add_more_coins").method_27692(class_124.field_1080));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.from_inventory").method_27692(class_124.field_1080));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_remove_coins").method_27692(class_124.field_1054));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.to_remove_coin").method_27692(class_124.field_1080));
        } else {
            this.currentSession.coinItem = null;
            stack = new GuiElementBuilder(ModItems.INVISIBLE_TOOLTIP);
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.no_coins").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_insert_coin").method_27692(class_124.field_1054));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.to_insert_coin").method_27692(class_124.field_1080));
        }
        stack.addLoreLine((class_2561)class_2561.method_43470((String)"").method_27692(class_124.field_1080));
        class_6885.class_6888 coinItems = this.player.method_5682().method_30611().method_30530(class_7924.field_41197).method_40266(ModTags.Items.COIN_ITEMS).orElse(null);
        if (coinItems != null) {
            coinItems.method_40239().limit(5L).forEach(entry -> {
                String itemName = ((class_1792)entry.comp_349()).method_7848().getString();
                stack.addLoreLine((class_2561)class_2561.method_43470((String)("  \u2022 " + itemName)).method_27692(class_124.field_1054));
            });
        }
        stack.setCallback((index, type, action) -> {
            if (type == ClickType.MOUSE_LEFT) {
                if (this.removeCoinFromPlayer(this.player, 1)) {
                    ++this.currentSession.coinCount;
                    if (this.player.method_37908().method_8608()) {
                        this.player.method_37908().method_8396(null, this.player.method_24515(), ModSounds.INSERT_COIN, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        ServerPlayNetworking.send((class_3222)this.player, (class_8710)PlayCoinInsertSoundPayload.INSTANCE);
                    }
                    this.updatePlayerSessionGui();
                }
            } else if ((type == ClickType.MOUSE_RIGHT || type == ClickType.MOUSE_LEFT_SHIFT && this.currentSession.coinCount > 0) && this.currentSession.coinItem != null) {
                class_1799 coinStack = new class_1799((class_1935)this.currentSession.coinItem, 1);
                this.player.method_31548().method_7398(coinStack);
                --this.currentSession.coinCount;
                this.updatePlayerSessionGui();
            }
        });
        return stack;
    }

    private GuiElementBuilder createDisplayStack(int index) {
        GuiElementBuilder stack;
        if (this.currentSession.displaySlots[index] != null) {
            stack = new GuiElementBuilder(this.currentSession.displaySlots[index].method_7972().method_7909());
            if (index == 2 && this.currentSession.spinning) {
                stack.glow();
            }
        } else {
            stack = new GuiElementBuilder(class_1802.field_8162);
        }
        return stack;
    }

    private GuiElementBuilder createSpinStack() {
        GuiElementBuilder stack = new GuiElementBuilder(ModItems.INVISIBLE_TOOLTIP);
        if (this.currentSession.spinning) {
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.spinning").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.please_wait").method_27692(class_124.field_1080));
        } else if (this.currentSession.coinCount >= DefaultConfig.getCoinsToSpin()) {
            int coinsNeeded = DefaultConfig.getCoinsToSpin();
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.spin").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.cost").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43469((String)"text.cobble-gacha-machine.x_coin", (Object[])new Object[]{coinsNeeded}).method_27692(class_124.field_1065)));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_spin").method_27692(class_124.field_1060));
        } else {
            int coinsNeeded = DefaultConfig.getCoinsToSpin();
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.need_coins_title").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43469((String)(coinsNeeded == 1 ? "text.cobble-gacha-machine.need_coin" : "text.cobble-gacha-machine.need_coins"), (Object[])new Object[]{coinsNeeded}).method_27692(class_124.field_1061));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.insert_coin_to_spin").method_27692(class_124.field_1080));
        }
        stack.setCallback((index, type, action) -> {
            if (type == ClickType.MOUSE_LEFT) {
                if (this.currentSession.spinning) {
                    return;
                }
                int coinsNeeded = DefaultConfig.getCoinsToSpin();
                if (this.currentSession.coinCount < coinsNeeded) {
                    return;
                }
                boolean started = GachaUIManager.prepareSpin(this.player, this.currentSession);
                if (started) {
                    this.currentSession.coinCount -= coinsNeeded;
                    if (this.player.method_37908().method_8608()) {
                        this.player.method_37908().method_8396(null, this.player.method_24515(), ModSounds.GACHA_DIAL, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        ServerPlayNetworking.send((class_3222)this.player, (class_8710)PlayDialSoundPayload.INSTANCE);
                    }
                    this.updatePlayerSessionGui();
                }
            }
        });
        return stack;
    }

    private GuiElementBuilder createSkipAnimationStack() {
        GuiElementBuilder stack;
        if (this.currentSession.skipAnimation) {
            stack = new GuiElementBuilder(class_1802.field_8131);
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.skip_animation").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067}));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.skip_animation_enabled").method_27692(class_124.field_1060));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_to_disable").method_27692(class_124.field_1054));
        } else {
            stack = new GuiElementBuilder(class_1802.field_8298);
            stack.setName((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.skip_animation").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.skip_animation_disabled").method_27692(class_124.field_1080));
            stack.addLoreLine((class_2561)class_2561.method_43470((String)""));
            stack.addLoreLine((class_2561)class_2561.method_43471((String)"text.cobble-gacha-machine.click_to_enable").method_27692(class_124.field_1054));
        }
        stack.setCallback((index, type, action) -> {
            if (type == ClickType.MOUSE_LEFT) {
                this.currentSession.skipAnimation = !this.currentSession.skipAnimation;
                this.updatePlayerSessionGui();
            }
        });
        return stack;
    }

    private boolean removeCoinFromPlayer(class_3222 player, int amount) {
        int remaining = amount;
        for (int i = 0; i < player.method_31548().method_5439() && remaining > 0; ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if ((this.currentSession.coinItem != null || !stack.method_31573(ModTags.Items.COIN_ITEMS)) && this.currentSession.coinItem != stack.method_7909()) continue;
            int toRemove = Math.min(remaining, stack.method_7947());
            this.currentSession.coinItem = stack.method_7972().method_7909();
            stack.method_7934(toRemove);
            remaining -= toRemove;
        }
        return remaining == 0;
    }

    public void onTick() {
        super.onTick();
        if (this.currentSession.spinning) {
            for (int i = 0; i < 5; ++i) {
                GuiElementBuilder displayStack = this.createDisplayStack(i);
                this.setSlot(11 + i, (GuiElementBuilderInterface)displayStack);
            }
        }
    }
}

