/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.pokemon;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.spawning.BestSpawner;
import com.cobblemon.mod.common.api.spawning.CobblemonSpawnPools;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.detail.SpawnPool;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.cristoh.cobblegachamachine.item.custom.CapsuleRarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;

public class PokemonSelector {
    private static final ConcurrentHashMap<String, HashMap<Species, Float>> buckets = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, List<Species>> labelCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, LinkedList<Species>> playerRecentPokemon = new ConcurrentHashMap();
    private static final int MAX_CONSECUTIVE = 2;
    private static final float NEW_POKEMON_WEIGHT_MULTIPLIER = 1.5f;

    private static void initBuckets() {
        for (SpawnBucket bucket : BestSpawner.INSTANCE.getConfig().getBuckets()) {
            buckets.put(bucket.getName(), new HashMap());
        }
        SpawnPool spawnPool = CobblemonSpawnPools.WORLD_SPAWN_POOL;
        for (SpawnDetail spawnDetail : spawnPool.getDetails()) {
            try {
                Species species;
                String pokemonSpeciesName;
                String bucketName = spawnDetail.getBucket().getName();
                if (!buckets.containsKey(bucketName) || (pokemonSpeciesName = ((PokemonSpawnDetail)spawnDetail).getPokemon().getSpecies()) == null || (species = PokemonSpecies.getByName((String)pokemonSpeciesName)) == null || species.getLabels().contains("legendary") || species.getLabels().contains("mythical")) continue;
                float weight = spawnDetail.getWeight();
                if (!buckets.get(bucketName).containsKey(species)) {
                    buckets.get(bucketName).put(species, Float.valueOf(weight));
                    continue;
                }
                Float existingWeight = buckets.get(bucketName).get(species);
                if (!(weight > existingWeight.floatValue())) continue;
                buckets.get(bucketName).put(species, Float.valueOf(weight));
            }
            catch (Exception e) {}
        }
        PokemonSelector.initLabelCache();
        for (Map.Entry entry : buckets.entrySet()) {
            CobbleGachaMachine.LOGGER.info("Bucket: " + (String)entry.getKey() + " has " + ((HashMap)entry.getValue()).size() + " pokemons");
        }
    }

    private static void initLabelCache() {
        for (Species species2 : PokemonSpecies.getSpecies()) {
            for (String label : species2.getLabels()) {
                labelCache.computeIfAbsent(label, k -> new ArrayList()).add(species2);
            }
        }
        CobbleGachaMachine.LOGGER.info("Label cache initialized with " + labelCache.size() + " labels");
        CobbleGachaMachine.LOGGER.info("Label legendary has " + labelCache.get("legendary").size() + " pokemons:");
        labelCache.get("legendary").forEach(species -> CobbleGachaMachine.LOGGER.info(species.getName()));
        CobbleGachaMachine.LOGGER.info("Label mythical has " + labelCache.get("mythical").size() + " pokemons:");
        labelCache.get("mythical").forEach(species -> CobbleGachaMachine.LOGGER.info(species.getName()));
    }

    public static Pokemon selectPokemonByRarity(class_3218 world, class_1657 player, CapsuleRarity rarity) {
        List<Map.Entry<Species, Float>> eligibleSpecies;
        if (buckets.isEmpty()) {
            PokemonSelector.initBuckets();
        }
        List<Map.Entry<Species, Float>> list = eligibleSpecies = rarity.useCustomList() ? PokemonSelector.getSpeciesByCapsuleCustomList(rarity) : PokemonSelector.getSpeciesByCapsuleRarity(rarity);
        if (eligibleSpecies.isEmpty()) {
            CobbleGachaMachine.LOGGER.warn(class_2561.method_43469((String)"logger.cobble-gacha-machine.pokemon_specie_not_found", (Object[])new Object[]{rarity.getName()}).getString());
            return null;
        }
        Species selectedSpecies = PokemonSelector.selectSpeciesWithWeights(eligibleSpecies, player, world.field_9229, rarity.useCustomList());
        int level = rarity.getMinLevel() + world.field_9229.method_43048(rarity.getMaxLevel() - rarity.getMinLevel() + 1);
        Pokemon pokemon = selectedSpecies.create(level);
        int shinyChance = rarity.getShinyChance();
        if (rarity.isShinyEnabled() && world.field_9229.method_43048(shinyChance) == 0) {
            pokemon.setShiny(true);
        }
        return pokemon;
    }

    private static List<Map.Entry<Species, Float>> getSpeciesByCapsuleCustomList(CapsuleRarity rarity) {
        return rarity.getCustomList().stream().map(entry -> {
            try {
                Species species = PokemonSpecies.getByName((String)entry.name);
                if (species == null) {
                    CobbleGachaMachine.LOGGER.info(class_2561.method_43469((String)"logger.cobble-gacha-machine.custom_list_pokemon_not_found", (Object[])new Object[]{entry.name, rarity.getName()}).getString());
                    return null;
                }
                return Map.entry(species, Float.valueOf(entry.weight));
            }
            catch (Exception e) {
                CobbleGachaMachine.LOGGER.error(class_2561.method_43469((String)"logger.cobble-gacha-machine.custom_list_pokemon_load_error", (Object[])new Object[]{entry.name, rarity.getName()}).getString());
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    private static boolean hasPlayerCaughtSpecies(class_1657 player, Species species) {
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        PCStore pcStore = Cobblemon.INSTANCE.getStorage().getPC((class_3222)player);
        for (Pokemon pokemon : partyStore) {
            if (!pokemon.getSpecies().getName().equals(species.getName())) continue;
            return true;
        }
        for (Pokemon pokemon : pcStore) {
            if (!pokemon.getSpecies().getName().equals(species.getName())) continue;
            return true;
        }
        return false;
    }

    private static List<Map.Entry<Species, Float>> getSpeciesByLabel(CapsuleRarity rarity) {
        HashSet<Species> uniqueSpecies = new HashSet<Species>();
        for (String label : rarity.getAllowedBuckets()) {
            List<Species> speciesWithLabel = labelCache.get(label);
            if (speciesWithLabel == null) continue;
            uniqueSpecies.addAll(speciesWithLabel);
        }
        return uniqueSpecies.stream().map(species -> Map.entry(species, Float.valueOf(1.0f))).toList();
    }

    private static List<Map.Entry<Species, Float>> getSpeciesByCapsuleRarity(CapsuleRarity rarity) {
        List<Map.Entry<Species, Float>> speciesByBucket = Arrays.stream(rarity.getAllowedBuckets()).filter(buckets::containsKey).flatMap(bucket -> buckets.get(bucket).entrySet().stream()).filter(entry -> {
            float weight = ((Float)entry.getValue()).floatValue();
            return weight >= rarity.getMinWeight() && weight <= rarity.getMaxWeight();
        }).toList();
        if (speciesByBucket.isEmpty()) {
            return PokemonSelector.getSpeciesByLabel(rarity);
        }
        return speciesByBucket;
    }

    private static Species selectSpeciesWithWeights(List<Map.Entry<Species, Float>> weightedSpecies, class_1657 player, class_5819 random, boolean useCustomList) {
        Species second;
        Species first;
        if (weightedSpecies.size() == 1) {
            return weightedSpecies.getFirst().getKey();
        }
        UUID playerId = player.method_5667();
        LinkedList recentPokemon = playerRecentPokemon.computeIfAbsent(playerId, k -> new LinkedList());
        Species blockedSpecies = null;
        if (recentPokemon.size() >= 2 && !useCustomList && (first = (Species)recentPokemon.get(0)).equals(second = (Species)recentPokemon.get(1))) {
            blockedSpecies = first;
        }
        ArrayList<Float> adjustedWeights = new ArrayList<Float>();
        float totalWeight = 0.0f;
        for (Map.Entry<Species, Float> entry : weightedSpecies) {
            Species species = entry.getKey();
            float baseWeight = entry.getValue().floatValue();
            if (species.equals(blockedSpecies)) {
                adjustedWeights.add(Float.valueOf(0.0f));
                continue;
            }
            float adjustedWeight = PokemonSelector.hasPlayerCaughtSpecies(player, species) ? baseWeight : baseWeight * 1.5f;
            adjustedWeights.add(Float.valueOf(adjustedWeight));
            totalWeight += adjustedWeight;
        }
        if (totalWeight <= 0.0f) {
            recentPokemon.clear();
            return PokemonSelector.selectSpeciesWithWeights(weightedSpecies, player, random, useCustomList);
        }
        double randomValue = random.method_43058() * (double)totalWeight;
        double currentWeight = 0.0;
        Species selectedSpecies = null;
        for (int i = 0; i < weightedSpecies.size(); ++i) {
            if (!(randomValue <= (currentWeight += (double)((Float)adjustedWeights.get(i)).floatValue()))) continue;
            selectedSpecies = weightedSpecies.get(i).getKey();
            break;
        }
        if (selectedSpecies == null) {
            selectedSpecies = weightedSpecies.getLast().getKey();
        }
        recentPokemon.addFirst(selectedSpecies);
        if (recentPokemon.size() > 2) {
            recentPokemon.removeLast();
        }
        return selectedSpecies;
    }
}

