/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.item.custom;

import com.cristoh.cobblegachamachine.config.DefaultConfig;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3414;

public enum CapsuleRarity {
    NORMAL("normal", class_124.field_1061, ModSounds.REWARD_NORMAL, (class_2394)class_2398.field_29644, 10),
    RARE("rare", class_124.field_1075, ModSounds.REWARD_RARE, (class_2394)class_2398.field_11244, 35),
    ULTRA_RARE("ultra_rare", class_124.field_1060, ModSounds.REWARD_ULTRA_RARE, (class_2394)class_2398.field_11211, 30),
    LEGENDARY("legendary", class_124.field_1076, ModSounds.REWARD_LEGENDARY, (class_2394)class_2398.field_11216, 30);

    private final String name;
    private final class_124 chatColor;
    private final class_3414 sound;
    private final class_2394 particle;
    private final int particleCount;

    private CapsuleRarity(String name, class_124 chatColor, class_3414 sound, class_2394 particle, int particleCount) {
        this.name = name;
        this.chatColor = chatColor;
        this.sound = sound;
        this.particle = particle;
        this.particleCount = particleCount;
    }

    private DefaultConfig.CapsuleConfigData getConfig() {
        return DefaultConfig.getConfigForRarity(this.name);
    }

    public String getName() {
        return this.name;
    }

    public double getPokemonSpawnChance() {
        return this.getConfig().pokemonSpawnChance;
    }

    public int getMinLevel() {
        return this.getConfig().pokemonMinLevel;
    }

    public int getMaxLevel() {
        return this.getConfig().pokemonMaxLevel;
    }

    public String[] getAllowedBuckets() {
        return this.getConfig().pokemonPool;
    }

    public boolean isShinyEnabled() {
        return this.getConfig().shinyChance > 0;
    }

    public int getShinyChance() {
        return this.getConfig().shinyChance;
    }

    public double getCapsuleWeight() {
        return this.getConfig().capsuleWeight;
    }

    public float getMinWeight() {
        return this.getConfig().poolMinWeight;
    }

    public float getMaxWeight() {
        return this.getConfig().poolMaxWeight;
    }

    public boolean useCustomList() {
        return this.getConfig().customList != null && !this.getConfig().customList.isEmpty();
    }

    public List<DefaultConfig.CustomPokemonEntry> getCustomList() {
        return this.getConfig().customList;
    }

    public class_124 getChatColor() {
        return this.chatColor;
    }

    public class_3414 getSound() {
        return this.sound;
    }

    public class_2394 getParticle() {
        return this.particle;
    }

    public int getParticleCount() {
        return this.particleCount;
    }
}

