/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.gacha;

import com.cristoh.cobblegachamachine.config.DefaultConfig;
import com.cristoh.cobblegachamachine.gacha.Session;
import com.cristoh.cobblegachamachine.item.ModItems;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import com.cristoh.cobblegachamachine.sound.PlayDispenseSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlaySpinSoundPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_8710;

public class SpinEngine {
    private static final class_1792[] CAPSULE_TYPES = new class_1792[]{ModItems.NORMAL_CAPSULE, ModItems.RARE_CAPSULE, ModItems.ULTRA_RARE_CAPSULE, ModItems.LEGENDARY_CAPSULE};

    public static boolean prepareSpin(class_3222 player, Session session) {
        if (session.spinning) {
            return false;
        }
        int poolSize = DefaultConfig.getPoolSize();
        session.pool = new class_1799[poolSize];
        for (int i = 0; i < poolSize; ++i) {
            session.pool[i] = SpinEngine.pickWeightedCapsule(player);
        }
        SpinEngine.shufflePool(player, session.pool);
        session.windowStart = player.method_37908().field_9229.method_43048(poolSize);
        int targetIndex = player.method_37908().field_9229.method_43048(poolSize);
        int desiredWindowStart = (targetIndex - 2 + poolSize) % poolSize;
        int cycles = 3;
        session.shiftsRemaining = session.totalShifts = cycles * poolSize + (desiredWindowStart - session.windowStart + poolSize) % poolSize;
        session.updateDisplaySlots();
        session.spinning = true;
        session.cooldownTicks = 0;
        return true;
    }

    public static void tick(class_3222 player, Session session) {
        if (session == null) {
            return;
        }
        if (session.spinning) {
            double progress;
            if (session.skipAnimation) {
                int targetShifts = session.totalShifts;
                int poolSize = DefaultConfig.getPoolSize();
                session.windowStart = (session.windowStart + targetShifts) % poolSize;
                session.updateDisplaySlots();
                session.shiftsRemaining = 0;
                session.spinning = false;
                session.cooldownTicks = 40;
                class_1799 reward = session.displaySlots[2];
                if (session.gui != null) {
                    session.gui.updatePlayerSessionGui();
                }
                if (reward != null) {
                    if (player.method_37908().method_8608()) {
                        player.method_37908().method_8396(null, player.method_24515(), ModSounds.GACHA_DISPENSE, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)PlayDispenseSoundPayload.INSTANCE);
                    }
                    player.method_31548().method_7398(reward.method_7972());
                }
                return;
            }
            ++session.tickAccumulator;
            if (session.totalShifts <= 0) {
                session.totalShifts = 1;
            }
            double ease = (progress = 1.0 - (double)session.shiftsRemaining / (double)session.totalShifts) < 0.92 ? Math.pow(progress, 2.0) : Math.pow(progress, 0.1);
            boolean minInterval = true;
            int maxInterval = 11;
            int interval = 1 + (int)Math.round(10.0 * ease);
            if (interval < 1) {
                interval = 1;
            }
            if (session.tickAccumulator >= interval) {
                int poolSize = DefaultConfig.getPoolSize();
                session.windowStart = (session.windowStart + 1) % poolSize;
                session.updateDisplaySlots();
                --session.shiftsRemaining;
                session.tickAccumulator = 0;
                if (session.gui != null && session.gui.isOpen()) {
                    if (player.method_37908().method_8608()) {
                        player.method_37908().method_8396(null, player.method_24515(), ModSounds.GACHA_RUNNING, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)PlaySpinSoundPayload.INSTANCE);
                    }
                }
            }
            if (session.shiftsRemaining <= 0) {
                session.spinning = false;
                session.cooldownTicks = 40;
                class_1799 reward = session.displaySlots[2];
                if (session.gui != null) {
                    session.gui.updatePlayerSessionGui();
                }
                if (reward != null) {
                    if (player.method_37908().method_8608()) {
                        player.method_37908().method_8396(null, player.method_24515(), ModSounds.GACHA_DISPENSE, class_3419.field_15248, 1.0f, 1.0f);
                    } else {
                        ServerPlayNetworking.send((class_3222)player, (class_8710)PlayDispenseSoundPayload.INSTANCE);
                    }
                    player.method_31548().method_7398(reward.method_7972());
                }
            }
        } else if (session.cooldownTicks > 0) {
            --session.cooldownTicks;
            if (session.cooldownTicks == 0) {
                session.clearDisplaySlots();
                if (session.gui != null) {
                    session.gui.updatePlayerSessionGui();
                }
            }
        }
    }

    private static void shufflePool(class_3222 player, class_1799[] pool) {
        for (int i = pool.length - 1; i > 0; --i) {
            int j = player.method_37908().field_9229.method_43048(i + 1);
            class_1799 temp = pool[i];
            pool[i] = pool[j];
            pool[j] = temp;
        }
    }

    private static class_1799 pickWeightedCapsule(class_3222 player) {
        double[] capsuleWeights = new double[]{DefaultConfig.getConfigForRarity((String)"normal").capsuleWeight, DefaultConfig.getConfigForRarity((String)"rare").capsuleWeight, DefaultConfig.getConfigForRarity((String)"ultra_rare").capsuleWeight, DefaultConfig.getConfigForRarity((String)"legendary").capsuleWeight};
        double total = 0.0;
        for (double w : capsuleWeights) {
            total += w;
        }
        double r = player.method_37908().field_9229.method_43058() * total;
        double acc = 0.0;
        for (int i = 0; i < CAPSULE_TYPES.length; ++i) {
            if (!(r < (acc += capsuleWeights[i]))) continue;
            return CAPSULE_TYPES[i].method_7854();
        }
        return CAPSULE_TYPES[0].method_7854();
    }
}

