/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine.config;

import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DefaultConfig {
    private static final Logger LOGGER = CobbleGachaMachine.LOGGER;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "default.json";
    private static Map<String, CapsuleConfigData> capsuleConfigs = new HashMap<String, CapsuleConfigData>();
    private static int poolSize = 15;
    private static boolean megashowdownItems = true;
    private static int coinsToSpin = 3;
    private static boolean skipAnimationButton = true;

    public static void loadConfig(Path configDir) {
        Path configPath = configDir.resolve("cobble-gacha-machine").resolve(CONFIG_FILE_NAME);
        try {
            String json;
            ConfigRoot config;
            if (!Files.exists(configPath, new LinkOption[0])) {
                LOGGER.info("Config file not found, creating default config at: {}", (Object)configPath);
                DefaultConfig.createDefaultConfig(configPath);
            }
            if ((config = (ConfigRoot)GSON.fromJson(json = Files.readString(configPath), ConfigRoot.class)) != null && config.capsules != null) {
                capsuleConfigs = config.capsules;
                if (config.poolSize > 0) {
                    poolSize = config.poolSize;
                }
                if (config.coinsToSpin > 0) {
                    coinsToSpin = config.coinsToSpin;
                }
                megashowdownItems = config.megashowdownItems;
                skipAnimationButton = config.skipAnimationButton;
                LOGGER.info("Loaded configuration for {} capsule types", (Object)capsuleConfigs.size());
            } else {
                LOGGER.warn("Invalid config format, using defaults");
                DefaultConfig.loadDefaults();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read config file: {}", (Object)e.getMessage());
            DefaultConfig.loadDefaults();
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Invalid JSON syntax in config file: {}", (Object)e.getMessage());
            DefaultConfig.loadDefaults();
        }
    }

    private static void createDefaultConfig(Path configPath) throws IOException {
        Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
        DefaultConfig.loadDefaults();
        ConfigRoot defaultConfig = new ConfigRoot();
        defaultConfig.capsules = capsuleConfigs;
        defaultConfig.megashowdownItems = megashowdownItems;
        defaultConfig.coinsToSpin = coinsToSpin;
        defaultConfig.skipAnimationButton = skipAnimationButton;
        String json = GSON.toJson((Object)defaultConfig);
        Files.writeString(configPath, (CharSequence)json, new OpenOption[0]);
        LOGGER.info("Created default config file at: {}", (Object)configPath);
    }

    private static void loadDefaults() {
        capsuleConfigs = new HashMap<String, CapsuleConfigData>();
        CapsuleConfigData normal = new CapsuleConfigData();
        normal.capsuleWeight = 75.0;
        normal.pokemonSpawnChance = 0.15;
        normal.shinyChance = 2048;
        normal.pokemonMinLevel = 5;
        normal.pokemonMaxLevel = 20;
        normal.pokemonPool = new String[]{"common"};
        normal.poolMinWeight = 0.15f;
        normal.poolMaxWeight = 100.0f;
        normal.customList = new ArrayList<CustomPokemonEntry>();
        capsuleConfigs.put("normal", normal);
        CapsuleConfigData rare = new CapsuleConfigData();
        rare.capsuleWeight = 17.0;
        rare.pokemonSpawnChance = 0.25;
        rare.shinyChance = 1024;
        rare.pokemonMinLevel = 15;
        rare.pokemonMaxLevel = 35;
        rare.pokemonPool = new String[]{"uncommon", "rare"};
        rare.poolMinWeight = 0.0032f;
        rare.poolMaxWeight = 100.0f;
        rare.customList = new ArrayList<CustomPokemonEntry>();
        capsuleConfigs.put("rare", rare);
        CapsuleConfigData ultraRare = new CapsuleConfigData();
        ultraRare.capsuleWeight = 6.0;
        ultraRare.pokemonSpawnChance = 0.5;
        ultraRare.shinyChance = 512;
        ultraRare.pokemonMinLevel = 30;
        ultraRare.pokemonMaxLevel = 50;
        ultraRare.pokemonPool = new String[]{"ultra-rare"};
        ultraRare.poolMinWeight = 0.002f;
        ultraRare.poolMaxWeight = 10.0f;
        ultraRare.customList = new ArrayList<CustomPokemonEntry>();
        capsuleConfigs.put("ultra_rare", ultraRare);
        CapsuleConfigData legendary = new CapsuleConfigData();
        legendary.capsuleWeight = 2.0;
        legendary.pokemonSpawnChance = 1.0;
        legendary.shinyChance = 256;
        legendary.pokemonMinLevel = 50;
        legendary.pokemonMaxLevel = 100;
        legendary.pokemonPool = new String[]{"legendary", "mythical"};
        legendary.poolMinWeight = 0.0f;
        legendary.poolMaxWeight = 0.0f;
        legendary.customList = new ArrayList<CustomPokemonEntry>();
        capsuleConfigs.put("legendary", legendary);
    }

    public static CapsuleConfigData getConfigForRarity(String rarityName) {
        return capsuleConfigs.get(rarityName);
    }

    public static int getPoolSize() {
        return poolSize;
    }

    public static boolean isMegashowdownItemsEnabled() {
        return megashowdownItems;
    }

    public static int getCoinsToSpin() {
        return coinsToSpin;
    }

    public static boolean isSkipAnimationButtonEnabled() {
        return skipAnimationButton;
    }

    public static class ConfigRoot {
        public int poolSize = 15;
        public boolean megashowdownItems = true;
        public int coinsToSpin = 2;
        public boolean skipAnimationButton = true;
        public Map<String, CapsuleConfigData> capsules;
    }

    public static class CapsuleConfigData {
        public double capsuleWeight;
        public double pokemonSpawnChance;
        public int shinyChance;
        public int pokemonMinLevel;
        public int pokemonMaxLevel;
        public String[] pokemonPool;
        public float poolMinWeight;
        public float poolMaxWeight;
        public List<CustomPokemonEntry> customList;
    }

    public static class CustomPokemonEntry {
        public String name;
        public float weight;

        public CustomPokemonEntry() {
        }

        public CustomPokemonEntry(String name, float weight) {
            this.name = name;
            this.weight = weight;
        }
    }
}

