/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine;

import com.cristoh.cobblegachamachine.CobbleGachaMachine;
import com.cristoh.cobblegachamachine.config.DefaultConfig;
import com.cristoh.cobblegachamachine.mixin.LootContextTypesAccessor;
import com.google.common.collect.BiMap;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.loot.v3.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.fabricmc.fabric.mixin.loot.LootTableAccessor;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_176;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_85;

public class ModLootTables {
    public static class_176 CAPSULE;

    protected static class_176 registerLootContext(class_2960 id, Consumer<class_176.class_177> type) {
        class_176.class_177 builder = class_176.method_35554();
        type.accept(builder);
        class_176 lootContextType = builder.method_782();
        BiMap<class_2960, class_176> map = LootContextTypesAccessor.getMAP();
        class_176 check = (class_176)map.put((Object)id, (Object)lootContextType);
        if (check != null) {
            throw new IllegalStateException("Loot table parameter set " + String.valueOf(id) + " is already registered");
        }
        return lootContextType;
    }

    public static void registerModifiers() {
        LootTableEvents.REPLACE.register((key, table, source, lookupProvider) -> {
            class_2960 tableId = key.method_29177();
            if (source.isBuiltin() && tableId.method_12836().equals("cobble-gacha-machine") && tableId.method_12832().startsWith("capsules/")) {
                String capsuleType = tableId.method_12832().replace("capsules/", "");
                class_52.class_53 builder = class_52.method_324();
                LootTableAccessor accessor = (LootTableAccessor)table;
                builder.method_334(table.method_322());
                List pools = accessor.fabric_getPools();
                class_55.class_56 pool = FabricLootPoolBuilder.copyOf((class_55)((class_55)pools.getFirst()));
                if (DefaultConfig.isMegashowdownItemsEnabled() && FabricLoader.getInstance().isModLoaded("mega_showdown")) {
                    CobbleGachaMachine.LOGGER.info("Modifying loot table with MegaShowdownPool");
                    ModLootTables.addMegaShowdownPool(pool, capsuleType);
                }
                builder.apply((Collection)accessor.fabric_getFunctions());
                accessor.fabric_getRandomSequenceId().ifPresent(arg_0 -> ((class_52.class_53)builder).method_51883(arg_0));
                builder.pool(pool.method_355());
                return builder.method_338();
            }
            return null;
        });
    }

    private static void addMegaShowdownPool(class_55.class_56 poolBuilder, String capsuleType) {
        switch (capsuleType) {
            case "normal_capsule": {
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:bug_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dark_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dragon_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:electric_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fairy_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fighting_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fire_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:flying_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ghost_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:grass_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ground_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ice_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:normal_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:poison_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:psychic_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rock_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:steel_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:water_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:stellar_tera_shard", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:max_honey", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:max_mushroom", 1, 1);
                break;
            }
            case "rare_capsule": {
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:wellspring_mask", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:cornerstone_mask", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:hearthflame_mask", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:reassembly_unit", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:pink_nectar", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:purple_nectar", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:red_nectar", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:yellow_nectar", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:blue_orb", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:red_orb", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_fan", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_washing_machine", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_fridge", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_mow", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_oven", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:bug_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dark_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dragon_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:electric_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fairy_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fighting_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:fire_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:flying_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ghost_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:grass_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ground_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ice_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:normal_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:poison_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:psychic_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rock_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:steel_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:water_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:stellar_tera_shard", 10, 25);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:max_honey", 2, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:max_mushroom", 2, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:mega_stone", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:sparkling_stone_light", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:sparkling_stone_dark", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dynamax_candy", 1, 2);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:ash_cap", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:max_soup", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:sweet_max_soup", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:zygarde_core", 1, 2);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:zygarde_cell", 1, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:keystone", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:wishing_star", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:blank_z", 1, 1);
                break;
            }
            case "ultra_rare_capsule": {
                String[] megaStones;
                String[] zCrystals;
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:deoxys_meteorite", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dna_splicer", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:gracidea_flower", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:n_lunarizer", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:n_solarizer", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:reins_of_unity", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:reveal_glass", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:zygarde_cube", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:zygarde_core", 5, 5);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:zygarde_cell", 50, 90);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rotom_catalogue", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:tera_orb", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:mega_bracelet", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:z_ring", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:rusted_shield", 1, 1);
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:dynamax_band", 1, 1);
                for (String crystal : zCrystals = new String[]{"aloraichium_z", "decidium_z", "eevium_z", "fairium_z", "fightinium_z", "incinium_z", "kommonium_z", "lunalium_z", "lycanium_z", "marshadium_z", "mewnium_z", "mimikium_z", "pikanium_z", "pikashunium_z", "primarium_z", "snorlium_z", "solganium_z", "tapunium_z", "ultranecrozium_z", "waterium_z", "steelium_z", "rockium_z", "psychium_z", "poisonium_z", "normalium_z", "icium_z", "groundium_z", "grassium_z", "ghostium_z", "flyinium_z", "firium_z", "electrium_z", "dragonium_z", "darkinium_z", "buginium_z"}) {
                    ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:" + crystal, 1, 1);
                }
                for (String megaStone : megaStones = new String[]{"absolite", "aerodactylite", "abomasite", "alakazite", "altarianite", "ampharosite", "audinite", "banettite", "beedrillite", "blastoisinite", "blazikenite", "cameruptite", "charizardite_y", "charizardite_x", "diancite", "galladite", "garchompite", "gardevoirite", "gengarite", "glalitite", "gyaradosite", "heracronite", "houndoominite", "kangaskhanite", "latiasite", "latiosite", "lopunnite", "lucarionite", "manectite", "mawilite", "medichamite", "metagrossite", "mewtwonite_y", "mewtwonite_x", "pidgeotite", "pinsirite", "sablenite", "salamencite", "scizorite", "sceptilite", "sharpedonite", "slowbronite", "steelixite", "swampertite", "tyranitarite", "venusaurite"}) {
                    ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:" + megaStone, 1, 1);
                }
                ModLootTables.addItemWithCount(poolBuilder, "mega_showdown:prison_bottle", 1, 1);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void addItemWithCount(class_55.class_56 poolBuilder, String itemId, int minCount, int maxCount) {
        class_85.class_86 itemBuilder = class_77.method_411((class_1935)((class_1935)class_7923.field_41178.method_10223(class_2960.method_60654((String)itemId))));
        if (minCount == maxCount) {
            if (minCount != 1) {
                itemBuilder.method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)minCount)));
            }
        } else {
            itemBuilder.method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)minCount, (float)maxCount)));
        }
        poolBuilder.method_351((class_79.class_80)itemBuilder);
    }

    public static void register() {
        CobbleGachaMachine.LOGGER.info("Registering custom loot tables");
        CAPSULE = ModLootTables.registerLootContext(class_2960.method_60655((String)"cobble-gacha-machine", (String)"capsule"), builder -> builder.method_781(class_181.field_24424).method_780(class_181.field_1226));
        ModLootTables.registerModifiers();
    }
}

