/*
 * Decompiled with CFR 0.152.
 */
package com.cristoh.cobblegachamachine;

import com.cristoh.cobblegachamachine.ModLootTables;
import com.cristoh.cobblegachamachine.block.ModBlocks;
import com.cristoh.cobblegachamachine.block.entity.ModBlockEntities;
import com.cristoh.cobblegachamachine.command.GachaCommand;
import com.cristoh.cobblegachamachine.config.DefaultConfig;
import com.cristoh.cobblegachamachine.item.ModItemGroups;
import com.cristoh.cobblegachamachine.item.ModItems;
import com.cristoh.cobblegachamachine.sound.ModSounds;
import com.cristoh.cobblegachamachine.sound.PlayCoinInsertSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayDialSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayDispenseSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayRewardLegendarySoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayRewardNormalSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayRewardRareSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlayRewardUltraRareSoundPayload;
import com.cristoh.cobblegachamachine.sound.PlaySpinSoundPayload;
import com.cristoh.cobblegachamachine.ui.GachaUIManager;
import com.mojang.brigadier.CommandDispatcher;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CobbleGachaMachine
implements ModInitializer {
    public static final String MOD_ID = "cobble-gacha-machine";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cobble-gacha-machine");

    public void onInitialize() {
        ModLootTables.register();
        DefaultConfig.loadConfig(FabricLoader.getInstance().getConfigDir());
        ModSounds.register();
        ModItems.register();
        ModBlocks.register();
        ModItemGroups.register();
        ModBlockEntities.register();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> GachaCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                GachaUIManager.tick(player);
            }
        });
        ServerPlayerEvents.LEAVE.register(player -> GachaUIManager.removeSession(player.method_5667()));
        PayloadTypeRegistry.playS2C().register(PlaySpinSoundPayload.ID, PlaySpinSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayCoinInsertSoundPayload.ID, PlayCoinInsertSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayDialSoundPayload.ID, PlayDialSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayDispenseSoundPayload.ID, PlayDispenseSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayRewardNormalSoundPayload.ID, PlayRewardNormalSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayRewardRareSoundPayload.ID, PlayRewardRareSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayRewardUltraRareSoundPayload.ID, PlayRewardUltraRareSoundPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(PlayRewardLegendarySoundPayload.ID, PlayRewardLegendarySoundPayload.CODEC);
    }
}

