/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import snownee.lightingwand.CoreModule;

public class RepairRecipe
extends class_1852 {
    private final String group;
    private final class_1792 repairable;
    private final class_1856 material;
    private final double ratio;

    public RepairRecipe(class_7710 category, String group, class_1792 repairable, class_1856 material, double ratio) {
        super(category);
        this.group = group;
        this.repairable = repairable;
        this.material = material;
        this.ratio = ratio;
        if (!repairable.method_57347().method_57832(class_9334.field_50072)) {
            throw new IllegalArgumentException(String.format("Item %s is not repairable", repairable));
        }
    }

    public boolean method_8113(int width, int height) {
        return width > 1 || height > 1;
    }

    public boolean matches(class_9694 input, class_1937 worldIn) {
        int dust = 0;
        class_1799 wand = class_1799.field_8037;
        for (int i = 0; i < input.method_59983(); ++i) {
            class_1799 itemstack = input.method_59984(i);
            if (itemstack.method_7909() == this.repairable && itemstack.method_7919() != 0) {
                if (wand.method_7960()) {
                    wand = itemstack;
                    continue;
                }
                return false;
            }
            if (!itemstack.method_7960() && this.material.method_8093(itemstack)) {
                ++dust;
                continue;
            }
            if (itemstack == class_1799.field_8037) continue;
            return false;
        }
        return !wand.method_7960() && dust > 0 && wand.method_7919() - class_3532.method_15384((double)((double)wand.method_7936() / this.ratio)) * dust > -class_3532.method_15384((double)((double)wand.method_7936() / this.ratio));
    }

    public class_1799 assemble(class_9694 input, class_7225.class_7874 provider) {
        int dust = 0;
        class_1799 wand = class_1799.field_8037;
        for (int i = 0; i < input.method_59983(); ++i) {
            int count;
            class_1799 itemstack = input.method_59984(i);
            if (itemstack.method_31574(this.repairable)) {
                wand = itemstack;
                continue;
            }
            if (itemstack.method_7960() || !this.material.method_8093(itemstack) || (count = itemstack.method_7947()) <= 0) continue;
            ++dust;
        }
        int damage = class_3532.method_15340((int)(wand.method_7919() - class_3532.method_15384((double)((double)wand.method_7936() / this.ratio)) * dust), (int)0, (int)wand.method_7936());
        class_1799 result = wand.method_7972();
        result.method_7939(1);
        result.method_7974(damage);
        return result;
    }

    public class_1865<?> method_8119() {
        return (class_1865)CoreModule.REPAIR.get();
    }

    public String method_8112() {
        return this.group;
    }

    public class_1856 material() {
        return this.material;
    }

    public class_1792 repairable() {
        return this.repairable;
    }

    public double ratio() {
        return this.ratio;
    }

    public static class Serializer
    implements class_1865<RepairRecipe> {
        public static final MapCodec<RepairRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1852::method_45441), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(RepairRecipe::method_8112), (App)class_7923.field_41178.method_39673().fieldOf("repairable").forGetter(RepairRecipe::repairable), (App)class_1856.field_46096.fieldOf("material").forGetter(RepairRecipe::material), (App)Codec.DOUBLE.fieldOf("ratio").forGetter(RepairRecipe::ratio)).apply((Applicative)instance, RepairRecipe::new));
        public static final class_9139<class_9129, RepairRecipe> STREAM_CODEC = class_9139.method_56906((class_9139)class_7710.field_48353, class_1852::method_45441, (class_9139)class_9135.field_48554, RepairRecipe::method_8112, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), RepairRecipe::repairable, (class_9139)class_1856.field_48355, RepairRecipe::material, (class_9139)class_9135.field_48553, RepairRecipe::ratio, RepairRecipe::new);

        public MapCodec<RepairRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, RepairRecipe> method_56104() {
            return STREAM_CODEC;
        }
    }
}

