/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand;

import org.joml.Vector3f;
import snownee.kiwi.config.KiwiConfig;
import snownee.lightingwand.LW;

@KiwiConfig
public class CommonConfig {
    @KiwiConfig.GameRestart
    public static boolean shootProjectile = true;
    @KiwiConfig.Range(min=0.0)
    public static int energyPerUse = 200;
    public static boolean repairRecipe = true;
    @KiwiConfig.GameRestart
    @KiwiConfig.Range(min=1.0)
    public static int wandDurability = 255;
    public static int defaultLightColor = -683;
    public static Vector3f defaultLightColorVector = new Vector3f();

    @KiwiConfig.Listen(value="defaultLightColor")
    public static void updateColorVector(String path) {
        LW.LOGGER.debug("Updating default light color vector");
        defaultLightColorVector = CommonConfig.intColorToVector3(defaultLightColor);
    }

    public static Vector3f intColorToVector3(int color) {
        if (color == 0) {
            return defaultLightColorVector;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new Vector3f(r, g, b);
    }

    static {
        CommonConfig.updateColorVector(null);
    }
}

