/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import commonnetwork.networking.data.PacketContext;
import commonnetwork.networking.data.Side;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import journeymap.common.Journeymap;
import journeymap.common.version.Version;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7439;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class HandshakePacket {
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"journeymap", (String)"version");
    public static final class_9139<class_9129, HandshakePacket> STREAM_CODEC = class_9139.method_56438(HandshakePacket::encode, HandshakePacket::new);
    private String version;

    public HandshakePacket() {
    }

    public HandshakePacket(String version) {
        this.version = version;
    }

    public HandshakePacket(class_9129 buf) {
        try {
            if (buf.readableBytes() > 1) {
                this.version = buf.method_10800(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for handshake: %s", t));
        }
    }

    public static class_8710.class_9154<class_8710> type() {
        return new class_8710.class_9154(CHANNEL);
    }

    private void encode(class_9129 buf) {
        try {
            buf.method_10814(this.version);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message for handshake: " + String.valueOf(t));
        }
    }

    public static void handle(PacketContext<HandshakePacket> ctx) {
        String jsonString = ((HandshakePacket)ctx.message()).version;
        try {
            Version otherVersion = Version.fromJson(jsonString);
            if (Side.CLIENT == ctx.side()) {
                if (!otherVersion.isValid(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION, ctx.side())) {
                    String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_SERVER_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> " + String.valueOf(otherVersion);
                    class_310.method_1551().field_1724.field_3944.method_48296().method_10747((class_2561)class_2561.method_43470((String)message));
                }
            } else if (otherVersion.isValid(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION, ctx.side())) {
                Journeymap.getInstance().getDispatcher().sendHandshakePacket(ctx.sender(), Journeymap.JM_VERSION.toJson());
            } else {
                String message = "Journeymap Version Mismatch need at least " + String.valueOf(Journeymap.MINIMUM_CLIENT_ACCEPTABLE_VERSION) + " or higher. Current " + String.valueOf(ctx.side().opposite()) + " version attempt -> " + String.valueOf(otherVersion);
                HandshakePacket.disconnect(ctx.sender(), message);
            }
        }
        catch (Exception e) {
            String message = "Error: Likely due to version mismatch " + String.valueOf(ctx.side()) + " is running:" + String.valueOf(Journeymap.JM_VERSION) + " Exception:" + String.valueOf(e);
            HandshakePacket.disconnect(ctx.sender(), message + String.valueOf(e));
        }
    }

    public static void disconnect(class_3222 player, String message) {
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
        class_5250 text = class_2561.method_43470((String)message);
        player.field_13987.method_14364((class_2596)new class_7439((class_2561)text, false));
        executorService.schedule(() -> HandshakePacket.lambda$disconnect$0(player, (class_2561)text), 1L, TimeUnit.SECONDS);
    }

    private static /* synthetic */ void lambda$disconnect$0(class_3222 player, class_2561 text) {
        player.field_13987.method_52396(text);
    }
}

