/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import journeymap.common.Journeymap;
import journeymap.common.nbt.cache.CacheFile;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_5127;
import org.jetbrains.annotations.Nullable;

public class CacheFileStorage
implements AutoCloseable {
    public static final String EXTENSION = ".mca";
    private static final int MAX_CACHE_SIZE = 256;
    private final Long2ObjectLinkedOpenHashMap<CacheFile> cache = new Long2ObjectLinkedOpenHashMap();
    private final Path folderPath;
    private final boolean sync;

    CacheFileStorage(Path folderPath, boolean sync) {
        this.folderPath = folderPath;
        this.sync = sync;
    }

    private CacheFile getCacheFile(class_1923 chunkPos) throws IOException {
        long i = class_1923.method_8331((int)chunkPos.method_17885(), (int)chunkPos.method_17886());
        CacheFile cacheFile = (CacheFile)this.cache.getAndMoveToFirst(i);
        if (cacheFile == null) {
            if (this.cache.size() >= 256) {
                ((CacheFile)this.cache.removeLast()).close();
            }
            Files.createDirectories(this.folderPath, new FileAttribute[0]);
            Path path = this.folderPath.resolve("r." + chunkPos.method_17885() + "." + chunkPos.method_17886() + EXTENSION);
            cacheFile = new CacheFile(path, this.folderPath, this.sync);
            this.cache.putAndMoveToFirst(i, (Object)cacheFile);
        }
        return cacheFile;
    }

    @Nullable
    public class_2487 read(class_1923 chunkPos) throws IOException {
        block5: {
            class_2487 tag;
            CacheFile cacheFile = this.getCacheFile(chunkPos);
            DataInputStream chunkDataInputStream = cacheFile.getChunkDataInputStream(chunkPos);
            try {
                if (chunkDataInputStream == null) {
                    Object tag2 = null;
                    break block5;
                }
                tag = class_2507.method_10627((DataInput)chunkDataInputStream);
            }
            catch (Throwable t) {
                Journeymap.getLogger().error("Error reading chunk for ChunkPos {}", (Object)chunkPos);
                try {
                    chunkDataInputStream.close();
                }
                catch (Throwable t2) {
                    Journeymap.getLogger().error("Error closing stream on chunk error {}", (Object)chunkPos);
                    t.addSuppressed(t2);
                }
                return null;
            }
            chunkDataInputStream.close();
            return tag;
        }
        return null;
    }

    public boolean hasChunk(class_1923 pos) {
        try {
            CacheFile cacheFile = this.getCacheFile(pos);
            return cacheFile.hasChunk(pos);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void write(class_1923 chunkPos, @Nullable class_2487 tag) throws IOException {
        CacheFile cacheFile = this.getCacheFile(chunkPos);
        if (tag == null) {
            cacheFile.clear(chunkPos);
        } else {
            try (DataOutputStream chunkDataInputStream = cacheFile.getChunkDataOutputStream(chunkPos);){
                class_2507.method_10628((class_2487)tag, (DataOutput)chunkDataInputStream);
            }
        }
    }

    @Override
    public void close() throws IOException {
        class_5127 collector = new class_5127();
        for (CacheFile cacheFile : this.cache.values()) {
            try {
                cacheFile.close();
            }
            catch (IOException e) {
                collector.method_26807((Throwable)e);
            }
        }
        collector.method_26806();
    }

    public void flush() throws IOException {
        for (CacheFile cacheFile : this.cache.values()) {
            cacheFile.flush();
        }
    }
}

