/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.util.Collection;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.util.PermissionsManager;
import journeymap.common.waypoint.WaypointImpl;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2177;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class CreateWaypoint {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jm").then(CreateWaypoint.waypointCommand("waypoint"))).then(CreateWaypoint.waypointCommand("wp")));
    }

    private static LiteralArgumentBuilder<class_2168> createSub(boolean temp) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)"create").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).then(class_2170.method_9244((String)"color", (ArgumentType)class_2177.method_9276()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(ctx -> CreateWaypoint.createWaypoint((class_2168)ctx.getSource(), class_2186.method_9312((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), class_2277.method_9734((CommandContext)ctx, (String)"location"), class_2177.method_9277((CommandContext)ctx, (String)"color"), false, temp))).then(class_2170.method_9244((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.createWaypoint((class_2168)ctx.getSource(), class_2186.method_9312((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), class_2181.method_9289((CommandContext)ctx, (String)"dimension"), class_2277.method_9734((CommandContext)ctx, (String)"location"), class_2177.method_9277((CommandContext)ctx, (String)"color"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce"), temp))))))));
    }

    private static LiteralArgumentBuilder<class_2168> waypointCommand(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(CreateWaypoint::canUseCommand)).then(CreateWaypoint.createSub(false))).then(class_2170.method_9247((String)"temp").then(CreateWaypoint.createSub(true)))).then(class_2170.method_9247((String)"delete").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(ctx -> CreateWaypoint.deleteWaypoint(class_2186.method_9312((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false))).then(class_2170.method_9244((String)"announce", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CreateWaypoint.deleteWaypoint(class_2186.method_9312((CommandContext)ctx, (String)"players"), StringArgumentType.getString((CommandContext)ctx, (String)"name"), BoolArgumentType.getBool((CommandContext)ctx, (String)"announce")))))));
    }

    private static boolean canUseCommand(class_2168 ctx) {
        try {
            return ctx.method_9259(2) || ctx.method_9228() != null && ctx.method_43737() && PermissionsManager.getInstance().canServerAdmin((class_3222)ctx.method_9228()) || !ctx.method_9211().method_3816();
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static int deleteWaypoint(Collection<class_3222> players, String name, boolean announce) {
        WaypointImpl ext = new WaypointImpl(name, "null");
        CreateWaypoint.sendPacket(players, ext, "delete", announce);
        return 1;
    }

    private static int createWaypoint(class_2168 source, Collection<class_3222> players, String name, class_3218 dimension, class_2267 location, class_124 textFormatting, boolean announce, boolean temp) {
        try {
            Waypoint waypoint = WaypointFactoryImpl.createCommandWaypoint("journeymap", location.method_9704(source), name, dimension.method_27983().method_29177().toString(), false, false, new Color(textFormatting.method_532()).getRGB(), true, temp);
            CreateWaypoint.sendPacket(players, new WaypointImpl((WaypointImpl)waypoint), "create", announce);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error creating waypoint from command.", t);
        }
        return 1;
    }

    private static void sendPacket(Collection<class_3222> players, WaypointImpl wp, String action, boolean announce) {
        wp.setOrigin("command");
        players.forEach(player -> Journeymap.getInstance().getDispatcher().sendWaypointPacket((class_3222)player, wp.toString(), announce, action));
    }
}

