/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.UUID;
import journeymap.client.texture.HttpTextureAccess;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureCache;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1060;
import net.minecraft.class_2631;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;

public class IgnSkin {
    private static final Map<UUID, class_1043> faceImageCache = Maps.newHashMap();
    private static final Map<UUID, class_640> playerInfoMap = Maps.newHashMap();
    private static final class_1043 DEFAULT_SKIN = IgnSkin.getDefaultSkin();

    public static class_1043 getFace(GameProfile profile) {
        class_1043 face = faceImageCache.get(profile.getId());
        if (face == null) {
            class_2631.method_59539((UUID)profile.getId()).thenAccept(optional -> {
                GameProfile gameProfile = optional.orElse(profile);
                faceImageCache.put(profile.getId(), IgnSkin.getSkin(gameProfile));
            });
            return DEFAULT_SKIN;
        }
        return face;
    }

    private static class_1043 getSkin(GameProfile profile) {
        try {
            class_1060 textureManager;
            class_1044 texture;
            class_640 playerInfo = playerInfoMap.computeIfAbsent(profile.getId(), k -> new class_640(profile, false));
            class_8685 skin = playerInfo.method_52810();
            if (skin != null && (texture = (textureManager = class_310.method_1551().method_1531()).method_34590(skin.comp_1626(), null)) != null && texture instanceof class_1046) {
                class_1046 httpTexture = (class_1046)texture;
                HttpTextureAccess tex = (HttpTextureAccess)httpTexture;
                class_1011 img = tex.journeymap$getNativeImage();
                return IgnSkin.cropToFace(img);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static class_1043 getDefaultSkin() {
        try {
            class_1043 texture = TextureCache.getTexture(class_2960.method_60656((String)"textures/entity/player/wide/steve.png"));
            if (texture != null && texture instanceof class_1043) {
                class_1043 tex = texture;
                return IgnSkin.cropToFace(tex.method_4525());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new class_1043(ImageUtil.getNewBlankImage(24, 24));
    }

    public static class_1043 cropToFace(class_1011 playerSkin) {
        class_1011 skin = new class_1011(playerSkin.method_4307(), playerSkin.method_4323(), false);
        skin.method_4317(playerSkin);
        if (skin != null && skin.field_4988 != 0L) {
            if (skin.method_4318().method_4329()) {
                class_1011 hat = ImageUtil.getSubImage(40, 8, 8, 8, skin, false);
                for (int x = 0; x < 8; ++x) {
                    for (int y = 0; y < 8; ++y) {
                        int hatPixel = hat.method_4315(x, y);
                        skin.method_35624(x + 8, y + 8, hatPixel);
                    }
                }
                hat.close();
            }
            class_1011 sub = ImageUtil.getSubImage(8, 8, 8, 8, skin, false);
            return new class_1043(ImageUtil.getSizedImage(24, 24, sub, false));
        }
        return new class_1043(ImageUtil.getNewBlankImage(24, 24));
    }
}

