/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.google.common.cache.CacheLoader;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.model.MapImage;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.BaseOverlayDrawStep;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.map.Renderer;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class DrawMarkerStep
extends BaseOverlayDrawStep<MarkerOverlay> {
    private Point2D.Double markerPosition;
    private class_1044 iconTexture;
    private boolean hasError;

    public DrawMarkerStep(MarkerOverlay marker) {
        super(marker);
    }

    @Override
    public void draw(class_332 graphics, class_4597 buffers, DrawStep.Pass pass, double xOffset, double yOffset, Renderer renderer, double fontScale, double rotation) {
        if (!this.isOnScreen(xOffset, yOffset, renderer, rotation)) {
            return;
        }
        if (pass == DrawStep.Pass.Object) {
            this.ensureTexture();
            if (!this.hasError && this.iconTexture != null && ((TextureAccess)this.iconTexture).journeymap$hasImage()) {
                MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
                class_1921 renderType = icon.isBlur() ? JMRenderTypes.getIcon(this.iconTexture) : JMRenderTypes.getIconNoBlur(this.iconTexture);
                class_4588 vertexBuilder = buffers.getBuffer(renderType);
                double minU = (double)icon.getTextureX() / (double)((TextureAccess)this.iconTexture).journeymap$getWidth();
                double minV = (double)icon.getTextureY() / (double)((TextureAccess)this.iconTexture).journeymap$getHeight();
                DrawUtil.drawQuad(graphics, vertexBuilder, icon.getColor(), icon.getOpacity(), this.markerPosition.x + xOffset - icon.getAnchorX(), this.markerPosition.y + yOffset - icon.getAnchorY(), icon.getDisplayWidth(), icon.getDisplayHeight(), minU, minV, minU + (double)icon.getTextureWidth() / (double)((TextureAccess)this.iconTexture).journeymap$getWidth(), minV + (double)icon.getTextureHeight() / (double)((TextureAccess)this.iconTexture).journeymap$getHeight(), (double)icon.getRotation() - rotation, false);
            }
        } else if (pass == DrawStep.Pass.Text || pass == DrawStep.Pass.Tooltip) {
            super.drawText(graphics, pass, xOffset, yOffset, renderer, fontScale, rotation);
        }
    }

    protected void ensureTexture() {
        if (this.iconTexture != null) {
            return;
        }
        try {
            MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
            if (icon.getImageLocation() != null) {
                this.iconTexture = TextureCache.getTexture(icon.getImageLocation());
            } else if (icon.getImage() != null) {
                class_1043 texture = new class_1043(icon.getImage());
                this.iconTexture = texture;
            }
            this.iconTexture.method_23207();
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error getting MarkerOverlay image upperTexture: " + String.valueOf(e), (Throwable)e);
            this.hasError = true;
        }
    }

    @Override
    protected void updatePositions(Renderer renderer, double rotation) {
        int yShift;
        MapImage icon = ((MarkerOverlay)this.overlay).getIcon();
        this.markerPosition = renderer.getBlockPixelInGrid(((MarkerOverlay)this.overlay).getPoint());
        int halfBlock = (int)this.lastUiState.blockSize / 2;
        this.markerPosition.setLocation(this.markerPosition.x + (double)halfBlock, this.markerPosition.y + (double)halfBlock);
        TextProperties textProperties = ((MarkerOverlay)this.overlay).getTextProperties();
        int xShift = rotation % 360.0 == 0.0 ? -textProperties.getOffsetX() : textProperties.getOffsetX();
        int n = yShift = rotation % 360.0 == 0.0 ? -textProperties.getOffsetY() : textProperties.getOffsetY();
        if (xShift != 0 || yShift != 0) {
            Point2D shiftedPoint = renderer.shiftWindowPosition(this.markerPosition.x, this.markerPosition.y, xShift, yShift);
            this.labelPosition.setLocation(shiftedPoint.getX(), shiftedPoint.getY());
        } else {
            this.labelPosition.setLocation(this.markerPosition.x, this.markerPosition.y);
        }
        this.screenBounds.setRect(this.markerPosition.x, this.markerPosition.y, this.lastUiState.blockSize, this.lastUiState.blockSize);
        this.screenBounds.add(this.labelPosition);
        Rectangle2D.Double iconBounds = new Rectangle2D.Double(this.markerPosition.x - icon.getAnchorX(), this.markerPosition.y - icon.getAnchorY(), icon.getDisplayWidth(), icon.getDisplayHeight());
        this.screenBounds.add(iconBounds);
    }

    public static class SimpleCacheLoader
    extends CacheLoader<MarkerOverlay, DrawMarkerStep> {
        public DrawMarkerStep load(MarkerOverlay overlay) throws Exception {
            return new DrawMarkerStep(overlay);
        }
    }
}

