/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.OptionalDouble;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.client.JourneymapClient;
import journeymap.client.render.RegionTileShaders;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.RegionTexture;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_5944;

public class JMRenderTypes
extends class_1921 {
    public static final class_2960 WAYPOINT_DEFAULT_BEAM = class_2960.method_60654((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<class_2960, class_1921> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<class_1921>> REGION_TILE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_NOBLUR_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<class_1921> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    public static class_4668.class_5942 POSITION_TEX_COLOR_SHADER;
    static final Object2ObjectOpenHashMap<String, class_4668.class_5942> REGION_SHADERS_MAP;
    protected static final class_4668.class_4685 GRID_LINES_TRANSPARENCY;
    protected static final class_4668.class_4684 MINIMAP_MASK_TRANSPARENCY;
    protected static final class_4668.class_4685 ICON_TRANSPARENCY;
    protected static final class_4668.class_4685 POLYGON_TRANSPARENCY;
    public static final class_1921 MINIMAP_RECTANGLE_MASK_RENDER_TYPE;
    public static final class_1921 BEAM_RENDER_TYPE;
    public static final class_1921 RECTANGLE_RENDER_TYPE;
    public static final class_1921 GRID_LINES_RENDER_TYPE;
    public static final class_1921 POLYGON_WITHOUT_TEXTURE_RENDER_TYPE;
    public static final class_1921 POLYGON_STROKE_RENDER_TYPE;

    public static void registerMapShader(String key, class_5944 shader) {
        REGION_SHADERS_MAP.put((Object)key, (Object)new class_4668.class_5942(() -> shader));
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader(class_5944 shader) {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_NOBLUR_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
        POSITION_TEX_COLOR_SHADER = new class_4668.class_5942(() -> shader);
    }

    public JMRenderTypes(String name, class_293 vertexFormat, class_293.class_5596 drawMode, int bufferSize, boolean useDelegate, boolean needsSorting, Runnable pre, Runnable post) {
        super(name, vertexFormat, drawMode, bufferSize, useDelegate, needsSorting, pre, post);
    }

    public static void clearRegionRenderTypes(int id) {
        if (id != -1) {
            Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
            if (map != null) {
                map.clear();
            }
            REGION_TILE_RENDER_TYPE_MAP.remove(id);
        }
    }

    public static class_1921 getGridLines(class_2960 resourceLocation) {
        class_1921 type = (class_1921)GRID_LINES_RENDER_TYPE_MAP.get((Object)resourceLocation);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("grid_lines" + resourceLocation.method_36181()), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(resourceLocation, false, false)).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(GRID_LINES_TRANSPARENCY).method_23608(field_21384).method_23603(field_21345).method_23616(field_21350).method_34578(POSITION_TEX_COLOR_SHADER).method_23617(false));
            GRID_LINES_RENDER_TYPE_MAP.put((Object)resourceLocation, (Object)type);
        }
        return type;
    }

    public static class_1921 getRegionTile(RegionTexture texture, int shaderIndex) {
        class_1921 type;
        int id = texture.method_4624();
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            REGION_TILE_RENDER_TYPE_MAP.put(id, (Object)map);
        }
        if ((type = (class_1921)map.get(shaderIndex)) == null) {
            String shader = RegionTileShaders.from(shaderIndex);
            class_4668.class_5942 shaderState = REGION_SHADERS_MAP.get((Object)shader) == null ? POSITION_TEX_COLOR_SHADER : (class_4668.class_5942)REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.method_24049((String)("region_tile" + id), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new RegionTileStateShard(id)).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(field_21370).method_23608(field_21384).method_23603(field_21345).method_23616(field_21350).method_34578(shaderState).method_23617(false));
            map.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getMinimapCircleMask(class_1044 texture) {
        return JMRenderTypes.method_24049((String)"minimap_circle_mask", (class_293)class_290.field_1585, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(new class_4668.class_5939(() -> {
            RenderWrapper.bindTexture(texture.method_4624());
            RenderWrapper.setShaderTexture(0, texture.method_4624());
        }, () -> {})).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(field_21364).method_23608(field_21384).method_23603(field_21345).method_23614(MINIMAP_MASK_TRANSPARENCY).method_23616(field_21351).method_34578(field_29440).method_23617(false));
    }

    public static class_1921 getIcon(class_1044 texture) {
        int id = texture.method_4624();
        class_1921 type = (class_1921)ICON_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon" + id), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(id)).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(ICON_TRANSPARENCY).method_23608(field_21384).method_23603(field_21345).method_23616(field_21349).method_34578(POSITION_TEX_COLOR_SHADER).method_23617(false));
            ICON_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getIconNoBlur(class_1044 texture) {
        int id = texture.method_4624();
        class_1921 type = (class_1921)ICON_NOBLUR_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon" + id), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(id, false)).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(ICON_TRANSPARENCY).method_23608(field_21384).method_23603(field_21345).method_23616(field_21349).method_34578(POSITION_TEX_COLOR_SHADER).method_23617(false));
            ICON_NOBLUR_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getIconUnmasked(class_1044 texture) {
        int id = texture.method_4624();
        class_1921 type = (class_1921)ICON_UNMASKED_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("icon_unmasked" + id), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new IconStateShard(id)).method_23604(field_21346).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(ICON_TRANSPARENCY).method_23608(field_21384).method_23603(field_21345).method_23616(field_21350).method_34578(POSITION_TEX_COLOR_SHADER).method_23617(false));
            ICON_UNMASKED_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    public static class_1921 getPolygonWithTexture(class_1044 texture) {
        int id = texture.method_4624();
        class_1921 type = (class_1921)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get(id);
        if (type == null) {
            type = JMRenderTypes.method_24049((String)("polygon" + id), (class_293)class_290.field_1575, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(new class_4668.class_5939(() -> {
                RenderWrapper.bindTexture(id);
                RenderWrapper.setShaderTexture(0, id);
            }, () -> {})).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(POLYGON_TRANSPARENCY).method_23608(field_21384).method_23603(field_21345).method_23616(field_21350).method_34578(POSITION_TEX_COLOR_SHADER).method_23617(false));
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put(id, (Object)type);
        }
        return type;
    }

    static {
        REGION_SHADERS_MAP = (Object2ObjectOpenHashMap)class_156.method_656(() -> {
            Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
            map.put((Object)"default", (Object)POSITION_TEX_COLOR_SHADER);
            return map;
        });
        GRID_LINES_TRANSPARENCY = new class_4668.class_4685("grid_lines_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 771);
            RenderWrapper.texParameter(3553, 10241, 9728);
            RenderWrapper.texParameter(3553, 10240, 9728);
            RenderWrapper.texParameter(3553, 10242, 10497);
            RenderWrapper.texParameter(3553, 10243, 10497);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        MINIMAP_MASK_TRANSPARENCY = new class_4668.class_4684("minimap_mask_texturing", () -> {
            RenderSystem.clearDepth((double)0.0);
            RenderWrapper.clear(256);
            RenderSystem.clearDepth((double)1.0);
            RenderWrapper.depthFunc(519);
        }, () -> RenderWrapper.depthFunc(515));
        ICON_TRANSPARENCY = new class_4668.class_4685("icon_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        POLYGON_TRANSPARENCY = new class_4668.class_4685("polygon_transparency", () -> {
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
            RenderWrapper.texParameter(3553, 10241, 9728);
            RenderWrapper.texParameter(3553, 10240, 9728);
            RenderWrapper.texParameter(3553, 10242, 10497);
            RenderWrapper.texParameter(3553, 10243, 10497);
        }, () -> {
            RenderWrapper.disableBlend();
            RenderWrapper.defaultBlendFunc();
        });
        MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.method_24049((String)"minimap_rectangle_mask", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(field_21364).method_23608(field_21384).method_23603(field_21345).method_23614(MINIMAP_MASK_TRANSPARENCY).method_23616(field_21351).method_34578(field_29442).method_23617(false));
        BEAM_RENDER_TYPE = JMRenderTypes.method_24049((String)"waypoint_beam", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(WAYPOINT_DEFAULT_BEAM, true, false)).method_23603(field_21344).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(field_21370).method_23608(field_21383).method_23616(field_21350).method_34578(field_29441).method_23617(false));
        RECTANGLE_RENDER_TYPE = JMRenderTypes.method_24049((String)"rectangle", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23604(field_21348).method_23603(field_21345).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(field_21370).method_23608(field_21384).method_23616(field_21349).method_34578(field_29442).method_23617(false));
        GRID_LINES_RENDER_TYPE = JMRenderTypes.method_24049((String)"grid_lines", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_29344, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23604(field_21348).method_23609(new class_4668.class_4677(OptionalDouble.of(1.0))).method_23607(field_21352).method_23615(field_21370).method_23608(field_21384).method_23603(field_21345).method_23616(field_21350).method_34578(field_29442).method_23617(false));
        POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.method_24049((String)"polygon", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27379, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23604(field_21348).method_23603(field_21345).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(POLYGON_TRANSPARENCY).method_23608(field_21384).method_23616(field_21350).method_34578(field_29442).method_23617(false));
        POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.method_24049((String)"polygon_stroke", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27380, (int)256, (boolean)false, (boolean)false, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577(field_21378).method_23604(field_21348).method_23603(field_21345).method_23609(new class_4668.class_4677(OptionalDouble.empty())).method_23607(field_21352).method_23615(POLYGON_TRANSPARENCY).method_23608(field_21384).method_23616(field_21350).method_34578(field_29442).method_23617(false));
    }

    protected static class RegionTileStateShard
    extends class_4668.class_5939 {
        private final int textureId;

        public RegionTileStateShard(int textureId) {
            super(() -> {
                boolean blur = false;
                if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Fullscreen) {
                    blur = JourneymapClient.getInstance().getFullMapProperties().zoomLevel.get() < 512;
                } else if (ClientAPI.INSTANCE.getLastUIState().ui == Context.UI.Minimap) {
                    blur = JourneymapClient.getInstance().getActiveMiniMapProperties().zoomLevel.get() < 512;
                }
                int mipmapLevels = JourneymapClient.getInstance().getCoreProperties().mipmapLevels.get();
                int mag = mipmapLevels == 0 && blur ? 9729 : 9984;
                int min = mipmapLevels == 0 && blur ? 9729 : 9728;
                RenderWrapper.bindTexture(textureId);
                RenderWrapper.texParameter(3553, 10241, mag);
                RenderWrapper.texParameter(3553, 10240, min);
                RenderWrapper.texParameter(3553, 10242, 33071);
                RenderWrapper.texParameter(3553, 10243, 33071);
                RenderWrapper.texParameter(3553, 33085, mipmapLevels);
                RenderWrapper.texParameter(3553, 33082, 0);
                RenderWrapper.texParameter(3553, 33083, mipmapLevels);
                RenderWrapper.texParameter(3553, 34049, 0);
                RenderWrapper.setShaderTexture(0, textureId);
            }, () -> {});
            this.textureId = textureId;
        }

        public String toString() {
            return this.field_21363 + "[" + this.textureId + ")]";
        }
    }

    protected static class IconStateShard
    extends class_4668.class_5939 {
        private final int textureId;
        private final boolean blur;

        public IconStateShard(int textureId) {
            this(textureId, true);
        }

        public IconStateShard(int textureId, boolean blur) {
            super(() -> {
                RenderWrapper.bindTexture(textureId);
                RenderWrapper.texParameter(3553, 10241, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10240, blur ? 9729 : 9728);
                RenderWrapper.texParameter(3553, 10242, 10497);
                RenderWrapper.texParameter(3553, 10243, 10497);
                RenderWrapper.setShaderTexture(0, textureId);
            }, () -> {});
            this.blur = blur;
            this.textureId = textureId;
        }

        public String toString() {
            return this.field_21363 + "[" + this.textureId + ")]";
        }
    }
}

