/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.region;

import java.io.File;
import java.util.Objects;
import java.util.StringJoiner;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.model.region.RegionImageSet;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class RegionKey {
    private final File worldDir;
    private final int regionX;
    private final int regionZ;
    private final class_5321<class_1937> dimension;
    private final String mapTypeKey;

    private RegionKey(File worldDir, int regionX, int regionZ, MapType mapType, class_5321<class_1937> dimension) {
        this.worldDir = worldDir;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.dimension = dimension;
        this.mapTypeKey = mapType.toCacheKey();
    }

    public static RegionKey from(RegionCoord rCoord, MapType mapType) {
        return new RegionKey(rCoord.worldDir, rCoord.regionX, rCoord.regionZ, mapType, rCoord.dimension);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionKey key = (RegionKey)o;
        if (this.dimension != key.dimension) {
            return false;
        }
        if (this.regionX != key.regionX) {
            return false;
        }
        if (this.regionZ != key.regionZ) {
            return false;
        }
        if (!Objects.equals(this.mapTypeKey, key.mapTypeKey)) {
            return false;
        }
        return this.worldDir.equals(key.worldDir);
    }

    public int hashCode() {
        int result = this.worldDir.hashCode();
        result = 31 * result + this.regionX;
        result = 31 * result + this.regionZ;
        result = 31 * result + this.dimension.hashCode();
        return result;
    }

    public String toString() {
        return new StringJoiner(", ", RegionImageSet.Key.class.getSimpleName() + "[", "]").add("worldDir=" + String.valueOf(this.worldDir)).add("regionX=" + this.regionX).add("regionZ=" + this.regionZ).add("dimension=" + String.valueOf(this.dimension)).toString();
    }
}

