/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.EnumSet;

public enum BlockFlag {
    Ignore("jm.common.block_flag.ignore"),
    Foliage("jm.common.block_flag.foliage"),
    Grass("jm.common.block_flag.grass"),
    Water("jm.common.block_flag.water"),
    Fluid("jm.common.block_flag.fluid"),
    OpenToSky("jm.common.block_flag.openToSky"),
    NoShadow("jm.common.block_flag.noShadow"),
    Transparency("jm.common.block_flag.transparency"),
    Error("jm.common.block_flag.error"),
    Plant("jm.common.block_flag.plant"),
    Crop("jm.common.block_flag.crop"),
    NoTopo("jm.common.block_flag.no_topo"),
    Force("jm.common.block_flag.force");

    String key;

    private BlockFlag(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    private static class Deserializer
    implements JsonDeserializer<EnumSet<BlockFlag>> {
        private Deserializer() {
        }

        public EnumSet<BlockFlag> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            EnumSet<BlockFlag> result = EnumSet.noneOf(BlockFlag.class);
            JsonArray flagArray = json.getAsJsonArray();
            for (JsonElement flagJson : flagArray.asList()) {
                BlockFlag flag = BlockFlag.valueOf(flagJson.getAsString());
                result.add(flag);
            }
            return result;
        }
    }

    private static class Serializer
    implements JsonSerializer<EnumSet<BlockFlag>> {
        private Serializer() {
        }

        public JsonElement serialize(EnumSet<BlockFlag> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray flagArray = new JsonArray();
            for (BlockFlag flag : src) {
                flagArray.add(flag.toString());
            }
            return flagArray;
        }
    }
}

