/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.feature;

import java.util.HashMap;
import java.util.Map;
import journeymap.api.v2.client.display.Context;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.Policy;
import journeymap.client.model.map.MapType;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.common.Journeymap;
import journeymap.common.properties.GlobalProperties;
import journeymap.common.properties.ServerOption;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public class FeatureManager {
    private static FeatureManager INSTANCE;
    private final HashMap<Feature, Policy> policyMap = new HashMap();

    private FeatureManager() {
        this.reset();
    }

    public static FeatureManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FeatureManager();
        }
        return INSTANCE;
    }

    public String getPolicyDetails() {
        StringBuilder sb = new StringBuilder("Features: ");
        for (Feature feature : Feature.values()) {
            boolean single = false;
            boolean multi = false;
            if (FeatureManager.INSTANCE.policyMap.containsKey((Object)feature)) {
                single = FeatureManager.INSTANCE.policyMap.get((Object)((Object)feature)).allowInSingleplayer;
                multi = FeatureManager.INSTANCE.policyMap.get((Object)((Object)feature)).allowInMultiplayer;
            }
            sb.append(String.format("\n\t%s : singleplayer = %s , multiplayer = %s", feature.name(), single, multi));
        }
        return sb.toString();
    }

    public boolean isAllowed(Feature feature) {
        Policy policy = FeatureManager.INSTANCE.policyMap.get((Object)feature);
        return policy != null && policy.isCurrentlyAllowed();
    }

    public Map<Feature, Boolean> getAllowedFeatures() {
        HashMap<Feature, Boolean> map = new HashMap<Feature, Boolean>(Feature.values().length * 2);
        for (Feature feature : Feature.values()) {
            map.put(feature, this.isAllowed(feature));
        }
        return map;
    }

    public void updateDimensionFeatures(GlobalProperties properties) {
        if (this.policyMap.get((Object)Feature.MapSurface).isCurrentlyAllowed() && !((ServerOption)((Object)properties.surfaceMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)Feature.MapSurface));
            this.nextMapType(Feature.MapSurface);
            this.policyMap.put(Feature.MapSurface, new Policy(Feature.MapSurface, false, false));
        } else if (!this.policyMap.get((Object)Feature.MapSurface).isCurrentlyAllowed() && ((ServerOption)((Object)properties.surfaceMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature enabled: " + String.valueOf((Object)Feature.MapSurface));
            this.policyMap.put(Feature.MapSurface, new Policy(Feature.MapSurface, true, true));
            if (MapType.none().equals(Fullscreen.state().getMapType())) {
                long time = ((class_1297)DataCache.getPlayer().entityRef.get()).method_5770().method_8401().method_188() % 24000L;
                MapType mapType = time < 13800L ? MapType.day(DataCache.getPlayer()) : MapType.night(DataCache.getPlayer());
                this.setMapType(mapType);
            }
        }
        if (this.policyMap.get((Object)Feature.MapTopo).isCurrentlyAllowed() && !((ServerOption)((Object)properties.topoMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)Feature.MapTopo));
            this.nextMapType(Feature.MapTopo);
            this.policyMap.put(Feature.MapTopo, new Policy(Feature.MapTopo, false, false));
        } else if (!this.policyMap.get((Object)Feature.MapTopo).isCurrentlyAllowed() && ((ServerOption)((Object)properties.topoMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature enabled: " + String.valueOf((Object)Feature.MapTopo));
            this.policyMap.put(Feature.MapTopo, new Policy(Feature.MapTopo, true, true));
            if (MapType.none().equals(Fullscreen.state().getMapType())) {
                this.setMapType(MapType.topo(DataCache.getPlayer()));
            }
        }
        if (this.policyMap.get((Object)Feature.MapBiome).isCurrentlyAllowed() && !((ServerOption)((Object)properties.biomeMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)Feature.MapBiome));
            this.nextMapType(Feature.MapBiome);
            this.policyMap.put(Feature.MapBiome, new Policy(Feature.MapBiome, false, false));
        } else if (!this.policyMap.get((Object)Feature.MapBiome).isCurrentlyAllowed() && ((ServerOption)((Object)properties.biomeMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature enabled: " + String.valueOf((Object)Feature.MapBiome));
            this.policyMap.put(Feature.MapBiome, new Policy(Feature.MapBiome, true, true));
            if (MapType.none().equals(Fullscreen.state().getMapType())) {
                this.setMapType(MapType.biome(DataCache.getPlayer()));
            }
        }
        if (this.policyMap.get((Object)Feature.MapCaves).isCurrentlyAllowed() && !((ServerOption)((Object)properties.caveMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)Feature.MapCaves));
            this.nextMapType(Feature.MapCaves);
            this.policyMap.put(Feature.MapCaves, new Policy(Feature.MapCaves, false, false));
        } else if (!this.policyMap.get((Object)Feature.MapCaves).isCurrentlyAllowed() && ((ServerOption)((Object)properties.caveMapping.get())).enabled()) {
            Journeymap.getLogger().info("Feature enabled: " + String.valueOf((Object)Feature.MapCaves));
            this.policyMap.put(Feature.MapCaves, new Policy(Feature.MapCaves, true, true));
            if (MapType.none().equals(Fullscreen.state().getMapType())) {
                this.setMapType(MapType.underground(DataCache.getPlayer()));
            }
        }
        if (((ServerOption)((Object)properties.radarEnabled.get())).enabled()) {
            this.setMultiplayerFeature(Feature.RadarAnimals, properties.animalRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarMobs, properties.mobRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarPlayers, properties.playerRadarEnabled.get());
            this.setMultiplayerFeature(Feature.RadarVillagers, properties.villagerRadarEnabled.get());
        } else {
            this.setMultiplayerFeature(Feature.RadarAnimals, false);
            this.setMultiplayerFeature(Feature.RadarMobs, false);
            this.setMultiplayerFeature(Feature.RadarPlayers, false);
            this.setMultiplayerFeature(Feature.RadarVillagers, false);
        }
    }

    private void nextMapType(Feature feature) {
        if (this.policyMap.get((Object)feature).isCurrentlyAllowed() && Fullscreen.state() != null) {
            if (Fullscreen.state().isSurfaceMappingAllowed() && !Feature.MapSurface.equals((Object)feature)) {
                this.setMapType(MapType.day(DataCache.getPlayer()));
            } else if (Fullscreen.state().isTopoMappingAllowed() && !Feature.MapTopo.equals((Object)feature)) {
                this.setMapType(MapType.topo(DataCache.getPlayer()));
            } else if (Fullscreen.state().isCaveMappingAllowed() && !Feature.MapCaves.equals((Object)feature)) {
                this.setMapType(MapType.underground(DataCache.getPlayer()));
            } else if (Fullscreen.state().isBiomeMappingAllowed() && !Feature.MapBiome.equals((Object)feature)) {
                this.setMapType(MapType.biome(DataCache.getPlayer()));
            }
        }
    }

    private void setMapType(MapType to) {
        Fullscreen.state().setMapType(to);
        MiniMap.state().setMapType(to);
    }

    private void setMultiplayerFeature(Feature feature, boolean enable) {
        if (!enable && this.policyMap.get((Object)feature).isCurrentlyAllowed()) {
            Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)feature));
        } else if (enable && !this.policyMap.get((Object)feature).isCurrentlyAllowed()) {
            Journeymap.getLogger().info("Feature enabled: " + String.valueOf((Object)feature));
        }
        this.policyMap.put(feature, new Policy(feature, true, enable));
    }

    public void reset() {
        for (Policy policy : Policy.bulkCreate(true, true)) {
            this.policyMap.put(policy.feature, policy);
        }
    }

    public void disableFeature(Context.MapType apiMapType, class_5321<class_1937> dimension) {
        Feature feature = Feature.fromApiMapType(apiMapType, dimension);
        this.nextMapType(feature);
        Journeymap.getLogger().info("Feature disabled: " + String.valueOf((Object)feature));
        this.policyMap.put(feature, new Policy(feature, false, false));
    }
}

