/*
 * Decompiled with CFR 0.152.
 */
package dev.ripio.cobbleloots.data.custom;

import dev.ripio.cobbleloots.Cobbleloots;
import net.minecraft.class_2960;

public class CobblelootsLootBallResourceLocation {
    private final String namespace;
    private final String path;
    private final String variant;

    public CobblelootsLootBallResourceLocation(String locationString) {
        String[] parts = locationString.split(":");
        switch (parts.length) {
            case 1: {
                this.namespace = "cobbleloots";
                this.path = parts[0];
                this.variant = "*";
                break;
            }
            case 2: {
                if (parts[1].equals("*")) {
                    this.namespace = parts[0];
                    this.path = "*";
                    this.variant = "*";
                    break;
                }
                if (class_2960.method_20209((String)parts[0])) {
                    this.namespace = parts[0];
                    this.path = parts[1];
                    this.variant = "*";
                    break;
                }
                this.namespace = "cobbleloots";
                this.path = parts[0];
                this.variant = parts[1];
                break;
            }
            case 3: {
                this.namespace = parts[0];
                this.path = parts[1];
                this.variant = parts[2];
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid loot ball location format: " + locationString);
            }
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPath() {
        return this.path;
    }

    public String getVariant() {
        return this.variant;
    }

    public class_2960 getResourceLocation() {
        return class_2960.method_60655((String)this.namespace, (String)this.path);
    }

    public boolean matches(String namespace, String path, String variant) {
        boolean namespaceMatches = this.namespace.equals("*") || this.namespace.equals(namespace);
        boolean pathMatches = this.path.equals("*") || this.path.equals(path);
        boolean variantMatches = this.variant.equals("*") || this.variant.equals(variant);
        Cobbleloots.LOGGER.info("[DEBUG] Matching loot ball pattern {} against {}:{}:{}} - namespaceMatches: {}, pathMatches: {}, variantMatches: {}", new Object[]{this, namespace, path, variant, namespaceMatches, pathMatches, variantMatches});
        if (this.path.equals("*")) {
            return namespaceMatches;
        }
        if (this.variant.equals("*")) {
            return namespaceMatches && pathMatches;
        }
        return namespaceMatches && pathMatches && variantMatches;
    }

    public String toString() {
        return this.namespace + ":" + this.path + ":" + this.variant;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CobblelootsLootBallResourceLocation that = (CobblelootsLootBallResourceLocation)obj;
        return this.namespace.equals(that.namespace) && this.path.equals(that.path) && this.variant.equals(that.variant);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.variant.hashCode();
        return result;
    }
}

