/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.tree;

import biomesoplenty.worldgen.feature.configurations.PineTreeConfiguration;
import biomesoplenty.worldgen.feature.tree.BOPTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5281;
import net.minecraft.class_5819;

public class PineTreeFeature
extends BOPTreeFeature<PineTreeConfiguration> {
    public PineTreeFeature(Codec<PineTreeConfiguration> codec) {
        super(codec);
    }

    protected boolean method_12775(class_5281 world, class_5819 random, class_2338 pos, BiConsumer<class_2338, class_2680> roots, BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_4643 configBase) {
        PineTreeConfiguration config = (PineTreeConfiguration)configBase;
        int height = random.method_43048(config.maxHeight - config.minHeight) + config.minHeight;
        boolean hasSpace = true;
        if (pos.method_10264() >= world.method_31607() + 1 && pos.method_10264() + height + 1 <= world.method_31600()) {
            for (int y = pos.method_10264(); y <= pos.method_10264() + 1 + height; ++y) {
                int radius = 1;
                if (y == pos.method_10264()) {
                    radius = 0;
                }
                if (y >= pos.method_10264() + 1 + height - 2) {
                    radius = 2;
                }
                for (int x = pos.method_10263() - radius; x <= pos.method_10263() + radius && hasSpace; ++x) {
                    for (int z = pos.method_10260() - radius; z <= pos.method_10260() + radius && hasSpace; ++z) {
                        if (y >= world.method_31607() && y < world.method_31600()) {
                            if (this.canReplace((class_1936)world, new class_2338(x, y, z))) continue;
                            hasSpace = false;
                            continue;
                        }
                        hasSpace = false;
                    }
                }
            }
            if (!hasSpace) {
                return false;
            }
            class_2338 soilPos = pos.method_10074();
            class_2248 soil = world.method_8320(soilPos).method_26204();
            if (pos.method_10264() < world.method_31600() - height - 1) {
                world.method_8652(soilPos, class_2246.field_10566.method_9564(), 3);
                this.generateTrunk(logs, leaves, (class_1936)world, pos, height, config);
                return true;
            }
            return false;
        }
        return false;
    }

    protected void generateTrunk(BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_1936 world, class_2338 start, int height, PineTreeConfiguration config) {
        int endHeight = height;
        for (int layer = 0; layer <= endHeight; ++layer) {
            class_2338 middlePos = start.method_10086(layer);
            if (!this.canReplace(world, middlePos)) continue;
            this.placeLog(world, middlePos, logs, config);
        }
        class_2338 lowerBranchStartPos = start.method_10086(endHeight - 9);
        class_2350 lowerBranchDir = class_2350.class_2353.field_11062.method_10183(world.method_8409());
        if (world.method_8409().method_43048(6) != 0) {
            this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir, 2, config);
            if (world.method_8409().method_43048(4) == 0) {
                this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.method_10153(), 2, config);
                if (world.method_8409().method_43048(6) == 0) {
                    this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.method_10170(), 2, config);
                    this.generateBranch(logs, leaves, world, lowerBranchStartPos, lowerBranchDir.method_10160(), 2, config);
                }
            }
        }
        class_2338 upperBranchStartPos = start.method_10086(endHeight - 6);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, class_2350.field_11043, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, class_2350.field_11034, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, class_2350.field_11035, 1, config);
        this.generateBranch(logs, leaves, world, upperBranchStartPos, class_2350.field_11039, 1, config);
        class_2338 topStartPos = start.method_10086(endHeight - 3);
        this.placeLeaves(world, topStartPos.method_10069(0, 0, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 0, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 0, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 0, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 1, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 1, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 1, 2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 1, -2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 1, 2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 1, -2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(2, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(2, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-2, 1, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-2, 1, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 3, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 3, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 3, 2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 3, -2), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(2, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-2, 3, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 4, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 4, 1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(0, 4, -1), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(1, 4, 0), leaves, config);
        this.placeLeaves(world, topStartPos.method_10069(-1, 4, 0), leaves, config);
    }

    private void generateBranch(BiConsumer<class_2338, class_2680> logs, class_4647.class_8179 leaves, class_1936 world, class_2338 middle, class_2350 direction, int length, PineTreeConfiguration config) {
        class_2338 pos = middle;
        for (int i = 0; i <= length - 1; ++i) {
            if (!this.canReplace(world, pos.method_10079(direction, i + 1))) continue;
            this.placeLog(world, pos.method_10079(direction, i + 1), direction.method_10166(), logs, config);
        }
        if (this.canReplace(world, pos.method_10079(direction, length + 1).method_10084())) {
            this.placeLog(world, pos.method_10079(direction, length + 1).method_10084(), direction.method_10166(), logs, config);
        }
        pos = pos.method_10079(direction, length + 1);
        this.placeLeaves(world, pos, leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 1, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 1, 2), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 1, -2), leaves, config);
        this.placeLeaves(world, pos.method_10069(2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(-2, 1, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(0, 2, 0), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 2, 1), leaves, config);
        this.placeLeaves(world, pos.method_10069(1, 2, -1), leaves, config);
        this.placeLeaves(world, pos.method_10069(-1, 2, -1), leaves, config);
    }
}

