/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.biome;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.util.biome.BiomeUtil;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6544;

public class BOPOverworldBiomeBuilder {
    private static final float VALLEY_SIZE = 0.05f;
    private static final float LOW_START = 0.26666668f;
    public static final float HIGH_START = 0.4f;
    private static final float HIGH_END = 0.93333334f;
    private static final float PEAK_SIZE = 0.1f;
    public static final float PEAK_START = 0.56666666f;
    private static final float PEAK_END = 0.7666667f;
    public static final float NEAR_INLAND_START = -0.11f;
    public static final float MID_INLAND_START = 0.03f;
    public static final float FAR_INLAND_START = 0.3f;
    public static final float EROSION_INDEX_1_START = -0.78f;
    public static final float EROSION_INDEX_2_START = -0.375f;
    protected final class_6544.class_6546 FULL_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)1.0f);
    protected final class_6544.class_6546[] temperatures = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.45f), class_6544.class_6546.method_38121((float)-0.45f, (float)-0.15f), class_6544.class_6546.method_38121((float)-0.15f, (float)0.2f), class_6544.class_6546.method_38121((float)0.2f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    protected final class_6544.class_6546[] humidities = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.35f), class_6544.class_6546.method_38121((float)-0.35f, (float)-0.1f), class_6544.class_6546.method_38121((float)-0.1f, (float)0.1f), class_6544.class_6546.method_38121((float)0.1f, (float)0.3f), class_6544.class_6546.method_38121((float)0.3f, (float)1.0f)};
    protected final class_6544.class_6546[] erosions = new class_6544.class_6546[]{class_6544.class_6546.method_38121((float)-1.0f, (float)-0.78f), class_6544.class_6546.method_38121((float)-0.78f, (float)-0.375f), class_6544.class_6546.method_38121((float)-0.375f, (float)-0.2225f), class_6544.class_6546.method_38121((float)-0.2225f, (float)0.05f), class_6544.class_6546.method_38121((float)0.05f, (float)0.45f), class_6544.class_6546.method_38121((float)0.45f, (float)0.55f), class_6544.class_6546.method_38121((float)0.55f, (float)1.0f)};
    protected static final class_6544.class_6546 COMMON_RARENESS_RANGE = class_6544.class_6546.method_38121((float)-1.0f, (float)0.35f);
    protected static final class_6544.class_6546 RARE_RARENESS_RANGE = class_6544.class_6546.method_38121((float)0.35f, (float)1.0f);
    protected final class_6544.class_6546 FROZEN_RANGE = this.temperatures[0];
    protected final class_6544.class_6546 UNFROZEN_RANGE = class_6544.class_6546.method_38123((class_6544.class_6546)this.temperatures[1], (class_6544.class_6546)this.temperatures[4]);
    protected final class_6544.class_6546 mushroomFieldsContinentalness = class_6544.class_6546.method_38121((float)-1.2f, (float)-1.05f);
    protected final class_6544.class_6546 deepOceanContinentalness = class_6544.class_6546.method_38121((float)-1.05f, (float)-0.455f);
    protected final class_6544.class_6546 oceanContinentalness = class_6544.class_6546.method_38121((float)-0.455f, (float)-0.19f);
    protected final class_6544.class_6546 coastContinentalness = class_6544.class_6546.method_38121((float)-0.19f, (float)-0.11f);
    protected final class_6544.class_6546 inlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.55f);
    protected final class_6544.class_6546 nearInlandContinentalness = class_6544.class_6546.method_38121((float)-0.11f, (float)0.03f);
    protected final class_6544.class_6546 midInlandContinentalness = class_6544.class_6546.method_38121((float)0.03f, (float)0.3f);
    protected final class_6544.class_6546 farInlandContinentalness = class_6544.class_6546.method_38121((float)0.3f, (float)1.0f);
    private final class_5321<class_1959>[][] OCEANS = new class_5321[][]{{class_1972.field_9418, class_1972.field_9470, class_1972.field_9446, class_1972.field_9439, class_1972.field_9408}, {class_1972.field_9435, class_1972.field_9467, class_1972.field_9423, class_1972.field_9441, class_1972.field_9408}};
    protected final class_5321<class_1959>[][] MIDDLE_BIOMES = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9420}, {class_1972.field_9451, class_1972.field_9451, class_1972.field_9409, class_1972.field_9420, class_1972.field_35113}, {class_1972.field_9414, class_1972.field_9451, class_1972.field_9409, class_1972.field_9412, class_1972.field_9475}, {class_1972.field_9449, class_1972.field_9449, class_1972.field_9409, class_1972.field_9417, class_1972.field_9417}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}};
    private final class_5321<class_1959>[][] MIDDLE_BIOMES_VARIANT = new class_5321[][]{{class_1972.field_9453, null, class_1972.field_9454, null, null}, {null, null, null, null, class_1972.field_35119}, {class_1972.field_9455, null, null, class_1972.field_35112, null}, {null, null, class_1972.field_9451, class_1972.field_35118, class_1972.field_9440}, {null, null, null, null, null}};
    protected final class_5321<class_1959>[][] PLATEAU_BIOMES = new class_5321[][]{{class_1972.field_35117, class_1972.field_35117, class_1972.field_35117, class_1972.field_9454, class_1972.field_9454}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_9409, class_1972.field_9420, class_1972.field_35113}, {class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_34470, class_1972.field_9475}, {class_1972.field_9430, class_1972.field_9430, class_1972.field_9409, class_1972.field_9409, class_1972.field_9417}, {class_1972.field_9415, class_1972.field_9415, class_1972.field_9415, class_1972.field_35110, class_1972.field_35110}};
    protected final class_5321<class_1959>[][] PLATEAU_BIOMES_VARIANT = new class_5321[][]{{class_1972.field_9453, null, null, null, null}, {class_1972.field_42720, null, class_1972.field_34470, class_1972.field_34470, class_1972.field_35119}, {class_1972.field_42720, class_1972.field_42720, class_1972.field_9409, class_1972.field_9412, null}, {null, null, null, null, null}, {class_1972.field_9443, class_1972.field_9443, null, null, null}};
    private final class_5321<class_1959>[][] EXTREME_HILLS_BIOMES = new class_5321[][]{{class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35111, class_1972.field_35111, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {class_1972.field_35116, class_1972.field_35116, class_1972.field_35116, class_1972.field_35120, class_1972.field_35120}, {null, null, null, null, null}, {null, null, null, null, null}};
    private final class_5321<class_1959>[][] SWAMP_BIOMES = new class_5321[][]{{class_1972.field_9463, class_1972.field_9463, class_1972.field_9463, class_1972.field_9463, class_1972.field_9463}, {class_1972.field_9471, class_1972.field_9471, class_1972.field_9471, class_1972.field_9471, class_1972.field_9471}, {class_1972.field_9471, class_1972.field_9471, class_1972.field_9471, class_1972.field_9471, class_1972.field_9471}, {class_1972.field_38748, class_1972.field_38748, class_1972.field_38748, class_1972.field_38748, class_1972.field_38748}, {class_1972.field_38748, class_1972.field_38748, class_1972.field_38748, class_1972.field_38748, class_1972.field_38748}};
    protected final class_5321<class_1959>[][] BEACH_BIOMES = new class_5321[][]{{class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424, class_1972.field_9424}};
    protected final class_5321<class_1959>[][] MIDDLE_BIOMES_BOP = new class_5321[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.COLD_DESERT, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPBiomes.SNOWY_CONIFEROUS_FOREST, BOPBiomes.SNOWY_CONIFEROUS_FOREST}, {BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.FIELD, BOPBiomes.FIELD}, {BOPBiomes.PASTURE, BOPBiomes.PRAIRIE, BOPBiomes.REDWOOD_FOREST, BOPBiomes.OVERGROWN_GREENS, BOPBiomes.OVERGROWN_GREENS}, {BOPBiomes.SCRUBLAND, BOPBiomes.SCRUBLAND, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.RAINFOREST}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final class_5321<class_1959>[][] MIDDLE_BIOMES_VARIANT_BOP = new class_5321[][]{{null, null, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_MAPLE_WOODS}, {null, BOPBiomes.FIR_CLEARING, null, null, BOPBiomes.FORESTED_FIELD}, {null, null, null, null, BOPBiomes.GRASSLAND}, {null, null, BOPBiomes.OLD_GROWTH_WOODLAND, null, BOPBiomes.ROCKY_RAINFOREST}, {null, null, null, BOPBiomes.LUSH_SAVANNA, BOPBiomes.LUSH_SAVANNA}};
    protected final class_5321<class_1959>[][] PLATEAU_BIOMES_BOP = new class_5321[][]{{BOPBiomes.COLD_DESERT, BOPBiomes.COLD_DESERT, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_FIR_CLEARING, BOPBiomes.SNOWY_CONIFEROUS_FOREST}, {BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.FIELD}, {BOPBiomes.PRAIRIE, BOPBiomes.PRAIRIE, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {BOPBiomes.SCRUBLAND, BOPBiomes.SCRUBLAND, BOPBiomes.WOODLAND, BOPBiomes.RAINFOREST, BOPBiomes.ROCKY_RAINFOREST}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final class_5321<class_1959>[][] PLATEAU_BIOMES_VARIANT_BOP = new class_5321[][]{{null, null, null, null, null}, {null, null, BOPBiomes.CONIFEROUS_FOREST, BOPBiomes.FIELD, null}, {BOPBiomes.PASTURE, null, BOPBiomes.REDWOOD_FOREST, BOPBiomes.OVERGROWN_GREENS, BOPBiomes.MOOR}, {null, null, null, BOPBiomes.ROCKY_RAINFOREST, null}, {null, null, null, null, BOPBiomes.LUSH_SAVANNA}};
    protected final class_5321<class_1959>[][] SLOPE_BIOMES_BOP = new class_5321[][]{{null, null, null, null, null}, {BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG}, {BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final class_5321<class_1959>[][] PEAK_BIOMES_BOP = new class_5321[][]{{null, null, null, null, null}, {BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG, BOPBiomes.CRAG}, {BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS, BOPBiomes.JADE_CLIFFS}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final class_5321<class_1959>[][] EXTREME_HILLS_BIOMES_BOP = new class_5321[][]{{null, null, null, null, null}, {BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND, BOPBiomes.HIGHLAND}, {null, null, null, BOPBiomes.VOLCANO, BOPBiomes.VOLCANO}, {null, null, null, null, null}};
    protected final class_5321<class_1959>[][] SWAMP_BIOMES_BOP = new class_5321[][]{{BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS, BOPBiomes.HOT_SPRINGS}, {BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND, BOPBiomes.WETLAND}, {BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH, BOPBiomes.MARSH}, {BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.BAYOU, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}};
    protected final class_5321<class_1959>[][] RIVER_BIOMES_BOP = new class_5321[][]{{class_1972.field_9463, class_1972.field_9463, class_1972.field_9463, class_1972.field_9463, class_1972.field_9463}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {null, null, null, null, null}};
    protected final class_5321<class_1959>[][] BEACH_BIOMES_BOP = new class_5321[][]{{class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478, class_1972.field_9478}, {BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH, BOPBiomes.GRAVEL_BEACH}, {BOPBiomes.DUNE_BEACH, BOPBiomes.DUNE_BEACH, BOPBiomes.DUNE_BEACH, class_1972.field_9434, class_1972.field_9434}, {class_1972.field_9434, class_1972.field_9434, class_1972.field_9434, BOPBiomes.FLOODPLAIN, BOPBiomes.FLOODPLAIN}, {BOPBiomes.DRYLAND, BOPBiomes.DRYLAND, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final class_5321<class_1959>[][] STONY_SHORES_BIOMES_BOP = new class_5321[][]{{null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, null, null}, {null, null, null, BOPBiomes.ROCKY_RAINFOREST, BOPBiomes.ROCKY_RAINFOREST}, {null, null, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT, BOPBiomes.LUSH_DESERT}};
    protected final class_5321<class_1959>[][] ISLAND_BIOMES_BOP = new class_5321[][]{{BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY, BOPBiomes.WINTRY_ORIGIN_VALLEY}, {BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY, BOPBiomes.ORIGIN_VALLEY}, {null, null, null, null, null}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}, {BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS, BOPBiomes.TROPICS}};

    public void addBiomes(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        this.addOffCoastBiomes(biomeRegistry, mapper);
        this.addInlandBiomes(biomeRegistry, mapper);
        this.addUndergroundBiomes(biomeRegistry, mapper);
    }

    private void addOffCoastBiomes(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> islandBiomeBOP = this.pickIslandBiomeBOP(biomeRegistry, i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.mushroomFieldsContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, islandBiomeBOP);
            }
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.deepOceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[0][i]);
            this.addSurfaceBiome(mapper, temperature, this.FULL_RANGE, this.oceanContinentalness, this.FULL_RANGE, this.FULL_RANGE, 0.0f, this.OCEANS[1][i]);
        }
    }

    private void addInlandBiomes(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        this.addMidSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-1.0f, (float)-0.93333334f));
        this.addHighSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.93333334f, (float)-0.7666667f));
        this.addPeaks(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.7666667f, (float)-0.56666666f));
        this.addHighSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.56666666f, (float)-0.4f));
        this.addMidSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.4f, (float)-0.26666668f));
        this.addLowSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.26666668f, (float)-0.05f));
        this.addValleys(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)-0.05f, (float)0.05f));
        this.addLowSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.05f, (float)0.26666668f));
        this.addMidSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.26666668f, (float)0.4f));
        this.addHighSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.4f, (float)0.56666666f));
        this.addPeaks(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.56666666f, (float)0.7666667f));
        this.addHighSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.7666667f, (float)0.93333334f));
        this.addMidSlice(biomeRegistry, mapper, class_6544.class_6546.method_38121((float)0.93333334f, (float)1.0f));
    }

    protected void addPeaks(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> extremeHillsBiome = this.pickExtremeHillsBiomeVanilla(i, j, weirdness);
                class_5321<class_1959> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, extremeHillsBiome);
                class_5321<class_1959> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
            }
        }
    }

    protected void addHighSlice(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                class_5321<class_1959> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                class_5321<class_1959> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> peakBiomeBOP = this.pickPeakBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[0], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, peakBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[1], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[3], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
            }
        }
    }

    protected void addMidSlice(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                class_5321<class_1959> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> extremeHillsBiomeBOP = this.pickExtremeHillsBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> plateauBiomeBOP = this.pickPlateauBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> beachBiomeBOP = this.pickBeachBiomeBOP(biomeRegistry, i, j);
                class_5321<class_1959> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                class_5321<class_1959> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                class_5321<class_1959> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> slopeBiomeBOP = this.pickSlopeBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[0], weirdness, 0.0f, slopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.midInlandContinentalness), this.erosions[1], weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[1], weirdness, 0.0f, i == 0 ? slopeBiomeBOP : plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.midInlandContinentalness, this.erosions[2], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.farInlandContinentalness, this.erosions[2], weirdness, 0.0f, plateauBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.nearInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[3], weirdness, 0.0f, middleBiomeBOP);
                if (weirdness.comp_104() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[4], weirdness, 0.0f, beachBiomeBOP);
                    this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, extremeHillsBiomeBOP);
                if (weirdness.comp_104() < 0L) {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiomeBOP);
                } else {
                    this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, middleBiomeBOP);
                }
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addLowSlice(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 weirdness) {
        for (int i = 0; i < this.temperatures.length; ++i) {
            class_6544.class_6546 temperature = this.temperatures[i];
            for (int j = 0; j < this.humidities.length; ++j) {
                class_6544.class_6546 humidity = this.humidities[j];
                class_5321<class_1959> middleBiomeVanilla = this.pickMiddleBiomeVanilla(i, j, weirdness);
                class_5321<class_1959> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> middleBadlandsOrSlopeBiomeBOP = this.pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> beachBiome = this.pickBeachBiomeBOP(biomeRegistry, i, j);
                class_5321<class_1959> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                class_5321<class_1959> shatteredBiome = this.maybePickShatteredBiome(biomeRegistry, i, j, weirdness, middleBiomeVanilla);
                class_5321<class_1959> shatteredCoastBiome = this.pickShatteredCoastBiome(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[2]), weirdness, 0.0f, stonyShoresBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBadlandsOrSlopeBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[3]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[3], (class_6544.class_6546)this.erosions[4]), weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[4], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[5], weirdness, 0.0f, shatteredCoastBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, this.erosions[5], weirdness, 0.0f, shatteredBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[5], weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, beachBiome);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.nearInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addValleys(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 weirdness) {
        class_6544.class_6546 humidity;
        int j;
        class_6544.class_6546 temperature;
        int i;
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                class_5321<class_1959> riverBiomeBOP = this.pickRiverBiomeBOP(biomeRegistry, i, j);
                class_5321<class_1959> stonyShoresBiomeBOP = this.pickStonyShoresBiomeBOP(biomeRegistry, i, j);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, weirdness.comp_104() < 0L ? stonyShoresBiomeBOP : riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.nearInlandContinentalness, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.coastContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[2], (class_6544.class_6546)this.erosions[5]), weirdness, 0.0f, riverBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, this.coastContinentalness, this.erosions[6], weirdness, 0.0f, riverBiomeBOP);
            }
        }
        for (i = 0; i < this.temperatures.length; ++i) {
            temperature = this.temperatures[i];
            for (j = 0; j < this.humidities.length; ++j) {
                humidity = this.humidities[j];
                class_5321<class_1959> middleBiomeBOP = this.pickMiddleBiomeBOP(biomeRegistry, i, j, weirdness);
                class_5321<class_1959> swampBiomeBOP = this.pickSwampBiomeBOP(biomeRegistry, i, j, weirdness);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.midInlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), weirdness, 0.0f, middleBiomeBOP);
                this.addSurfaceBiome(mapper, temperature, humidity, class_6544.class_6546.method_38123((class_6544.class_6546)this.inlandContinentalness, (class_6544.class_6546)this.farInlandContinentalness), this.erosions[6], weirdness, 0.0f, swampBiomeBOP);
            }
        }
    }

    protected void addUndergroundBiomes(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper) {
        this.addUndergroundBiome(biomeRegistry, mapper, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.8f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, 0.0f, BOPBiomes.SPIDER_NEST, (class_5321<class_1959>)class_1972.field_28107);
        this.addUndergroundBiome(biomeRegistry, mapper, this.FULL_RANGE, class_6544.class_6546.method_38121((float)0.7f, (float)1.0f), this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, 0.0f, BOPBiomes.GLOWING_GROTTO, (class_5321<class_1959>)class_1972.field_29218);
        this.addBottomBiome(mapper, this.FULL_RANGE, this.FULL_RANGE, this.FULL_RANGE, class_6544.class_6546.method_38123((class_6544.class_6546)this.erosions[0], (class_6544.class_6546)this.erosions[1]), this.FULL_RANGE, 0.0f, (class_5321<class_1959>)class_1972.field_37543);
    }

    protected class_5321<class_1959> pickMiddleBiomeVanilla(int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            return this.MIDDLE_BIOMES[temperatureIndex][humidityIndex];
        }
        class_5321<class_1959> variantBiome = this.MIDDLE_BIOMES_VARIANT[temperatureIndex][humidityIndex];
        return variantBiome == null ? this.MIDDLE_BIOMES[temperatureIndex][humidityIndex] : variantBiome;
    }

    protected class_5321<class_1959> pickMiddleBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        class_5321<class_1959> middleBiome = BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_BOP[temperatureIndex][humidityIndex], this.MIDDLE_BIOMES[temperatureIndex][humidityIndex]);
        if (weirdness.comp_104() < 0L) {
            return middleBiome;
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.MIDDLE_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], middleBiome);
    }

    protected class_5321<class_1959> pickMiddleBiomeOrBadlandsIfHotOrSlopeIfColdBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        return temperatureIndex == 0 ? this.pickSlopeBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness) : this.pickMiddleBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness);
    }

    protected class_5321<class_1959> maybePickShatteredBiome(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness, class_5321<class_1959> extremeHillsBiome) {
        return temperatureIndex > 1 && humidityIndex < 4 && weirdness.comp_104() >= 0L ? BiomeUtil.biomeOrFallback(biomeRegistry, BOPBiomes.CRAG, class_1972.field_35114) : extremeHillsBiome;
    }

    protected class_5321<class_1959> pickShatteredCoastBiome(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        class_5321<class_1959> resourcekey = weirdness.comp_104() >= 0L ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : this.pickBeachBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex);
        return this.maybePickShatteredBiome(biomeRegistry, temperatureIndex, humidityIndex, weirdness, resourcekey);
    }

    protected class_5321<class_1959> pickSwampBiomeVanilla(int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        class_5321<class_1959> resourcekey = this.SWAMP_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected class_5321<class_1959> pickSwampBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.SWAMP_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickSwampBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    protected class_5321<class_1959> pickRiverBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.RIVER_BIOMES_BOP[temperatureIndex][humidityIndex], temperatureIndex == 0 ? class_1972.field_9463 : class_1972.field_9438);
    }

    protected class_5321<class_1959> pickBeachBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.BEACH_BIOMES_BOP[temperatureIndex][humidityIndex], this.BEACH_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected class_5321<class_1959> pickStonyShoresBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.STONY_SHORES_BIOMES_BOP[temperatureIndex][humidityIndex], class_1972.field_9419);
    }

    protected class_5321<class_1959> pickIslandBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.ISLAND_BIOMES_BOP[temperatureIndex][humidityIndex], class_1972.field_9462);
    }

    protected class_5321<class_1959> pickBadlandsBiome(int humidityIndex, class_6544.class_6546 weirdness) {
        if (humidityIndex < 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_9443 : class_1972.field_9415;
        }
        return humidityIndex < 3 ? class_1972.field_9415 : class_1972.field_35110;
    }

    protected class_5321<class_1959> pickPlateauBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        if (weirdness.comp_104() < 0L) {
            return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
        }
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.PLATEAU_BIOMES_VARIANT_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES_BOP[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES_VARIANT[temperatureIndex][humidityIndex], this.PLATEAU_BIOMES[temperatureIndex][humidityIndex]);
    }

    protected class_5321<class_1959> pickPeakBiome(int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        if (temperatureIndex <= 2) {
            return weirdness.comp_104() < 0L ? class_1972.field_34474 : class_1972.field_35115;
        }
        return temperatureIndex == 3 ? class_1972.field_34475 : this.pickBadlandsBiome(humidityIndex, weirdness);
    }

    protected class_5321<class_1959> pickPeakBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.PEAK_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickPeakBiome(temperatureIndex, humidityIndex, weirdness));
    }

    protected class_5321<class_1959> pickSlopeBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.SLOPE_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickPlateauBiomeBOP(biomeRegistry, temperatureIndex, humidityIndex, weirdness));
    }

    protected class_5321<class_1959> pickExtremeHillsBiomeVanilla(int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        class_5321<class_1959> resourcekey = this.EXTREME_HILLS_BIOMES[temperatureIndex][humidityIndex];
        return resourcekey == null ? this.pickMiddleBiomeVanilla(temperatureIndex, humidityIndex, weirdness) : resourcekey;
    }

    protected class_5321<class_1959> pickExtremeHillsBiomeBOP(class_2378<class_1959> biomeRegistry, int temperatureIndex, int humidityIndex, class_6544.class_6546 weirdness) {
        return BiomeUtil.biomeOrFallback(biomeRegistry, this.EXTREME_HILLS_BIOMES_BOP[temperatureIndex][humidityIndex], this.pickExtremeHillsBiomeVanilla(temperatureIndex, humidityIndex, weirdness));
    }

    protected void addSurfaceBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)0.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
        mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.0f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }

    protected void addUndergroundBiome(class_2378<class_1959> biomeRegistry, Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome, class_5321<class_1959> fallbackBiome) {
        mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38121((float)0.2f, (float)0.9f), (class_6544.class_6546)weirdness, (float)offset), BiomeUtil.biomeOrFallback(biomeRegistry, biome, fallbackBiome)));
    }

    private void addBottomBiome(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> mapper, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome) {
        mapper.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)class_6544.method_38118((class_6544.class_6546)temperature, (class_6544.class_6546)humidity, (class_6544.class_6546)continentalness, (class_6544.class_6546)erosion, (class_6544.class_6546)class_6544.class_6546.method_38120((float)1.1f), (class_6544.class_6546)weirdness, (float)offset), biome));
    }
}

