/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class JSONReader {
    public static String readJson(String location) throws NullPointerException {
        return new BufferedReader(new InputStreamReader(JSONReader.class.getResourceAsStream(String.format("/data/%s/%s.json", "cobblemon-additions", location)), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
    }

    public static List<String> parseStrings(String json, String key) throws NullPointerException {
        try {
            json = JSONReader.readJson(json);
        }
        catch (NullPointerException e) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String[] keySplit = key.split("\\.");
        JsonElement jElement = JsonParser.parseString((String)json);
        JsonObject jObject = jElement.getAsJsonObject();
        JsonArray jArray = jObject.getAsJsonArray("pokemon");
        for (int i = 0; i < jArray.size(); ++i) {
            jObject = jArray.get(i).getAsJsonObject();
            if (keySplit.length > 1) {
                for (String s : keySplit) {
                    if (jObject.get(s).isJsonObject()) {
                        jObject = jObject.get(s).getAsJsonObject();
                        continue;
                    }
                    result.add(jObject.get(s).getAsString());
                }
                continue;
            }
            result.add(jObject.get(key).getAsString());
        }
        return result;
    }

    public static List<Integer> parseIntegers(String json, String key) {
        json = JSONReader.readJson(json);
        ArrayList<Integer> result = new ArrayList<Integer>();
        String[] keySplit = key.split("\\.");
        JsonElement jElement = JsonParser.parseString((String)json);
        JsonObject jObject = jElement.getAsJsonObject();
        JsonArray jArray = jObject.getAsJsonArray("pokemon");
        for (int i = 0; i < jArray.size(); ++i) {
            jObject = jArray.get(i).getAsJsonObject();
            if (keySplit.length > 1) {
                for (String s : keySplit) {
                    if (jObject.get(s).isJsonObject()) {
                        jObject = jObject.get(s).getAsJsonObject();
                        continue;
                    }
                    result.add(jObject.get(s).getAsInt());
                }
                continue;
            }
            result.add(jObject.get(key).getAsInt());
        }
        return result;
    }
}

