/*
 * Decompiled with CFR 0.152.
 */
package io.strikeknight57.bca.block.entity;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import io.strikeknight57.bca.CobblemonAdditions;
import io.strikeknight57.bca.registry.CobblemonAdditionsBlockEntities;
import io.strikeknight57.bca.util.PokemonSpawnUtils;
import io.strikeknight57.bca.util.json.JSONReader;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class PokemonSpawnerBlockEntity
extends class_2586 {
    private final int minSpawnTime = 120;
    private final int maxSpawnTime = 600;
    private final int minSpawnQuantity = 1;
    private final int maxSpawnQuantity = 3;
    private final int spawnRange = 4;
    private static int randTicks = 0;
    private static int randQuantity = 0;
    private boolean bricked = false;
    public String spawnerFile;
    public int verticalOffset = 0;
    private int ticksSinceLast = 0;
    private static class_3222 closestPlayer;
    private static int playerAvgLvl;

    public PokemonSpawnerBlockEntity(class_2338 pos, class_2680 state) {
        super(CobblemonAdditionsBlockEntities.POKEMON_SPAWNER_ENTITY, pos, state);
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10582("spawner", this.spawnerFile);
        nbt.method_10569("vert_offset", this.verticalOffset);
        super.method_11007(nbt, registryLookup);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.spawnerFile = nbt.method_10558("spawner");
        this.verticalOffset = nbt.method_10550("vert_offset");
    }

    private static boolean initRandom(class_1937 world, PokemonSpawnerBlockEntity entity) {
        class_5819 random = world.method_8409();
        if (randTicks == 0) {
            randTicks = class_3532.method_32751((class_5819)random, (int)entity.minSpawnTime, (int)entity.maxSpawnTime);
        }
        if (randQuantity == 0) {
            randQuantity = class_3532.method_32751((class_5819)random, (int)entity.minSpawnQuantity, (int)entity.maxSpawnQuantity);
        }
        return true;
    }

    private static void checkTicks(class_1937 world, class_2338 blockPos, class_2680 blockState, PokemonSpawnerBlockEntity entity) {
        int l;
        int k;
        int j;
        int c;
        int b;
        if (entity.ticksSinceLast <= randTicks) {
            return;
        }
        int detectionRange = 16;
        int a = blockPos.method_10263() - detectionRange;
        List nearbyMon = world.method_18023((class_5575)CobblemonEntities.POKEMON, new class_238(new class_243((double)a, (double)(b = blockPos.method_10264() - detectionRange), (double)(c = blockPos.method_10260() - detectionRange)), new class_243((double)(j = blockPos.method_10263() + detectionRange), (double)(k = blockPos.method_10264() + detectionRange), (double)(l = blockPos.method_10260() + detectionRange))), pokemonEntity -> true);
        if (nearbyMon.size() > 8) {
            return;
        }
        List<String> pokemonToSpawn = JSONReader.parseStrings("spawner/" + entity.spawnerFile, "id");
        if (pokemonToSpawn == null) {
            CobblemonAdditions.LOGGER.error("File or directory not found: '{}' for spawner at {}", (Object)entity.spawnerFile, (Object)blockPos);
            entity.bricked = true;
            return;
        }
        List<Integer> lvlsMin = JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "levels.min");
        List<Integer> lvlsRange = JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "levels.range");
        for (int i = 1; i <= randQuantity; ++i) {
            class_2680 spawnBlockState;
            class_5819 random = world.method_8409();
            int randX = class_3532.method_32751((class_5819)random, (int)(-entity.spawnRange), (int)entity.spawnRange);
            int randZ = class_3532.method_32751((class_5819)random, (int)(-entity.spawnRange), (int)entity.spawnRange);
            int randPkmnID = PokemonSpawnUtils.weightSpawnID(world, pokemonToSpawn, JSONReader.parseIntegers("spawner/" + entity.spawnerFile, "weight"));
            class_2338 spawnPos = new class_2338(blockPos.method_10263() + randX, blockPos.method_10264(), blockPos.method_10260() + randZ);
            if (!PokemonSpawnerBlockEntity.isClearForSpawn((class_1922)world, spawnPos, spawnBlockState = world.method_8320(spawnPos), spawnBlockState.method_26227())) continue;
            String pkmnName = pokemonToSpawn.get(randPkmnID).toLowerCase();
            int randLvl = class_3532.method_32751((class_5819)random, (int)lvlsMin.get(randPkmnID), (int)(playerAvgLvl >= lvlsMin.get(randPkmnID) ? playerAvgLvl + lvlsRange.get(randPkmnID) : lvlsMin.get(randPkmnID)));
            PokemonProperties properties = PokemonProperties.Companion.parse(pkmnName + " uncatchable=true");
            properties.setLevel(Integer.valueOf(randLvl));
            properties.setNature("rash");
            PokemonEntity pokemonEntity2 = properties.createEntity(world);
            pokemonEntity2.method_23327((double)spawnPos.method_10263(), (double)spawnPos.method_10264(), (double)spawnPos.method_10260());
            Pokemon pokemon = pokemonEntity2.getPokemon();
            pokemon.sendOut((class_3218)world, spawnPos.method_46558(), null, pkmnE -> null);
        }
        randTicks = 0;
        randQuantity = 0;
        entity.ticksSinceLast = 0;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 blockState, PokemonSpawnerBlockEntity entity) {
        if (!world.field_9236 && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (!entity.bricked && serverWorld.method_8510() % 10L == 0L) {
                double x = blockPos.method_10263();
                double y = blockPos.method_10264();
                double z = blockPos.method_10260();
                class_3222 player = null;
                if (serverWorld.method_18459(x, y, z, 16.0, true) == null) {
                    return;
                }
                player = (class_3222)serverWorld.method_18459(x, y, z, 16.0, true);
                if (closestPlayer != player) {
                    PokemonSpawnerBlockEntity.setClosestPlayer(player);
                }
                PokemonSpawnerBlockEntity.getPlayerAvgLvl();
                if (PokemonSpawnerBlockEntity.initRandom(world, entity)) {
                    PokemonSpawnerBlockEntity.checkTicks(world, blockPos, blockState, entity);
                }
                entity.ticksSinceLast += 10;
            }
        }
    }

    private static void getPlayerAvgLvl() {
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(closestPlayer);
        int partySize = 0;
        for (int i = 0; i < party.size(); ++i) {
            if (party.get(i) == null) continue;
            playerAvgLvl += party.get(i).getLevel();
            ++partySize;
        }
        if (partySize != 0) {
            playerAvgLvl = Math.round((float)playerAvgLvl / (float)partySize);
        }
    }

    private static void setClosestPlayer(class_3222 player) {
        closestPlayer = player;
    }

    private static boolean isClearForSpawn(class_1922 blockView, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (state.method_26234(blockView, pos)) {
            return false;
        }
        if (state.method_26219()) {
            return false;
        }
        return fluidState.method_15769();
    }
}

