/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.fusion;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.components.MegaShowdownDataComponents;
import com.github.yajatkaul.mega_showdown.components.PokemonStorge;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import com.github.yajatkaul.mega_showdown.utils.PlayerUtils;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_9334;

public class SoloFusion
extends ToolTipItem {
    private final List<String> fusions;
    private final List<String> pokemons;
    private final List<String> mainPokemons;
    private final String namespace;
    private final String effectId;
    private final List<String> applyAspect;
    private final List<String> revertAspect;

    public SoloFusion(class_1792.class_1793 properties, List<String> fusions, List<String> pokemons, List<String> mainPokemons, String effectId, List<String> applyAspect, List<String> revertAspect, String namespace) {
        super(properties);
        this.fusions = fusions;
        this.pokemons = pokemons;
        this.mainPokemons = mainPokemons;
        this.namespace = namespace;
        this.effectId = effectId;
        this.applyAspect = applyAspect;
        this.revertAspect = revertAspect;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (level.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        class_3966 hitResult = PlayerUtils.getEntityLookingAt(player, 4.5f);
        class_1297 entity = null;
        if (hitResult != null) {
            entity = hitResult.method_17782();
        }
        class_5455 registryAccess = level.method_30349();
        PokemonStorge pokemonStorge = (PokemonStorge)stack.method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(registryAccess);
        PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty((class_3222)player);
        if (entity instanceof PokemonEntity) {
            PokemonEntity pokemonEntity = (PokemonEntity)entity;
            Pokemon pokemon = pokemonEntity.getPokemon();
            if (pokemon.getOwnerPlayer() != player || pokemonEntity.isBattling() || pokemon.getPersistentData().method_10545("form_changing") || pokemonEntity.getTethering() != null) {
                return class_1271.method_22430((Object)stack);
            }
            boolean isMain = this.mainPokemons.contains(pokemon.getSpecies().getName());
            boolean isFusion = this.pokemons.contains(pokemon.getSpecies().getName());
            if (isMain && this.checkEnabled(pokemon)) {
                if (pokemonStored != null) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.mega_showdown.already_fused").method_27692(class_124.field_1061), true);
                    return class_1271.method_22430((Object)stack);
                }
                Effect.getEffect(this.effectId).revertEffects(pokemon, this.revertAspect, null);
                pokemon.setTradeable(true);
                Pokemon pokemonInside = Pokemon.Companion.loadFromNBT(level.method_30349(), pokemon.getPersistentData().method_10562("fusion_pokemon"));
                playerPartyStore.add(pokemonInside);
                pokemon.getPersistentData().method_10551("fusion_forme");
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored != null && isMain) {
                Effect.getEffect(this.effectId).revertEffects(pokemon, this.applyAspect, null);
                pokemon.setTradeable(false);
                class_2487 otherPokemonNbt = pokemonStored.saveToNBT(level.method_30349(), new class_2487());
                pokemon.getPersistentData().method_10566("fusion_pokemon", (class_2520)otherPokemonNbt);
                stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
            } else if (pokemonStored == null && isFusion) {
                stack.method_57379(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)pokemonStorge.save(registryAccess, pokemon));
                stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".charged")));
                playerPartyStore.remove(pokemon);
            }
        } else if (pokemonStored != null) {
            playerPartyStore.add(pokemonStored);
            stack.method_57381(MegaShowdownDataComponents.POKEMON_STORAGE.get());
            stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)("item.mega_showdown." + this.namespace + ".inactive")));
        }
        return class_1271.method_22430((Object)stack);
    }

    private boolean checkEnabled(Pokemon pokemon) {
        return pokemon.getAspects().stream().anyMatch(this.fusions::contains);
    }

    public void method_33261(class_1542 itemEntity) {
        class_1297 class_12972;
        PokemonStorge pokemonStorge = (PokemonStorge)itemEntity.method_6983().method_57825(MegaShowdownDataComponents.POKEMON_STORAGE.get(), (Object)PokemonStorge.defaultStorage());
        Pokemon pokemonStored = pokemonStorge.getPokemon(itemEntity.method_56673());
        if (pokemonStored != null && (class_12972 = itemEntity.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            playerPartyStore.add(pokemonStored);
        }
    }
}

