/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.advancement.AdvancementHelper;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.PokemonSelectingBlockItem;
import java.util.List;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RotomUnitItem
extends PokemonSelectingBlockItem {
    private static final List<String> rotomAspects = List.of("heat-appliance", "wash-appliance", "mow-appliance", "frost-appliance", "fan-appliance");
    private final String form;

    public RotomUnitItem(class_2248 block, class_1792.class_1793 properties, String form) {
        super(block, properties);
        this.form = form;
    }

    @Nullable
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 serverPlayer, @NotNull class_1799 itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(itemStack, pokemon)) {
            return class_1271.method_22431((Object)itemStack);
        }
        Effect.getEffect("mega_showdown:rotom_" + this.form + "_effect").applyEffects(pokemon, List.of(String.format("appliance=%s", this.form)), null);
        itemStack.method_57008(1, (class_1309)serverPlayer);
        AdvancementHelper.grantAdvancement(serverPlayer, "rotom/rotom_form_change");
        return class_1271.method_22427((Object)itemStack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseOnPokemon(@NotNull class_1799 stack, @NotNull Pokemon pokemon) {
        if (!pokemon.getSpecies().getName().equals("Rotom")) return false;
        if (!pokemon.getAspects().stream().noneMatch(rotomAspects::contains)) return false;
        if (pokemon.getPersistentData().method_10545("form_changing")) return false;
        return true;
    }
}

