/*
 * Decompiled with CFR 0.152.
 */
package com.github.yajatkaul.mega_showdown.item.custom.form_change;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.github.yajatkaul.mega_showdown.codec.Effect;
import com.github.yajatkaul.mega_showdown.item.custom.ToolTipItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import org.jetbrains.annotations.Nullable;

public class FormChangeHeldItem
extends ToolTipItem {
    private final String revertAspect;
    private final String applyAspect;
    private final List<String> pokemons;
    private final String effectId;
    private final boolean tradable;
    @Nullable
    private final Consumer<Pokemon> onApplyCallback;
    @Nullable
    private final Consumer<Pokemon> onRevertCallback;

    public FormChangeHeldItem(class_1792.class_1793 properties, String revertAspect, String applyAspect, List<String> pokemons, String effectId, boolean tradable, @Nullable Consumer<Pokemon> onApplyCallback, @Nullable Consumer<Pokemon> onRevertCallback) {
        super(properties);
        this.revertAspect = revertAspect;
        this.applyAspect = applyAspect;
        this.pokemons = pokemons;
        this.effectId = effectId;
        this.tradable = tradable;
        this.onApplyCallback = onApplyCallback;
        this.onRevertCallback = onRevertCallback;
    }

    public void apply(Pokemon pokemon) {
        if (this.pokemons.contains(pokemon.getSpecies().getName())) {
            if (this.onApplyCallback != null) {
                this.onApplyCallback.accept(pokemon);
            }
            Effect.getEffect(this.effectId).applyEffects(pokemon, List.of(this.applyAspect), null);
            if (!this.tradable) {
                pokemon.setTradeable(false);
            }
        }
    }

    public void revert(Pokemon pokemon) {
        if (this.pokemons.contains(pokemon.getSpecies().getName())) {
            if (this.onRevertCallback != null) {
                this.onRevertCallback.accept(pokemon);
            }
            Effect.getEffect(this.effectId).revertEffects(pokemon, List.of(this.revertAspect), null);
            if (!this.tradable) {
                pokemon.setTradeable(true);
            }
        }
    }
}

